/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.http.tomcat;

import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.catalina.realm.RealmBase;
import org.apache.tuscany.sca.host.http.UserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatPolicyBaseRealm
extends RealmBase {
    private static final String REALM_NAME = "Tuscany Realm";
    private Map<String, UserContext> userMap = new HashMap<String, UserContext>();

    public TomcatPolicyBaseRealm(List<UserContext> users) {
        for (UserContext userContext : users) {
            this.userMap.put(userContext.getUsername(), userContext);
        }
    }

    protected String getName() {
        return REALM_NAME;
    }

    protected String getPassword(String username) {
        UserContext userContext = this.userMap.get(username);
        if (userContext != null) {
            return userContext.getPassword();
        }
        return null;
    }

    protected Principal getPrincipal(String username) {
        UserContext userContext = this.userMap.get(username);
        if (userContext != null) {
            TuscanyPrincipal principal = new TuscanyPrincipal(userContext.getUsername());
            return principal;
        }
        return null;
    }

    public boolean hasRole(Principal principal, String role) {
        UserContext userContext = this.userMap.get(principal.getName());
        return userContext != null && userContext.getRoles().contains(role);
    }

    class TuscanyPrincipal
    implements Principal {
        private final String username;

        TuscanyPrincipal(String username) {
            this.username = username;
        }

        public String getName() {
            return this.username;
        }
    }
}

