/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.http.tomcat;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.naming.resources.FileDirContext;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.naming.resources.Resource;

public class TomcatDefaultServlet
extends DefaultServlet {
    private static final long serialVersionUID = -7503581551326796573L;
    private String documentRoot;
    private ProxyDirContext proxyDirContext;

    public TomcatDefaultServlet(String servletPath, String documentRoot) {
        FileDirContext dirContext;
        this.documentRoot = documentRoot;
        URI uri = URI.create(documentRoot);
        if (!"file".equals(uri.getScheme())) {
            dirContext = new FileDirContext(){

                public Attributes getAttributes(String name) throws NamingException {
                    return new BasicAttributes();
                }

                public Object lookup(String name) throws NamingException {
                    try {
                        final URL url = new URL(TomcatDefaultServlet.this.documentRoot + name);
                        return new Resource(){

                            public InputStream streamContent() throws IOException {
                                URLConnection connection = url.openConnection();
                                connection.setUseCaches(false);
                                return connection.getInputStream();
                            }
                        };
                    }
                    catch (MalformedURLException e) {
                        throw new NamingException(e.toString());
                    }
                }
            };
        } else {
            dirContext = new FileDirContext();
            dirContext.setDocBase(uri.getPath());
        }
        this.resources = this.proxyDirContext = new ProxyDirContext(new Hashtable(), (DirContext)dirContext);
    }

    public void init() throws ServletException {
        super.init();
        this.resources = this.proxyDirContext;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.resources = this.proxyDirContext;
    }

    protected String getRelativePath(HttpServletRequest request) {
        String path = request.getPathInfo();
        if (path == null || path.length() == 0) {
            path = "/";
        }
        return path;
    }
}

