/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2.policy.authentication.token;

import java.util.List;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.ws.axis2.policy.authentication.token.Axis2TokenAuthenticationPolicy;
import org.apache.tuscany.sca.binding.ws.axis2.policy.authentication.token.Axis2TokenAuthenticationServicePolicyInterceptor;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySetAttachPoint;
import org.apache.tuscany.sca.provider.PolicyProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;

public class Axis2TokenAuthenticationServicePolicyProvider
implements PolicyProvider {
    private RuntimeComponent component;
    private RuntimeComponentService service;
    private Binding binding;

    public Axis2TokenAuthenticationServicePolicyProvider(RuntimeComponent component, RuntimeComponentService service, Binding binding) {
        this.component = component;
        this.service = service;
        this.binding = binding;
    }

    private PolicySet findPolicySet() {
        if (this.binding instanceof PolicySetAttachPoint) {
            List policySets = ((PolicySetAttachPoint)this.binding).getApplicablePolicySets();
            for (PolicySet ps : policySets) {
                for (Object p : ps.getPolicies()) {
                    if (!Axis2TokenAuthenticationPolicy.class.isInstance(p)) continue;
                    return ps;
                }
            }
        }
        return null;
    }

    private String getContext() {
        return "component.service: " + this.component.getURI() + "#" + this.service.getName() + "(" + this.binding.getClass().getName() + ")";
    }

    public Interceptor createInterceptor(Operation operation) {
        PolicySet ps = this.findPolicySet();
        return ps == null ? null : new Axis2TokenAuthenticationServicePolicyInterceptor(this.getContext(), operation, ps);
    }

    public String getPhase() {
        return "service.policy";
    }
}

