/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2.policy.authentication.token;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.binding.ws.axis2.policy.authentication.token.Axis2TokenAuthenticationPolicy;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis2TokenAuthenticationPolicyProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<Axis2TokenAuthenticationPolicy> {
    public QName getArtifactType() {
        return Axis2TokenAuthenticationPolicy.AXIS2_TOKEN_AUTHENTICATION_POLICY_QNAME;
    }

    public Axis2TokenAuthenticationPolicyProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
    }

    public Axis2TokenAuthenticationPolicy read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        Axis2TokenAuthenticationPolicy policy = new Axis2TokenAuthenticationPolicy();
        int event = reader.getEventType();
        QName name = null;
        while (reader.hasNext()) {
            event = reader.getEventType();
            switch (event) {
                case 1: {
                    name = reader.getName();
                    if (!name.equals(this.getArtifactType())) break;
                    policy.setTokenName(this.getQName(reader, "tokenName"));
                }
            }
            if (event == 2 && this.getArtifactType().equals(reader.getName())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return policy;
    }

    public void write(Axis2TokenAuthenticationPolicy policy, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        String prefix = "tuscany";
        writer.writeStartElement(prefix, this.getArtifactType().getLocalPart(), this.getArtifactType().getNamespaceURI());
        writer.writeNamespace("tuscany", "http://tuscany.apache.org/xmlns/sca/1.0");
        if (policy.getTokenName() != null) {
            writer.writeStartElement(prefix, "tokenName", this.getArtifactType().getNamespaceURI());
            writer.writeCharacters(policy.getTokenName().toString());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public Class<Axis2TokenAuthenticationPolicy> getModelType() {
        return Axis2TokenAuthenticationPolicy.class;
    }

    public void resolve(Axis2TokenAuthenticationPolicy arg0, ModelResolver arg1) throws ContributionResolveException {
    }
}

