/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.sugarcrm;

import com.sugarcrm.ws.soap.GetEntryListResultVersion2;
import com.sugarcrm.ws.soap.LinkNamesToFieldsArray;
import com.sugarcrm.ws.soap.SelectFields;
import com.sugarcrm.ws.soap.SugarsoapPortType;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.metamodel.data.AbstractDataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.DefaultRow;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.sugarcrm.SugarCrmXmlHelper;
import org.apache.metamodel.util.BooleanComparator;
import org.apache.metamodel.util.NumberComparator;
import org.apache.metamodel.util.TimeComparator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class SugarCrmDataSet
extends AbstractDataSet {
    private final SugarsoapPortType _service;
    private final String _session;
    private final AtomicInteger _recordIndex = new AtomicInteger();
    private GetEntryListResultVersion2 _entryList;
    private List<Object> _records;
    private Node _record;

    public SugarCrmDataSet(Column[] columns, SugarsoapPortType service, String session, GetEntryListResultVersion2 entryList) {
        super(columns);
        this._service = service;
        this._session = session;
        this._entryList = entryList;
        this._records = this._entryList.getEntryList().getAny();
        this._record = null;
    }

    protected GetEntryListResultVersion2 getEntryList() {
        return this._entryList;
    }

    public boolean next() {
        int index = this._recordIndex.getAndIncrement();
        if (index >= this._records.size()) {
            int nextOffset = this._entryList.getNextOffset();
            if (nextOffset == this._entryList.getTotalCount()) {
                this._record = null;
                return false;
            }
            DataSetHeader header = this.getHeader();
            SelectItem[] selectItems = header.getSelectItems();
            Column[] columns = new Column[selectItems.length];
            for (int i = 0; i < columns.length; ++i) {
                columns[i] = selectItems[i].getColumn();
            }
            String moduleName = selectItems[0].getColumn().getTable().getName();
            SelectFields selectFields = SugarCrmXmlHelper.createSelectFields(columns);
            this._entryList = this._service.getEntryList(this._session, moduleName, "", "", nextOffset, selectFields, new LinkNamesToFieldsArray(), 200, 0, false);
            this._records = this._entryList.getEntryList().getAny();
            this._recordIndex.set(0);
            return this.next();
        }
        this._record = (Node)this._records.get(index);
        return true;
    }

    public Row getRow() {
        String value;
        if (this._record == null) {
            return null;
        }
        DataSetHeader header = this.getHeader();
        Object[] values = new Object[header.size()];
        Element nameValueList = SugarCrmXmlHelper.getChildElement(this._record, "name_value_list");
        List<Element> nameValueItems = SugarCrmXmlHelper.getChildElements(nameValueList);
        HashMap<String, String> valueMap = new HashMap<String, String>();
        for (Element nameValueItem : nameValueItems) {
            String name = SugarCrmXmlHelper.getChildElementText(nameValueItem, "name");
            value = SugarCrmXmlHelper.getChildElementText(nameValueItem, "value");
            valueMap.put(name, value);
        }
        for (int i = 0; i < values.length; ++i) {
            Object parsedValue;
            Column column = header.getSelectItem(i).getColumn();
            String fieldName = column.getName();
            value = (String)valueMap.get(fieldName);
            values[i] = parsedValue = this.convert(value, column.getType());
        }
        return new DefaultRow(header, values);
    }

    private Object convert(String value, ColumnType type) {
        if (value == null) {
            return null;
        }
        if (type == null) {
            return value;
        }
        Object result = type.isNumber() ? NumberComparator.toNumber((Object)value) : (type.isBoolean() ? BooleanComparator.toBoolean((Object)value) : (type.isTimeBased() ? TimeComparator.toDate((Object)value) : value));
        if (result == null) {
            throw new IllegalStateException("Failed to convert value '" + value + "' to type: " + type);
        }
        return result;
    }
}

