/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Map;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.data.Document;
import org.apache.metamodel.data.DocumentSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JsonDocumentSource
implements DocumentSource {
    private static final Logger logger = LoggerFactory.getLogger(JsonDocumentSource.class);
    private final JsonParser _parser;
    private final String _sourceCollectionName;

    public JsonDocumentSource(JsonParser parser, String sourceCollectionName) {
        this._parser = parser;
        this._sourceCollectionName = sourceCollectionName;
    }

    public Document next() {
        JsonToken token;
        do {
            if ((token = this.getNextToken()) != null) continue;
            return null;
        } while (token != JsonToken.START_OBJECT);
        Map<String, ?> value = this.readValue();
        return new Document(this._sourceCollectionName, value, value);
    }

    private Map<String, ?> readValue() {
        try {
            return (Map)this._parser.readValueAs(Map.class);
        }
        catch (Exception e) {
            throw new MetaModelException(e);
        }
    }

    private JsonToken getNextToken() {
        try {
            return this._parser.nextToken();
        }
        catch (Exception e) {
            throw new MetaModelException(e);
        }
    }

    public void close() {
        try {
            this._parser.close();
        }
        catch (IOException e) {
            logger.warn("Failed to ");
        }
    }
}

