/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.metamodel.data.AbstractDataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.elasticsearch.ElasticSearchDataContext;
import org.apache.metamodel.elasticsearch.ElasticSearchUtils;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.elasticsearch.action.search.ClearScrollRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.search.SearchHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ElasticSearchDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchDataSet.class);
    private final Client _client;
    private final AtomicBoolean _closed;
    private SearchResponse _searchResponse;
    private SearchHit _currentHit;
    private int _hitIndex = 0;

    public ElasticSearchDataSet(Client client, SearchResponse searchResponse, List<SelectItem> selectItems, boolean queryPostProcessed) {
        super(selectItems);
        this._client = client;
        this._searchResponse = searchResponse;
        this._closed = new AtomicBoolean(false);
    }

    public ElasticSearchDataSet(Client client, SearchResponse searchResponse, Column[] columns, boolean queryPostProcessed) {
        super(columns);
        this._client = client;
        this._searchResponse = searchResponse;
        this._closed = new AtomicBoolean(false);
    }

    public void close() {
        super.close();
        boolean closeNow = this._closed.compareAndSet(true, false);
        if (closeNow) {
            ClearScrollRequestBuilder scrollRequestBuilder = new ClearScrollRequestBuilder(this._client).addScrollId(this._searchResponse.getScrollId());
            scrollRequestBuilder.execute();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this._closed.get()) {
            logger.warn("finalize() invoked, but DataSet is not closed. Invoking close() on {}", (Object)this);
            this.close();
        }
    }

    public boolean next() {
        SearchHit[] hits = this._searchResponse.getHits().hits();
        if (hits.length == 0) {
            this._currentHit = null;
            return false;
        }
        if (this._hitIndex < hits.length) {
            this._currentHit = hits[this._hitIndex];
            ++this._hitIndex;
            return true;
        }
        String scrollId = this._searchResponse.getScrollId();
        if (scrollId == null) {
            this._currentHit = null;
            return false;
        }
        this._searchResponse = (SearchResponse)this._client.prepareSearchScroll(scrollId).setScroll(ElasticSearchDataContext.TIMEOUT_SCROLL).execute().actionGet();
        this._hitIndex = 0;
        return this.next();
    }

    public Row getRow() {
        if (this._currentHit == null) {
            return null;
        }
        Map source = this._currentHit.getSource();
        String documentId = this._currentHit.getId();
        Row row = ElasticSearchUtils.createRow(source, documentId, this.getHeader());
        return row;
    }
}

