/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.csv;

import au.com.bytecode.opencsv.CSVParser;
import java.io.IOException;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.csv.InconsistentRowLengthException;
import org.apache.metamodel.csv.SingleLineCsvDataSet;
import org.apache.metamodel.data.AbstractRow;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.Style;
import org.apache.metamodel.schema.Column;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SingleLineCsvRow
extends AbstractRow {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(SingleLineCsvRow.class);
    private final SingleLineCsvDataSet _dataSet;
    private final String _line;
    private final int _columnsInTable;
    private final boolean _failOnInconsistentRowLength;
    private final int _rowNumber;
    private String[] _values;

    public SingleLineCsvRow(SingleLineCsvDataSet dataSet, String line, int columnsInTable, boolean failOnInconsistentRowLength, int rowNumber) {
        this._dataSet = dataSet;
        this._line = line;
        this._columnsInTable = columnsInTable;
        this._failOnInconsistentRowLength = failOnInconsistentRowLength;
        this._rowNumber = rowNumber;
        this._values = null;
    }

    private String[] getValuesInternal() {
        if (this._values == null) {
            String[] csvValues = this.parseLine();
            if (this._failOnInconsistentRowLength && this._columnsInTable != csvValues.length) {
                throw new InconsistentRowLengthException(this._columnsInTable, (Row)this, csvValues, this._rowNumber);
            }
            DataSetHeader header = this._dataSet.getHeader();
            int size = header.size();
            String[] rowValues = new String[size];
            for (int i = 0; i < size; ++i) {
                Column column = header.getSelectItem(i).getColumn();
                int columnNumber = column.getColumnNumber();
                rowValues[i] = columnNumber < csvValues.length ? csvValues[columnNumber] : null;
            }
            this._values = rowValues;
        }
        return this._values;
    }

    private String[] parseLine() {
        try {
            CSVParser parser = this._dataSet.getCsvParser();
            return parser.parseLine(this._line);
        }
        catch (IOException e) {
            if (this._failOnInconsistentRowLength) {
                throw new MetaModelException("Failed to parse CSV line no. " + this._rowNumber + ": " + this._line, (Exception)e);
            }
            logger.warn("Encountered unparseable line no. {}, returning line as a single value with trailing nulls: {}", (Object)this._rowNumber, (Object)this._line);
            String[] csvValues = new String[this._columnsInTable];
            csvValues[0] = this._line;
            return csvValues;
        }
    }

    public Object getValue(int index) throws IndexOutOfBoundsException {
        String[] values = this.getValuesInternal();
        assert (values != null);
        return values[index];
    }

    public Style getStyle(int index) throws IndexOutOfBoundsException {
        return Style.NO_STYLE;
    }

    protected DataSetHeader getHeader() {
        return this._dataSet.getHeader();
    }
}

