/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.war.util.DependencyInfo;
import org.apache.maven.plugin.war.util.PathSet;
import org.apache.maven.plugin.war.util.WarUtils;
import org.codehaus.plexus.util.StringUtils;

public class WebappStructure {
    private Map registeredFiles;
    private List dependenciesInfo;
    private transient PathSet allFiles = new PathSet();
    private transient WebappStructure cache;

    public WebappStructure(List dependencies) {
        this.dependenciesInfo = this.createDependenciesInfoList(dependencies);
        this.registeredFiles = new HashMap();
        this.cache = null;
    }

    public WebappStructure(List dependencies, WebappStructure cache) {
        this.dependenciesInfo = this.createDependenciesInfoList(dependencies);
        this.registeredFiles = new HashMap();
        this.cache = cache == null ? new WebappStructure(dependencies) : cache;
    }

    public List getDependenciesInfo() {
        return this.dependenciesInfo;
    }

    public List getDependencies() {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        if (this.dependenciesInfo == null) {
            return result;
        }
        for (DependencyInfo dependencyInfo : this.dependenciesInfo) {
            result.add(dependencyInfo.getDependency());
        }
        return result;
    }

    public boolean isRegistered(String path) {
        return this.getFullStructure().contains(path);
    }

    public boolean registerFile(String id, String path) {
        if (!this.isRegistered(path)) {
            this.doRegister(id, path);
            return true;
        }
        return false;
    }

    public boolean registerFileForced(String id, String path) {
        if (!this.isRegistered(path)) {
            this.doRegister(id, path);
            return false;
        }
        this.getStructure(this.getOwner(path)).remove(path);
        this.getStructure(id).add(path);
        return true;
    }

    public void registerFile(String id, String path, RegistrationCallback callback) throws IOException {
        if (this.isRegistered(path)) {
            callback.refused(id, path, this.getOwner(path));
        } else {
            this.doRegister(id, path);
            if (this.cache.getOwner(path) == null) {
                callback.registered(id, path);
            } else if (this.cache.getOwner(path).equals(id)) {
                callback.alreadyRegistered(id, path);
            } else if (this.getOwners().contains(this.cache.getOwner(path))) {
                callback.superseded(id, path, this.cache.getOwner(path));
            } else {
                callback.supersededUnknownOwner(id, path, this.cache.getOwner(path));
            }
        }
    }

    public String getOwner(String path) {
        if (!this.isRegistered(path)) {
            return null;
        }
        for (String owner : this.registeredFiles.keySet()) {
            PathSet structure = this.getStructure(owner);
            if (!structure.contains(path)) continue;
            return owner;
        }
        throw new IllegalStateException("Should not happen, path [" + path + "] is flagged as being registered but was not found.");
    }

    public Set getOwners() {
        return this.registeredFiles.keySet();
    }

    public PathSet getFullStructure() {
        return this.allFiles;
    }

    public PathSet getStructure(String id) {
        PathSet pathSet = (PathSet)this.registeredFiles.get(id);
        if (pathSet == null) {
            pathSet = new PathSet();
            this.registeredFiles.put(id, pathSet);
        }
        return pathSet;
    }

    public void analyseDependencies(DependenciesAnalysisCallback callback) {
        if (callback == null) {
            throw new NullPointerException("Callback could not be null.");
        }
        if (this.cache == null) {
            return;
        }
        ArrayList currentDependencies = new ArrayList(this.getDependencies());
        ArrayList previousDependencies = new ArrayList(this.cache.getDependencies());
        ListIterator it = currentDependencies.listIterator();
        while (it.hasNext()) {
            Dependency dependency = (Dependency)it.next();
            Dependency matchingDependency = this.matchDependency(previousDependencies, dependency);
            if (matchingDependency != null) {
                callback.unchangedDependency(dependency);
                it.remove();
                previousDependencies.remove(matchingDependency);
                continue;
            }
            Dependency previousDep = this.findDependency(dependency, previousDependencies);
            if (previousDep == null) {
                callback.newDependency(dependency);
                it.remove();
                continue;
            }
            if (!dependency.getVersion().equals(previousDep.getVersion())) {
                callback.updatedVersion(dependency, previousDep.getVersion());
                it.remove();
                previousDependencies.remove(previousDep);
                continue;
            }
            if (!dependency.getScope().equals(previousDep.getScope())) {
                callback.updatedScope(dependency, previousDep.getScope());
                it.remove();
                previousDependencies.remove(previousDep);
                continue;
            }
            if (dependency.isOptional() != previousDep.isOptional()) {
                callback.updatedOptionalFlag(dependency, previousDep.isOptional());
                it.remove();
                previousDependencies.remove(previousDep);
                continue;
            }
            callback.updatedUnknown(dependency, previousDep);
            it.remove();
            previousDependencies.remove(previousDep);
        }
        for (Dependency dependency : previousDependencies) {
            callback.removedDependency(dependency);
        }
    }

    public void registerTargetFileName(Artifact artifact, String targetFileName) {
        if (this.dependenciesInfo != null) {
            for (DependencyInfo dependencyInfo : this.dependenciesInfo) {
                if (!WarUtils.isRelated(artifact, dependencyInfo.getDependency())) continue;
                dependencyInfo.setTargetFileName(targetFileName);
            }
        }
    }

    public String getCachedTargetFileName(Dependency dependency) {
        if (this.cache == null) {
            return null;
        }
        for (DependencyInfo dependencyInfo : this.cache.getDependenciesInfo()) {
            Dependency dependency2 = dependencyInfo.getDependency();
            if (!StringUtils.equals((String)dependency.getGroupId(), (String)dependency2.getGroupId()) || !StringUtils.equals((String)dependency.getArtifactId(), (String)dependency2.getArtifactId()) || !StringUtils.equals((String)dependency.getType(), (String)dependency2.getType()) || !StringUtils.equals((String)dependency.getClassifier(), (String)dependency2.getClassifier())) continue;
            return dependencyInfo.getTargetFileName();
        }
        return null;
    }

    private void doRegister(String id, String path) {
        this.getFullStructure().add(path);
        this.getStructure(id).add(path);
    }

    private Dependency findDependency(Dependency dependency, List dependencies) {
        for (Dependency dep : dependencies) {
            if (!dependency.getGroupId().equals(dep.getGroupId()) || !dependency.getArtifactId().equals(dep.getArtifactId()) || !dependency.getType().equals(dep.getType()) || (dependency.getClassifier() != null || dep.getClassifier() != null) && (dependency.getClassifier() == null || !dependency.getClassifier().equals(dep.getClassifier()))) continue;
            return dep;
        }
        return null;
    }

    private Dependency matchDependency(List dependencies, Dependency dependency) {
        for (Dependency dep : dependencies) {
            if (!WarUtils.dependencyEquals(dep, dependency)) continue;
            return dep;
        }
        return null;
    }

    private List createDependenciesInfoList(List dependencies) {
        if (dependencies == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DependencyInfo> result = new ArrayList<DependencyInfo>();
        for (Dependency dependency : dependencies) {
            result.add(new DependencyInfo(dependency));
        }
        return result;
    }

    private Object readResolve() {
        this.allFiles = new PathSet();
        for (PathSet pathSet : this.registeredFiles.values()) {
            this.allFiles.addAll(pathSet);
        }
        return this;
    }

    public static interface DependenciesAnalysisCallback {
        public void unchangedDependency(Dependency var1);

        public void newDependency(Dependency var1);

        public void removedDependency(Dependency var1);

        public void updatedVersion(Dependency var1, String var2);

        public void updatedScope(Dependency var1, String var2);

        public void updatedOptionalFlag(Dependency var1, boolean var2);

        public void updatedUnknown(Dependency var1, Dependency var2);
    }

    public static interface RegistrationCallback {
        public void registered(String var1, String var2) throws IOException;

        public void alreadyRegistered(String var1, String var2) throws IOException;

        public void refused(String var1, String var2, String var3) throws IOException;

        public void superseded(String var1, String var2, String var3) throws IOException;

        public void supersededUnknownOwner(String var1, String var2, String var3) throws IOException;
    }
}

