/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.common.LeaderElectionNotNeededException;
import kafka.common.NoReplicaOnlineException;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NoOpLeaderSelector;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderSelector;
import kafka.controller.PartitionState;
import kafka.controller.StateChangeLogger;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ReplicationUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tWM\u0003\u0002\u0004\t\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011\r\u0001!\u0011!Q\u0001\nU\u0001\"AF\f\u000e\u0003\tI!\u0001\u0007\u0002\u0003\u001f-\u000bgm[1D_:$(o\u001c7mKJD\u0001B\u0007\u0001\u0003\u0002\u0003\u0006IaG\u0001\u0012gR\fG/Z\"iC:<W\rT8hO\u0016\u0014\bC\u0001\f\u001d\u0013\ti\"AA\tTi\u0006$Xm\u00115b]\u001e,Gj\\4hKJDQa\b\u0001\u0005\u0002\u0001\na\u0001P5oSRtDcA\u0011#GA\u0011a\u0003\u0001\u0005\u0006\u0007y\u0001\r!\u0006\u0005\u00065y\u0001\ra\u0007\u0005\bK\u0001\u0011\r\u0011\"\u0003'\u0003E\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010^\u000b\u0002OA\u0011a\u0003K\u0005\u0003S\t\u0011\u0011cQ8oiJ|G\u000e\\3s\u0007>tG/\u001a=u\u0011\u0019Y\u0003\u0001)A\u0005O\u0005\u00112m\u001c8ue>dG.\u001a:D_:$X\r\u001f;!\u0011\u001di\u0003A1A\u0005\n9\nAbY8oiJ|G\u000e\\3s\u0013\u0012,\u0012a\f\t\u0003\u0013AJ!!\r\u0006\u0003\u0007%sG\u000f\u0003\u00044\u0001\u0001\u0006IaL\u0001\u000eG>tGO]8mY\u0016\u0014\u0018\n\u001a\u0011\t\u000fU\u0002!\u0019!C\u0005m\u00059!p[+uS2\u001cX#A\u001c\u0011\u0005=A\u0014BA\u001d\u0011\u0005\u001dQ6.\u0016;jYNDaa\u000f\u0001!\u0002\u00139\u0014\u0001\u0003>l+RLGn\u001d\u0011\t\u000fu\u0002!\u0019!C\u0005}\u0005q\u0001/\u0019:uSRLwN\\*uCR,W#A \u0011\t\u0001+u)T\u0007\u0002\u0003*\u0011!iQ\u0001\b[V$\u0018M\u00197f\u0015\t!%\"\u0001\u0006d_2dWm\u0019;j_:L!AR!\u0003\u00075\u000b\u0007\u000f\u0005\u0002I\u00176\t\u0011J\u0003\u0002K\t\u000511m\\7n_:L!\u0001T%\u0003#Q{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002\u0017\u001d&\u0011qJ\u0001\u0002\u000f!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0011\u0019\t\u0006\u0001)A\u0005\u007f\u0005y\u0001/\u0019:uSRLwN\\*uCR,\u0007\u0005C\u0004T\u0001\t\u0007I\u0011\u0002+\u0002%\t\u0014xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r[\u000b\u0002+B\u0011aCV\u0005\u0003/\n\u0011AdQ8oiJ|G\u000e\\3s\u0005J|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007\u000e\u0003\u0004Z\u0001\u0001\u0006I!V\u0001\u0014EJ|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007\u000e\t\u0005\b7\u0002\u0011\r\u0011\"\u0003]\u0003mqwn\u00149QCJ$\u0018\u000e^5p]2+\u0017\rZ3s'\u0016dWm\u0019;peV\tQ\f\u0005\u0002\u0017=&\u0011qL\u0001\u0002\u0013\u001d>|\u0005\u000fT3bI\u0016\u00148+\u001a7fGR|'\u000f\u0003\u0004b\u0001\u0001\u0006I!X\u0001\u001d]>|\u0005\u000fU1si&$\u0018n\u001c8MK\u0006$WM]*fY\u0016\u001cGo\u001c:!\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0003\u001d\u0019H/\u0019:ukB$\u0012!\u001a\t\u0003\u0013\u0019L!a\u001a\u0006\u0003\tUs\u0017\u000e\u001e\u0005\u0006S\u0002!\t\u0001Z\u0001\tg\",H\u000fZ8x]\")1\u000e\u0001C\u0001I\u0006\tCO]5hO\u0016\u0014xJ\u001c7j]\u0016\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001c\u0005.\u00198hK\")Q\u000e\u0001C\u0001]\u0006\t\u0002/\u0019:uSRLwN\\:J]N#\u0018\r^3\u0015\u0005=\u001c\bc\u00019r\u000f6\t1)\u0003\u0002s\u0007\n\u00191+\u001a;\t\u000bQd\u0007\u0019A'\u0002\u000bM$\u0018\r^3\t\u000bY\u0004A\u0011A<\u0002%!\fg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u000b\u0007KbTH0a\u0001\t\u000be,\b\u0019A8\u0002\u0015A\f'\u000f^5uS>t7\u000fC\u0003|k\u0002\u0007Q*A\u0006uCJ<W\r^*uCR,\u0007bB?v!\u0003\u0005\rA`\u0001\u000fY\u0016\fG-\u001a:TK2,7\r^8s!\t1r0C\u0002\u0002\u0002\t\u0011q\u0003U1si&$\u0018n\u001c8MK\u0006$WM]*fY\u0016\u001cGo\u001c:\t\u0013\u0005\u0015Q\u000f%AA\u0002\u0005\u001d\u0011!C2bY2\u0014\u0017mY6t!\r1\u0012\u0011B\u0005\u0004\u0003\u0017\u0011!!C\"bY2\u0014\u0017mY6t\u0011\u001d\ty\u0001\u0001C\u0005\u0003#\t\u0011\u0003[1oI2,7\u000b^1uK\u000eC\u0017M\\4f)-)\u00171CA\u0017\u0003c\t\u0019$!\u000e\t\u0011\u0005U\u0011Q\u0002a\u0001\u0003/\tQ\u0001^8qS\u000e\u0004B!!\u0007\u0002(9!\u00111DA\u0012!\r\tiBC\u0007\u0003\u0003?Q1!!\t\u0007\u0003\u0019a$o\\8u}%\u0019\u0011Q\u0005\u0006\u0002\rA\u0013X\rZ3g\u0013\u0011\tI#a\u000b\u0003\rM#(/\u001b8h\u0015\r\t)C\u0003\u0005\b\u0003_\ti\u00011\u00010\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0003\u0004|\u0003\u001b\u0001\r!\u0014\u0005\u0007{\u00065\u0001\u0019\u0001@\t\u0011\u0005\u0015\u0011Q\u0002a\u0001\u0003\u000fAa!!\u000f\u0001\t\u0013!\u0017\u0001G5oSRL\u0017\r\\5{KB\u000b'\u000f^5uS>t7\u000b^1uK\"9\u0011Q\b\u0001\u0005\n\u0005}\u0012!F1tg\u0016\u0014HOV1mS\u0012$&/\u00198tSRLwN\u001c\u000b\u0006K\u0006\u0005\u0013Q\t\u0005\b\u0003\u0007\nY\u00041\u0001H\u0003E!x\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\u0005\u0007w\u0006m\u0002\u0019A'\t\u000f\u0005%\u0003\u0001\"\u0003\u0002L\u0005\u0011\u0013N\\5uS\u0006d\u0017N_3MK\u0006$WM]!oI&\u001b(OR8s!\u0006\u0014H/\u001b;j_:$2!ZA'\u0011\u001d\t\u0019%a\u0012A\u0002\u001dCq!!\u0015\u0001\t\u0003\t\u0019&A\ffY\u0016\u001cG\u000fT3bI\u0016\u0014hi\u001c:QCJ$\u0018\u000e^5p]R9Q-!\u0016\u0002X\u0005e\u0003\u0002CA\u000b\u0003\u001f\u0002\r!a\u0006\t\u000f\u0005=\u0012q\na\u0001_!1Q0a\u0014A\u0002yDq!!\u0018\u0001\t\u0013\ty&\u0001\u0013hKRdU-\u00193fe&\u001b(/\u00118e\u000bB|7\r[(s)\"\u0014xn^#yG\u0016\u0004H/[8o)\u0019\t\t'a\u001a\u0002jA\u0019a#a\u0019\n\u0007\u0005\u0015$AA\u000eMK\u0006$WM]%te\u0006sGmQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u0005\t\u0003+\tY\u00061\u0001\u0002\u0018!9\u0011qFA.\u0001\u0004y\u0003\"CA7\u0001E\u0005I\u0011AA8\u0003qA\u0017M\u001c3mKN#\u0018\r^3DQ\u0006tw-Z:%I\u00164\u0017-\u001e7uIM*\"!!\u001d+\u0007y\f\u0019h\u000b\u0002\u0002vA!\u0011qOAA\u001b\t\tIH\u0003\u0003\u0002|\u0005u\u0014!C;oG\",7m[3e\u0015\r\tyHC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAB\u0003s\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\t9\tAI\u0001\n\u0003\tI)\u0001\u000fiC:$G.Z*uCR,7\t[1oO\u0016\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005-%\u0006BA\u0004\u0003g\u0002")
public class PartitionStateMachine
implements Logging {
    private final KafkaController controller;
    private final StateChangeLogger stateChangeLogger;
    private final ControllerContext controllerContext;
    private final int controllerId;
    private final ZkUtils zkUtils;
    private final Map<TopicAndPartition, PartitionState> partitionState;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final NoOpLeaderSelector noOpPartitionLeaderSelector;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        PartitionStateMachine partitionStateMachine = this;
        synchronized (partitionStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private int controllerId() {
        return this.controllerId;
    }

    private ZkUtils zkUtils() {
        return this.zkUtils;
    }

    private Map<TopicAndPartition, PartitionState> partitionState() {
        return this.partitionState;
    }

    private ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    private NoOpLeaderSelector noOpPartitionLeaderSelector() {
        return this.noOpPartitionLeaderSelector;
    }

    public void startup() {
        this.initializePartitionState();
        this.triggerOnlinePartitionStateChange();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Started partition state machine with initial state -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionState()})));
    }

    public void shutdown() {
        this.partitionState().clear();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped partition state machine");
    }

    public void triggerOnlinePartitionStateChange() {
        try {
            this.brokerRequestBatch().newBatch();
            this.partitionState().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$triggerOnlinePartitionStateChange$1(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$triggerOnlinePartitionStateChange$2(this, x$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                PartitionStateMachine.$anonfun$triggerOnlinePartitionStateChange$3(this, x$2);
                return BoxedUnit.UNIT;
            });
            this.brokerRequestBatch().sendRequestsToBrokers(this.controller.epoch());
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while moving some partitions to the online state", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    public Set<TopicAndPartition> partitionsInState(PartitionState state) {
        return ((MapLike)this.partitionState().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$partitionsInState$1(state, p)))).keySet();
    }

    public void handleStateChanges(Set<TopicAndPartition> partitions, PartitionState targetState, PartitionLeaderSelector leaderSelector, Callbacks callbacks) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Invoking state change to %s for partitions %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetState, partitions.mkString(",")})));
        try {
            this.brokerRequestBatch().newBatch();
            partitions.foreach((Function1 & Serializable & scala.Serializable)topicAndPartition -> {
                this.handleStateChange(topicAndPartition.topic(), topicAndPartition.partition(), targetState, leaderSelector, callbacks);
                return BoxedUnit.UNIT;
            });
            this.brokerRequestBatch().sendRequestsToBrokers(this.controller.epoch());
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Error while moving some partitions to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetState})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    private void handleStateChange(String topic, int partition, PartitionState targetState, PartitionLeaderSelector leaderSelector, Callbacks callbacks) {
        block12: {
            TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
            PartitionState currState = (PartitionState)this.partitionState().getOrElseUpdate((Object)topicAndPartition, (Function0 & Serializable & scala.Serializable)() -> NonExistentPartition$.MODULE$);
            StateChangeLogger stateChangeLog = this.stateChangeLogger.withControllerEpoch(this.controller.epoch());
            try {
                this.assertValidTransition(topicAndPartition, targetState);
                PartitionState partitionState = targetState;
                if (NewPartition$.MODULE$.equals(partitionState)) {
                    this.partitionState().put((Object)topicAndPartition, (Object)NewPartition$.MODULE$);
                    String assignedReplicas = ((TraversableOnce)this.controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition)).mkString(",");
                    stateChangeLog.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " state from ", " to ", " with "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, currState, targetState})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"assigned replicas ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{assignedReplicas})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block12;
                }
                if (OnlinePartition$.MODULE$.equals(partitionState)) {
                    PartitionState partitionState2 = (PartitionState)this.partitionState().apply((Object)topicAndPartition);
                    if (NewPartition$.MODULE$.equals(partitionState2)) {
                        this.initializeLeaderAndIsrForPartition(topicAndPartition);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (OfflinePartition$.MODULE$.equals(partitionState2)) {
                        this.electLeaderForPartition(topic, partition, leaderSelector);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (OnlinePartition$.MODULE$.equals(partitionState2)) {
                        this.electLeaderForPartition(topic, partition, leaderSelector);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    this.partitionState().put((Object)topicAndPartition, (Object)OnlinePartition$.MODULE$);
                    int leader = ((LeaderIsrAndControllerEpoch)this.controllerContext().partitionLeadershipInfo().apply((Object)topicAndPartition)).leaderAndIsr().leader();
                    stateChangeLog.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " from ", " to ", " with leader ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, currState, targetState, BoxesRunTime.boxToInteger((int)leader)})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block12;
                }
                if (OfflinePartition$.MODULE$.equals(partitionState)) {
                    stateChangeLog.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " state from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, currState, targetState})));
                    this.partitionState().put((Object)topicAndPartition, (Object)OfflinePartition$.MODULE$);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block12;
                }
                if (NonExistentPartition$.MODULE$.equals(partitionState)) {
                    this.stateChangeLogger.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " state from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, currState, targetState})));
                    this.partitionState().put((Object)topicAndPartition, (Object)NonExistentPartition$.MODULE$);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block12;
                }
                throw new MatchError((Object)partitionState);
            }
            catch (Throwable t) {
                stateChangeLog.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initiated state change for partition ", " from ", " to ", " failed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, currState, targetState})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            }
        }
    }

    public PartitionLeaderSelector handleStateChanges$default$3() {
        return this.noOpPartitionLeaderSelector();
    }

    public Callbacks handleStateChanges$default$4() {
        return new Callbacks.CallbackBuilder().build();
    }

    private void initializePartitionState() {
        this.controllerContext().partitionReplicaAssignment().keys().foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
            Option option;
            Option option2 = this.controllerContext().partitionLeadershipInfo().get(topicPartition);
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)some.value();
                option = this.controllerContext().isReplicaOnline(currentLeaderIsrAndEpoch.leaderAndIsr().leader(), (TopicAndPartition)topicPartition, this.controllerContext().isReplicaOnline$default$3()) ? this.partitionState().put(topicPartition, (Object)OnlinePartition$.MODULE$) : this.partitionState().put(topicPartition, (Object)OfflinePartition$.MODULE$);
            } else if (None$.MODULE$.equals(option2)) {
                option = this.partitionState().put(topicPartition, (Object)NewPartition$.MODULE$);
            } else {
                throw new MatchError((Object)option2);
            }
            return option;
        });
    }

    private void assertValidTransition(TopicAndPartition topicAndPartition, PartitionState targetState) {
        if (!targetState.validPreviousStates().contains(this.partitionState().apply((Object)topicAndPartition))) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Partition %s should be in the %s states before moving to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, targetState.validPreviousStates().mkString(","), targetState})) + new StringOps(Predef$.MODULE$.augmentString(". Instead it is in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionState().apply((Object)topicAndPartition)})));
        }
    }

    private void initializeLeaderAndIsrForPartition(TopicAndPartition topicAndPartition) {
        BoxedUnit boxedUnit;
        List replicaAssignment = ((TraversableOnce)this.controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition)).toList();
        List liveAssignedReplicas = (List)replicaAssignment.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)r -> this.controllerContext().isReplicaOnline(r, topicAndPartition, this.controllerContext().isReplicaOnline$default$3()));
        StateChangeLogger stateChangeLog = this.stateChangeLogger.withControllerEpoch(this.controller.epoch());
        Option option = liveAssignedReplicas.headOption();
        if (None$.MODULE$.equals(option)) {
            String failMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Encountered error during state change of partition ", " from New to Online, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"assigned replicas are [", "], live brokers are "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicaAssignment.mkString(",")})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "]. No assigned replica is alive."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.controllerContext().liveBrokerIds()}));
            stateChangeLog.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> failMsg);
            throw new StateChangeFailedException(stateChangeLog.messageWithPrefix(failMsg));
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            int leader = BoxesRunTime.unboxToInt((Object)some.value());
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Live assigned replicas for partition ", " are: [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, liveAssignedReplicas})));
            LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(leader, (List<Object>)liveAssignedReplicas);
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controller.epoch());
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initializing leader and isr for partition ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, leaderIsrAndControllerEpoch})));
            try {
                this.zkUtils().createPersistentPath(ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topicAndPartition.topic(), topicAndPartition.partition()), this.zkUtils().leaderAndIsrZkData(leaderAndIsr, this.controller.epoch()), this.zkUtils().createPersistentPath$default$3());
                this.controllerContext().partitionLeadershipInfo().put((Object)topicAndPartition, (Object)leaderIsrAndControllerEpoch);
                this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)liveAssignedReplicas, topicAndPartition.topic(), topicAndPartition.partition(), leaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, true);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (ZkNodeExistsException zkNodeExistsException) {
                LeaderIsrAndControllerEpoch leaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.zkUtils(), topicAndPartition.topic(), topicAndPartition.partition()).get();
                String failMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Encountered error while changing partition ", "'s state from New to Online "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"since LeaderAndIsr path already exists with value ", " and controller "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leaderIsrAndEpoch.leaderAndIsr()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"epoch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderIsrAndEpoch.controllerEpoch())}));
                stateChangeLog.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> failMsg);
                throw new StateChangeFailedException(stateChangeLog.messageWithPrefix(failMsg));
            }
        } else {
            throw new MatchError((Object)option);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public void electLeaderForPartition(String topic, int partition, PartitionLeaderSelector leaderSelector) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
        StateChangeLogger stateChangeLog = this.stateChangeLogger.withControllerEpoch(this.controller.epoch());
        stateChangeLog.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Started leader election for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition})));
        try {
            boolean zookeeperPathUpdateSucceeded = false;
            ObjectRef newLeaderAndIsr = ObjectRef.create(null);
            Seq replicasForThisPartition = (Seq)Seq$.MODULE$.empty();
            while (!zookeeperPathUpdateSucceeded) {
                LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = this.getLeaderIsrAndEpochOrThrowException(topic, partition);
                LeaderAndIsr currentLeaderAndIsr = currentLeaderIsrAndEpoch.leaderAndIsr();
                int controllerEpoch = currentLeaderIsrAndEpoch.controllerEpoch();
                if (controllerEpoch > this.controller.epoch()) {
                    String failMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Aborted leader election for partition ", " since the LeaderAndIsr path was "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"already written by another controller. This probably means that the current controller ", " went "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"through a soft failure and another controller was elected with epoch ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)controllerEpoch)}));
                    stateChangeLog.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> failMsg);
                    throw new StateChangeFailedException(stateChangeLog.messageWithPrefix(failMsg));
                }
                Tuple2<LeaderAndIsr, Seq<Object>> tuple2 = leaderSelector.selectLeader(topicAndPartition, currentLeaderAndIsr);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._1();
                Seq replicas = (Seq)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)leaderAndIsr, (Object)replicas);
                Tuple2 tuple23 = tuple22;
                LeaderAndIsr leaderAndIsr2 = (LeaderAndIsr)tuple23._1();
                Seq replicas2 = (Seq)tuple23._2();
                Tuple2<Object, Object> tuple24 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkUtils(), topic, partition, leaderAndIsr2, this.controller.epoch(), currentLeaderAndIsr.zkVersion());
                if (tuple24 == null) {
                    throw new MatchError(tuple24);
                }
                boolean updateSucceeded = tuple24._1$mcZ$sp();
                int newVersion = tuple24._2$mcI$sp();
                Tuple2.mcZI.sp sp2 = new Tuple2.mcZI.sp(updateSucceeded, newVersion);
                Tuple2.mcZI.sp sp3 = sp2;
                boolean updateSucceeded2 = sp3._1$mcZ$sp();
                int newVersion2 = sp3._2$mcI$sp();
                newLeaderAndIsr.elem = leaderAndIsr2.withZkVersion(newVersion2);
                zookeeperPathUpdateSucceeded = updateSucceeded2;
                replicasForThisPartition = replicas2;
            }
            LeaderIsrAndControllerEpoch newLeaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch((LeaderAndIsr)newLeaderAndIsr.elem, this.controller.epoch());
            this.controllerContext().partitionLeadershipInfo().put((Object)new TopicAndPartition(topic, partition), (Object)newLeaderIsrAndControllerEpoch);
            stateChangeLog.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Elected leader ", " for Offline partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((LeaderAndIsr)newLeaderAndIsr$1.elem).leader()), topicAndPartition})));
            Seq replicas = (Seq)this.controllerContext().partitionReplicaAssignment().apply((Object)new TopicAndPartition(topic, partition));
            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)replicasForThisPartition, topic, partition, newLeaderIsrAndControllerEpoch, (Seq<Object>)replicas, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
        }
        catch (LeaderElectionNotNeededException leaderElectionNotNeededException) {
        }
        catch (NoReplicaOnlineException nroe) {
            throw nroe;
        }
        catch (Throwable sce) {
            String failMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Encountered error while electing leader for partition ", " due to: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, sce.getMessage()}));
            stateChangeLog.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> failMsg);
            throw new StateChangeFailedException(stateChangeLog.messageWithPrefix(failMsg), sce);
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"After leader election, leader cache for ", " is updated to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, this.controllerContext().partitionLeadershipInfo().apply((Object)topicAndPartition)})));
    }

    private LeaderIsrAndControllerEpoch getLeaderIsrAndEpochOrThrowException(String topic, int partition) {
        LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
        Option<LeaderIsrAndControllerEpoch> option = ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.zkUtils(), topic, partition);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new StateChangeFailedException("LeaderAndIsr information doesn't exist for " + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition ", " in ", " state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, this.partitionState().apply((Object)topicAndPartition)})));
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = currentLeaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)some.value();
        return leaderIsrAndControllerEpoch;
    }

    public static final /* synthetic */ boolean $anonfun$triggerOnlinePartitionStateChange$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$triggerOnlinePartitionStateChange$2(PartitionStateMachine $this, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
        boolean bl = !$this.controller.topicDeletionManager().isTopicQueuedUpForDeletion(topicAndPartition.topic());
        return bl;
    }

    public static final /* synthetic */ void $anonfun$triggerOnlinePartitionStateChange$3(PartitionStateMachine $this, Tuple2 x$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$2;
        if (tuple2 != null) {
            TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
            PartitionState partitionState = (PartitionState)tuple2._2();
            if (partitionState.equals(OfflinePartition$.MODULE$) || partitionState.equals(NewPartition$.MODULE$)) {
                $this.handleStateChange(topicAndPartition.topic(), topicAndPartition.partition(), OnlinePartition$.MODULE$, $this.controller.offlinePartitionSelector(), new Callbacks.CallbackBuilder().build());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$partitionsInState$1(PartitionState state$1, Tuple2 p) {
        Object object = p._2();
        PartitionState partitionState = state$1;
        return !(object != null ? !object.equals(partitionState) : partitionState != null);
    }

    public PartitionStateMachine(KafkaController controller, StateChangeLogger stateChangeLogger) {
        this.controller = controller;
        this.stateChangeLogger = stateChangeLogger;
        Logging.$init$(this);
        this.controllerContext = controller.controllerContext();
        this.controllerId = controller.config().brokerId();
        this.zkUtils = this.controllerContext().zkUtils();
        this.partitionState = Map$.MODULE$.empty();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(controller, stateChangeLogger);
        this.noOpPartitionLeaderSelector = new NoOpLeaderSelector(this.controllerContext());
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[PartitionStateMachine controllerId=", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId())})));
    }
}

