/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="compact", description="Force a (major) compaction on one or more tables or user-defined compaction on given SSTables")
public class Compact
extends NodeTool.NodeToolCmd {
    @Arguments(usage="[<keyspace> <tables>...] or <SSTable file>...", description="The keyspace followed by one or many tables or list of SSTable data files when using --user-defined")
    private List<String> args = new ArrayList<String>();
    @Option(title="split_output", name={"-s", "--split-output"}, description="Use -s to not create a single big file")
    private boolean splitOutput = false;
    @Option(title="user-defined", name={"--user-defined"}, description="Use --user-defined to submit listed files for user-defined compaction")
    private boolean userDefined = false;

    @Override
    public void execute(NodeProbe probe) {
        if (this.splitOutput && this.userDefined) {
            throw new RuntimeException("Invalid option combination: User defined compaction can not be split");
        }
        if (this.userDefined) {
            try {
                String userDefinedFiles = String.join((CharSequence)",", this.args);
                probe.forceUserDefinedCompaction(userDefinedFiles);
            }
            catch (Exception e) {
                throw new RuntimeException("Error occurred during user defined compaction", e);
            }
            return;
        }
        List<String> keyspaces = this.parseOptionalKeyspace(this.args, probe);
        String[] tableNames = this.parseOptionalTables(this.args);
        for (String keyspace : keyspaces) {
            try {
                probe.forceKeyspaceCompaction(this.splitOutput, keyspace, tableNames);
            }
            catch (Exception e) {
                throw new RuntimeException("Error occurred during compaction", e);
            }
        }
    }
}

