/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.schema.SchemaKeyspace;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MigrationTask
extends WrappedRunnable {
    private static final Logger logger = LoggerFactory.getLogger(MigrationTask.class);
    private static final ConcurrentLinkedQueue<CountDownLatch> inflightTasks = new ConcurrentLinkedQueue();
    private static final Set<SystemKeyspace.BootstrapState> monitoringBootstrapStates = EnumSet.of(SystemKeyspace.BootstrapState.NEEDS_BOOTSTRAP, SystemKeyspace.BootstrapState.IN_PROGRESS);
    private final InetAddress endpoint;

    MigrationTask(InetAddress endpoint) {
        this.endpoint = endpoint;
    }

    public static ConcurrentLinkedQueue<CountDownLatch> getInflightTasks() {
        return inflightTasks;
    }

    @Override
    public void runMayThrow() throws Exception {
        if (!MigrationManager.shouldPullSchemaFrom(this.endpoint)) {
            logger.info("Skipped sending a migration request: node {} has a higher major version now.", (Object)this.endpoint);
            return;
        }
        if (!FailureDetector.instance.isAlive(this.endpoint)) {
            logger.debug("Can't send schema pull request: node {} is down.", (Object)this.endpoint);
            return;
        }
        MessageOut<Collection<Mutation>> message = new MessageOut<Collection<Mutation>>(MessagingService.Verb.MIGRATION_REQUEST, null, MigrationManager.MigrationsSerializer.instance);
        final CountDownLatch completionLatch = new CountDownLatch(1);
        IAsyncCallback<Collection<Mutation>> cb = new IAsyncCallback<Collection<Mutation>>(){

            @Override
            public void response(MessageIn<Collection<Mutation>> message) {
                try {
                    SchemaKeyspace.mergeSchemaAndAnnounceVersion((Collection)message.payload);
                }
                catch (ConfigurationException e) {
                    logger.error("Configuration exception merging remote schema", (Throwable)e);
                }
                finally {
                    completionLatch.countDown();
                }
            }

            @Override
            public boolean isLatencyForSnitch() {
                return false;
            }
        };
        if (monitoringBootstrapStates.contains((Object)SystemKeyspace.getBootstrapState())) {
            inflightTasks.offer(completionLatch);
        }
        MessagingService.instance().sendRR(message, this.endpoint, cb);
    }
}

