/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.utils;

import com.carrotsearch.hppc.LongOpenHashSet;
import com.carrotsearch.hppc.LongSet;
import com.carrotsearch.hppc.cursors.LongCursor;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.index.sasi.disk.OnDiskIndex;
import org.apache.cassandra.index.sasi.disk.Token;
import org.apache.cassandra.index.sasi.disk.TokenTree;
import org.apache.cassandra.index.sasi.disk.TokenTreeBuilder;
import org.apache.cassandra.index.sasi.utils.CombinedValue;
import org.apache.cassandra.index.sasi.utils.RangeIterator;

public class CombinedTerm
implements CombinedValue<OnDiskIndex.DataTerm> {
    private final AbstractType<?> comparator;
    private final OnDiskIndex.DataTerm term;
    private final TreeMap<Long, LongSet> tokens;

    public CombinedTerm(AbstractType<?> comparator, OnDiskIndex.DataTerm term) {
        this.comparator = comparator;
        this.term = term;
        this.tokens = new TreeMap();
        RangeIterator<Long, Token> tokens = term.getTokens();
        while (tokens.hasNext()) {
            Token current = (Token)tokens.next();
            LongSet offsets = this.tokens.get(current.get());
            if (offsets == null) {
                offsets = new LongOpenHashSet();
                this.tokens.put(current.get(), offsets);
            }
            for (Long offset : ((TokenTree.OnDiskToken)current).getOffsets()) {
                offsets.add(offset.longValue());
            }
        }
    }

    public ByteBuffer getTerm() {
        return this.term.getTerm();
    }

    public Map<Long, LongSet> getTokens() {
        return this.tokens;
    }

    public TokenTreeBuilder getTokenTreeBuilder() {
        return new TokenTreeBuilder(this.tokens).finish();
    }

    @Override
    public void merge(CombinedValue<OnDiskIndex.DataTerm> other) {
        if (!(other instanceof CombinedTerm)) {
            return;
        }
        CombinedTerm o = (CombinedTerm)other;
        assert (this.comparator == o.comparator);
        for (Map.Entry<Long, LongSet> token : o.tokens.entrySet()) {
            LongSet offsets = this.tokens.get(token.getKey());
            if (offsets == null) {
                offsets = new LongOpenHashSet();
                this.tokens.put(token.getKey(), offsets);
            }
            for (LongCursor offset : token.getValue()) {
                offsets.add(offset.value);
            }
        }
    }

    @Override
    public OnDiskIndex.DataTerm get() {
        return this.term;
    }

    @Override
    public int compareTo(CombinedValue<OnDiskIndex.DataTerm> o) {
        return this.term.compareTo(this.comparator, o.get().getTerm());
    }
}

