/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.internal.keys;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.partitions.ImmutableBTreePartition;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.index.internal.CassandraIndex;
import org.apache.cassandra.index.internal.CassandraIndexSearcher;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeysSearcher
extends CassandraIndexSearcher {
    private static final Logger logger = LoggerFactory.getLogger(KeysSearcher.class);

    public KeysSearcher(ReadCommand command, RowFilter.Expression expression, CassandraIndex indexer) {
        super(command, expression, indexer);
    }

    @Override
    protected UnfilteredPartitionIterator queryDataFromIndex(final DecoratedKey indexKey, final RowIterator indexHits, final ReadCommand command, final ReadExecutionController executionController) {
        assert (indexHits.staticRow() == Rows.EMPTY_STATIC_ROW);
        return new UnfilteredPartitionIterator(){
            private UnfilteredRowIterator next;

            @Override
            public boolean isForThrift() {
                return command.isForThrift();
            }

            @Override
            public CFMetaData metadata() {
                return command.metadata();
            }

            @Override
            public boolean hasNext() {
                return this.prepareNext();
            }

            @Override
            public UnfilteredRowIterator next() {
                if (this.next == null) {
                    this.prepareNext();
                }
                UnfilteredRowIterator toReturn = this.next;
                this.next = null;
                return toReturn;
            }

            private boolean prepareNext() {
                while (this.next == null && indexHits.hasNext()) {
                    SinglePartitionReadCommand dataCmd;
                    UnfilteredRowIterator dataIter;
                    Row hit = (Row)indexHits.next();
                    DecoratedKey key = ((KeysSearcher)KeysSearcher.this).index.baseCfs.decorateKey(hit.clustering().get(0));
                    if (!command.selectsKey(key) || (dataIter = KeysSearcher.this.filterIfStale((dataCmd = SinglePartitionReadCommand.create(this.isForThrift(), ((KeysSearcher)KeysSearcher.this).index.baseCfs.metadata, command.nowInSec(), command.columnFilter(), command.rowFilter(), DataLimits.NONE, key, command.clusteringIndexFilter(key))).queryMemtableAndDisk(((KeysSearcher)KeysSearcher.this).index.baseCfs, executionController.baseReadOpOrderGroup()), hit, indexKey.getKey(), executionController.writeOpOrderGroup(), this.isForThrift(), command.nowInSec())) == null) continue;
                    if (dataIter.isEmpty()) {
                        dataIter.close();
                        continue;
                    }
                    this.next = dataIter;
                }
                return this.next != null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
                indexHits.close();
                if (this.next != null) {
                    this.next.close();
                }
            }
        };
    }

    private UnfilteredRowIterator filterIfStale(UnfilteredRowIterator iterator, Row indexHit, ByteBuffer indexedValue, OpOrder.Group writeOp, boolean isForThrift, int nowInSec) {
        if (isForThrift) {
            ImmutableBTreePartition result = ImmutableBTreePartition.create(iterator);
            iterator.close();
            Row data = result.getRow(Clustering.make(this.index.getIndexedColumn().name.bytes));
            Cell baseData = data.getCell(this.index.baseCfs.metadata.compactValueColumn());
            if (baseData == null || !baseData.isLive(nowInSec) || this.index.getIndexedColumn().type.compare(indexedValue, baseData.value()) != 0) {
                this.index.deleteStaleEntry(this.index.getIndexCfs().decorateKey(indexedValue), Clustering.make(this.index.getIndexedColumn().name.bytes), new DeletionTime(indexHit.primaryKeyLivenessInfo().timestamp(), nowInSec), writeOp);
                return null;
            }
            return result.unfilteredIterator();
        }
        assert (iterator.metadata().isCompactTable());
        Row data = iterator.staticRow();
        if (this.index.isStale(data, indexedValue, nowInSec)) {
            this.index.deleteStaleEntry(this.index.getIndexCfs().decorateKey(indexedValue), this.makeIndexClustering(iterator.partitionKey().getKey(), Clustering.EMPTY), new DeletionTime(indexHit.primaryKeyLivenessInfo().timestamp(), nowInSec), writeOp);
            iterator.close();
            return null;
        }
        return iterator;
    }
}

