/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.statements.IndexTarget;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.lang3.StringUtils;

public class TargetParser {
    private static final Pattern TARGET_REGEX = Pattern.compile("^(keys|entries|values|full)\\((.+)\\)$");
    private static final Pattern TWO_QUOTES = Pattern.compile("\"\"");
    private static final String QUOTE = "\"";

    public static Pair<ColumnDefinition, IndexTarget.Type> parse(CFMetaData cfm, IndexMetadata indexDef) {
        String target = indexDef.options.get("target");
        assert (target != null) : String.format("No target definition found for index %s", indexDef.name);
        Pair<ColumnDefinition, IndexTarget.Type> result = TargetParser.parse(cfm, target);
        if (result == null) {
            throw new ConfigurationException(String.format("Unable to parse targets for index %s (%s)", indexDef.name, target));
        }
        return result;
    }

    public static Pair<ColumnDefinition, IndexTarget.Type> parse(CFMetaData cfm, String target) {
        String columnName;
        IndexTarget.Type targetType;
        Matcher matcher = TARGET_REGEX.matcher(target);
        if (matcher.matches()) {
            targetType = IndexTarget.Type.fromString(matcher.group(1));
            columnName = matcher.group(2);
        } else {
            columnName = target;
            targetType = IndexTarget.Type.VALUES;
        }
        if (columnName.startsWith(QUOTE)) {
            columnName = StringUtils.substring((String)StringUtils.substring((String)columnName, (int)1), (int)0, (int)-1);
            columnName = TWO_QUOTES.matcher(columnName).replaceAll(QUOTE);
        }
        if (cfm.isCQLTable()) {
            return Pair.create(cfm.getColumnDefinition(new ColumnIdentifier(columnName, true)), targetType);
        }
        for (ColumnDefinition column : cfm.allColumns()) {
            if (!column.name.toString().equals(columnName)) continue;
            return Pair.create(column, targetType);
        }
        return null;
    }
}

