/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.crypto.Cipher;
import org.apache.cassandra.hints.ChecksummedDataInput;
import org.apache.cassandra.hints.CompressedChecksummedDataInputBuilder;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.compress.ICompressor;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.security.EncryptionUtils;

public class EncryptedChecksummedDataInput
extends ChecksummedDataInput {
    private static final ThreadLocal<ByteBuffer> reusableBuffers = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return ByteBuffer.allocate(0);
        }
    };
    private final Cipher cipher;
    private final ICompressor compressor;
    private final EncryptionUtils.ChannelProxyReadChannel readChannel;

    protected EncryptedChecksummedDataInput(Builder builder) {
        super(builder);
        this.cipher = builder.cipher;
        this.compressor = builder.compressor;
        this.readChannel = new EncryptionUtils.ChannelProxyReadChannel(this.channel, builder.position);
        assert (this.cipher != null);
        assert (this.compressor != null);
    }

    @Override
    public boolean isEOF() {
        return this.readChannel.getCurrentPosition() == this.channel.size() && this.buffer.remaining() == 0;
    }

    @Override
    protected void reBufferStandard() {
        try {
            ByteBuffer byteBuffer = reusableBuffers.get();
            ByteBuffer decrypted = EncryptionUtils.decrypt(this.readChannel, byteBuffer, true, this.cipher);
            this.buffer = EncryptionUtils.uncompress(decrypted, this.buffer, true, this.compressor);
            if (decrypted.capacity() > byteBuffer.capacity()) {
                reusableBuffers.set(decrypted);
            }
        }
        catch (IOException ioe) {
            throw new FSReadError((Throwable)ioe, this.getPath());
        }
    }

    public static ChecksummedDataInput upgradeInput(ChecksummedDataInput input, Cipher cipher, ICompressor compressor) {
        long position = input.getPosition();
        input.close();
        Builder builder = new Builder(new ChannelProxy(input.getPath()));
        builder.withPosition(position);
        builder.withCompressor(compressor);
        builder.withCipher(cipher);
        return builder.build();
    }

    @VisibleForTesting
    Cipher getCipher() {
        return this.cipher;
    }

    @VisibleForTesting
    ICompressor getCompressor() {
        return this.compressor;
    }

    public static class Builder
    extends CompressedChecksummedDataInputBuilder {
        Cipher cipher;

        public Builder(ChannelProxy channel) {
            super(channel);
        }

        public Builder withCipher(Cipher cipher) {
            this.cipher = cipher;
            return this;
        }

        @Override
        public ChecksummedDataInput build() {
            assert (this.position >= 0L);
            assert (this.compressor != null);
            assert (this.cipher != null);
            return new EncryptedChecksummedDataInput(this);
        }
    }
}

