/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.LazilyInitializedUnfilteredRowIterator;
import org.apache.cassandra.db.rows.RangeTombstoneBoundMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.IndexHelper;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.thrift.ThriftResultsMerger;
import org.apache.cassandra.utils.IteratorWithLowerBound;

public class UnfilteredRowIteratorWithLowerBound
extends LazilyInitializedUnfilteredRowIterator
implements IteratorWithLowerBound<Unfiltered> {
    private final SSTableReader sstable;
    private final ClusteringIndexFilter filter;
    private final ColumnFilter selectedColumns;
    private final boolean isForThrift;
    private final int nowInSec;
    private final boolean applyThriftTransformation;
    private RangeTombstone.Bound lowerBound;
    private boolean firstItemRetrieved;

    public UnfilteredRowIteratorWithLowerBound(DecoratedKey partitionKey, SSTableReader sstable, ClusteringIndexFilter filter, ColumnFilter selectedColumns, boolean isForThrift, int nowInSec, boolean applyThriftTransformation) {
        super(partitionKey);
        this.sstable = sstable;
        this.filter = filter;
        this.selectedColumns = selectedColumns;
        this.isForThrift = isForThrift;
        this.nowInSec = nowInSec;
        this.applyThriftTransformation = applyThriftTransformation;
        this.lowerBound = null;
        this.firstItemRetrieved = false;
    }

    @Override
    public Unfiltered lowerBound() {
        if (this.lowerBound != null) {
            return this.makeBound(this.lowerBound);
        }
        RangeTombstone.Bound ret = this.getPartitionIndexLowerBound();
        return ret != null ? this.makeBound(ret) : this.makeBound(this.getMetadataLowerBound());
    }

    private Unfiltered makeBound(RangeTombstone.Bound bound) {
        if (bound == null) {
            return null;
        }
        if (this.lowerBound != bound) {
            this.lowerBound = bound;
        }
        return new RangeTombstoneBoundMarker(this.lowerBound, DeletionTime.LIVE);
    }

    @Override
    protected UnfilteredRowIterator initializeIterator() {
        this.sstable.incrementReadCount();
        UnfilteredRowIterator iter = this.sstable.iterator(this.partitionKey(), this.filter.getSlices(this.metadata()), this.selectedColumns, this.filter.isReversed(), this.isForThrift);
        return this.isForThrift && this.applyThriftTransformation ? ThriftResultsMerger.maybeWrap(iter, this.nowInSec) : iter;
    }

    @Override
    protected Unfiltered computeNext() {
        Unfiltered ret = super.computeNext();
        if (this.firstItemRetrieved) {
            return ret;
        }
        this.firstItemRetrieved = true;
        if (this.lowerBound != null && ret != null) assert (this.comparator().compare(this.lowerBound, ret.clustering()) <= 0) : String.format("Lower bound [%s ]is bigger than first returned value [%s] for sstable %s", this.lowerBound.toString(this.sstable.metadata), ret.toString(this.sstable.metadata), this.sstable.getFilename());
        return ret;
    }

    private Comparator<Clusterable> comparator() {
        return this.filter.isReversed() ? this.sstable.metadata.comparator.reversed() : this.sstable.metadata.comparator;
    }

    @Override
    public CFMetaData metadata() {
        return this.sstable.metadata;
    }

    @Override
    public boolean isReverseOrder() {
        return this.filter.isReversed();
    }

    @Override
    public PartitionColumns columns() {
        return this.selectedColumns.fetchedColumns();
    }

    @Override
    public EncodingStats stats() {
        return this.sstable.stats();
    }

    @Override
    public DeletionTime partitionLevelDeletion() {
        if (!this.sstable.hasTombstones()) {
            return DeletionTime.LIVE;
        }
        return super.partitionLevelDeletion();
    }

    @Override
    public Row staticRow() {
        if (this.columns().statics.isEmpty()) {
            return Rows.EMPTY_STATIC_ROW;
        }
        return super.staticRow();
    }

    private RangeTombstone.Bound getPartitionIndexLowerBound() {
        ClusteringPrefix lowerBoundPrefix;
        RowIndexEntry rowIndexEntry;
        if (!this.canUseMetadataLowerBound()) {
            this.maybeInit();
        }
        if ((rowIndexEntry = this.sstable.getCachedPosition(this.partitionKey(), false)) == null) {
            return null;
        }
        List columns = rowIndexEntry.columnsIndex();
        if (columns.size() == 0) {
            return null;
        }
        IndexHelper.IndexInfo column = (IndexHelper.IndexInfo)columns.get(this.filter.isReversed() ? columns.size() - 1 : 0);
        ClusteringPrefix clusteringPrefix = lowerBoundPrefix = this.filter.isReversed() ? column.lastName : column.firstName;
        assert (lowerBoundPrefix.getRawValues().length <= this.sstable.metadata.comparator.size()) : String.format("Unexpected number of clustering values %d, expected %d or fewer for %s", lowerBoundPrefix.getRawValues().length, this.sstable.metadata.comparator.size(), this.sstable.getFilename());
        return RangeTombstone.Bound.inclusiveOpen(this.filter.isReversed(), lowerBoundPrefix.getRawValues());
    }

    private boolean canUseMetadataLowerBound() {
        return !this.sstable.hasTombstones() && this.sstable.descriptor.version.hasNewStatsFile();
    }

    private RangeTombstone.Bound getMetadataLowerBound() {
        List<ByteBuffer> vals;
        if (!this.canUseMetadataLowerBound()) {
            return null;
        }
        StatsMetadata m = this.sstable.getSSTableMetadata();
        List<ByteBuffer> list = vals = this.filter.isReversed() ? m.maxClusteringValues : m.minClusteringValues;
        assert (vals.size() <= this.sstable.metadata.comparator.size()) : String.format("Unexpected number of clustering values %d, expected %d or fewer for %s", vals.size(), this.sstable.metadata.comparator.size(), this.sstable.getFilename());
        return RangeTombstone.Bound.inclusiveOpen(this.filter.isReversed(), vals.toArray(new ByteBuffer[vals.size()]));
    }
}

