/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction.writers;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.compaction.CompactionTask;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.SSTableRewriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.concurrent.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompactionAwareWriter
extends Transactional.AbstractTransactional
implements Transactional {
    protected static final Logger logger = LoggerFactory.getLogger(CompactionAwareWriter.class);
    protected final ColumnFamilyStore cfs;
    protected final Directories directories;
    protected final Set<SSTableReader> nonExpiredSSTables;
    protected final long estimatedTotalKeys;
    protected final long maxAge;
    protected final long minRepairedAt;
    protected final SSTableRewriter sstableWriter;
    protected final LifecycleTransaction txn;
    private final Directories.DataDirectory[] locations;
    private final List<PartitionPosition> diskBoundaries;
    private int locationIndex;

    @Deprecated
    public CompactionAwareWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables, boolean offline, boolean keepOriginals) {
        this(cfs, directories, txn, nonExpiredSSTables, keepOriginals);
    }

    public CompactionAwareWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables, boolean keepOriginals) {
        this.cfs = cfs;
        this.directories = directories;
        this.nonExpiredSSTables = nonExpiredSSTables;
        this.txn = txn;
        this.estimatedTotalKeys = SSTableReader.getApproximateKeyCount(nonExpiredSSTables);
        this.maxAge = CompactionTask.getMaxDataAge(nonExpiredSSTables);
        this.sstableWriter = SSTableRewriter.constructKeepingOriginals(txn, keepOriginals, this.maxAge, txn.isOffline());
        this.minRepairedAt = CompactionTask.getMinRepairedAt(nonExpiredSSTables);
        this.locations = cfs.getDirectories().getWriteableLocations();
        this.diskBoundaries = StorageService.getDiskBoundaries(cfs);
        this.locationIndex = -1;
    }

    @Override
    protected Throwable doAbort(Throwable accumulate) {
        return this.sstableWriter.abort(accumulate);
    }

    @Override
    protected Throwable doCommit(Throwable accumulate) {
        return this.sstableWriter.commit(accumulate);
    }

    @Override
    protected void doPrepare() {
        this.sstableWriter.prepareToCommit();
    }

    @Override
    public Collection<SSTableReader> finish() {
        super.finish();
        return this.sstableWriter.finished();
    }

    public long estimatedKeys() {
        return this.estimatedTotalKeys;
    }

    public final boolean append(UnfilteredRowIterator partition) {
        this.maybeSwitchWriter(partition.partitionKey());
        return this.realAppend(partition);
    }

    @Override
    protected Throwable doPostCleanup(Throwable accumulate) {
        this.sstableWriter.close();
        return super.doPostCleanup(accumulate);
    }

    protected abstract boolean realAppend(UnfilteredRowIterator var1);

    protected void maybeSwitchWriter(DecoratedKey key) {
        if (this.diskBoundaries == null) {
            if (this.locationIndex < 0) {
                Directories.DataDirectory defaultLocation = this.getWriteDirectory(this.nonExpiredSSTables, this.cfs.getExpectedCompactedFileSize(this.nonExpiredSSTables, OperationType.UNKNOWN));
                this.switchCompactionLocation(defaultLocation);
                this.locationIndex = 0;
            }
            return;
        }
        if (this.locationIndex > -1 && key.compareTo(this.diskBoundaries.get(this.locationIndex)) < 0) {
            return;
        }
        int prevIdx = this.locationIndex;
        while (this.locationIndex == -1 || key.compareTo(this.diskBoundaries.get(this.locationIndex)) > 0) {
            ++this.locationIndex;
        }
        if (prevIdx >= 0) {
            logger.debug("Switching write location from {} to {}", (Object)this.locations[prevIdx], (Object)this.locations[this.locationIndex]);
        }
        this.switchCompactionLocation(this.locations[this.locationIndex]);
    }

    protected abstract void switchCompactionLocation(Directories.DataDirectory var1);

    public Directories getDirectories() {
        return this.directories;
    }

    public Directories.DataDirectory getWriteDirectory(Iterable<SSTableReader> sstables, long estimatedWriteSize) {
        File directory = null;
        for (SSTableReader sstable : sstables) {
            if (directory == null) {
                directory = sstable.descriptor.directory;
            }
            if (directory.equals(sstable.descriptor.directory)) continue;
            logger.trace("All sstables not from the same disk - putting results in {}", (Object)directory);
        }
        Directories.DataDirectory d = this.getDirectories().getDataDirectoryForFile(directory);
        if (d != null) {
            if (d.getAvailableSpace() < estimatedWriteSize) {
                throw new RuntimeException(String.format("Not enough space to write %d bytes to %s (%d bytes available)", estimatedWriteSize, d.location, d.getAvailableSpace()));
            }
            logger.trace("putting compaction results in {}", (Object)directory);
            return d;
        }
        d = this.getDirectories().getWriteableLocation(estimatedWriteSize);
        if (d == null) {
            throw new RuntimeException("Not enough disk space to store " + estimatedWriteSize + " bytes");
        }
        return d;
    }

    public CompactionAwareWriter setRepairedAt(long repairedAt) {
        this.sstableWriter.setRepairedAt(repairedAt);
        return this;
    }
}

