/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view.predicate;

import org.apache.activemq.artemis.core.management.impl.view.predicate.ActiveMQFilterPredicate;
import org.apache.activemq.artemis.core.server.ServerSession;

public class SessionFilterPredicate
extends ActiveMQFilterPredicate<ServerSession> {
    private Field f;

    @Override
    public boolean apply(ServerSession session) {
        if (this.f == null) {
            return true;
        }
        switch (this.f) {
            case ID: {
                return this.matches(session.getName());
            }
            case CONNECTION_ID: {
                return this.matches(session.getConnectionID());
            }
            case CONSUMER_COUNT: {
                return this.matches(session.getServerConsumers().size());
            }
            case PRODUCER_COUNT: {
                return this.matches(session.getServerProducers().size());
            }
            case PROTOCOL: {
                return this.matches(session.getRemotingConnection().getProtocolName());
            }
            case CLIENT_ID: {
                return this.matches(session.getRemotingConnection().getClientID());
            }
            case LOCAL_ADDRESS: {
                return this.matches(session.getRemotingConnection().getTransportConnection().getLocalAddress());
            }
            case REMOTE_ADDRESS: {
                return this.matches(session.getRemotingConnection().getTransportConnection().getRemoteAddress());
            }
        }
        return true;
    }

    @Override
    public void setField(String field) {
        if (field != null && !field.equals("")) {
            this.f = Field.valueOf(field.toUpperCase());
        }
    }

    static enum Field {
        ID,
        CONNECTION_ID,
        CONSUMER_COUNT,
        PRODUCER_COUNT,
        USER,
        PROTOCOL,
        CLIENT_ID,
        LOCAL_ADDRESS,
        REMOTE_ADDRESS;

    }
}

