/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import javax.json.JsonObjectBuilder;
import org.apache.activemq.artemis.core.management.impl.view.ActiveMQAbstractView;
import org.apache.activemq.artemis.core.management.impl.view.predicate.ProducerFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerProducer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.utils.JsonLoader;

public class ProducerView
extends ActiveMQAbstractView<ServerProducer> {
    private static final String defaultSortColumn = "creationTime";
    private final ActiveMQServer server;

    public ProducerView(ActiveMQServer server) {
        this.server = server;
        this.predicate = new ProducerFilterPredicate(server);
    }

    @Override
    public Class getClassT() {
        return ServerProducer.class;
    }

    @Override
    public JsonObjectBuilder toJson(ServerProducer producer) {
        ServerSession session = this.server.getSessionByID(producer.getSessionID());
        JsonObjectBuilder obj = JsonLoader.createObjectBuilder().add("id", this.toString(producer.getID())).add("session", this.toString(session.getName())).add("clientID", this.toString(session.getRemotingConnection().getClientID())).add("user", this.toString(session.getUsername())).add("protocol", this.toString(session.getRemotingConnection().getProtocolName())).add("address", this.toString(producer.getAddress() != null ? producer.getAddress() : session.getDefaultAddress())).add("localAddress", this.toString(session.getRemotingConnection().getTransportConnection().getLocalAddress())).add("remoteAddress", this.toString(session.getRemotingConnection().getTransportConnection().getRemoteAddress())).add(defaultSortColumn, this.toString(producer.getCreationTime()));
        return obj;
    }

    @Override
    public String getDefaultOrderColumn() {
        return defaultSortColumn;
    }
}

