/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import javax.json.JsonObjectBuilder;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.management.impl.view.ActiveMQAbstractView;
import org.apache.activemq.artemis.core.management.impl.view.predicate.AddressFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.utils.JsonLoader;

public class AddressView
extends ActiveMQAbstractView<SimpleString> {
    private static final String defaultSortColumn = "creationTime";
    private final ActiveMQServer server;

    public AddressView(ActiveMQServer server) {
        this.server = server;
        this.predicate = new AddressFilterPredicate(server);
    }

    @Override
    public Class getClassT() {
        return AddressInfo.class;
    }

    @Override
    public JsonObjectBuilder toJson(SimpleString addressName) {
        AddressInfo address = this.server.getAddressInfo(addressName);
        JsonObjectBuilder obj = JsonLoader.createObjectBuilder().add("id", this.toString(address.getId())).add("name", this.toString(address.getName())).add("routingTypes", this.toString(address.getRoutingTypes()));
        try {
            obj.add("queueCount", this.toString(this.server.bindingQuery(address.getName()).getQueueNames().size()));
            return obj;
        }
        catch (Exception e) {
            obj.add("queueCount", 0);
            return obj;
        }
    }

    @Override
    public String getDefaultOrderColumn() {
        return defaultSortColumn;
    }
}

