/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.crystalball.simulator.delegate;

import java.util.Collection;
import java.util.HashMap;
import org.activiti.crystalball.simulator.SimulationEvent;
import org.activiti.crystalball.simulator.SimulationRunContext;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;

public class UserTaskExecutionListener
implements TaskListener {
    private final String typeToFind;
    protected final String typeToCreate;
    private final Collection<SimulationEvent> events;

    public UserTaskExecutionListener(String typeToFind, String typeToCreate, Collection<SimulationEvent> events) {
        this.typeToFind = typeToFind;
        this.typeToCreate = typeToCreate;
        this.events = events;
    }

    public void notify(DelegateTask delegateTask) {
        SimulationEvent eventToSimulate = this.findUserTaskCompleteEvent(delegateTask);
        if (eventToSimulate != null) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("taskId", delegateTask.getId());
            properties.put("variables", eventToSimulate.getProperty("taskVariables"));
            SimulationEvent e = new SimulationEvent.Builder(this.typeToCreate).properties(properties).build();
            SimulationRunContext.getEventCalendar().addEvent(e);
        }
    }

    private SimulationEvent findUserTaskCompleteEvent(DelegateTask delegateTask) {
        if (delegateTask.hasVariable("_replay.processInstanceId")) {
            String toSimulateProcessInstanceId = (String)delegateTask.getVariable("_replay.processInstanceId");
            String toSimulateTaskDefinitionKey = delegateTask.getTaskDefinitionKey();
            for (SimulationEvent e : this.events) {
                if (!this.typeToFind.equals(e.getType()) || !toSimulateProcessInstanceId.equals(e.getProperty("processInstanceId")) || !toSimulateTaskDefinitionKey.equals(e.getProperty("taskDefinitionKey"))) continue;
                return e;
            }
        }
        return null;
    }
}

