/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.parse;

import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.analyze.Analyzer;
import nl.basjes.parse.useragent.parse.EvilManualUseragentStringHacks;
import nl.basjes.parse.useragent.parser.UserAgentBaseListener;
import nl.basjes.parse.useragent.parser.UserAgentLexer;
import nl.basjes.parse.useragent.parser.UserAgentParser;
import nl.basjes.parse.useragent.utils.AntlrUtils;
import nl.basjes.parse.useragent.utils.VersionSplitter;
import nl.basjes.parse.useragent.utils.WordSplitter;
import nl.basjes.shaded.org.antlr.v4.runtime.ANTLRInputStream;
import nl.basjes.shaded.org.antlr.v4.runtime.CommonTokenStream;
import nl.basjes.shaded.org.antlr.v4.runtime.ParserRuleContext;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.ParseTree;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.ParseTreeProperty;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.ParseTreeWalker;

public class UserAgentTreeFlattener
extends UserAgentBaseListener {
    private final ParseTreeWalker walker = new ParseTreeWalker();
    private final Analyzer analyzer;
    private ParseTreeProperty<State> state;
    private boolean verbose = false;

    public UserAgentTreeFlattener(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void setVerbose(boolean newVerbose) {
        this.verbose = newVerbose;
    }

    public UserAgent parse(String userAgentString) {
        UserAgent userAgent = new UserAgent(userAgentString);
        return this.parseIntoCleanUserAgent(userAgent);
    }

    public UserAgent parse(UserAgent userAgent) {
        userAgent.reset();
        return this.parseIntoCleanUserAgent(userAgent);
    }

    private UserAgent parseIntoCleanUserAgent(UserAgent userAgent) {
        if (userAgent.getUserAgentString() == null) {
            userAgent.set("__SyntaxError__", "true", 1L);
            return userAgent;
        }
        UserAgentParser.UserAgentContext userAgentContext = this.parseUserAgent(userAgent);
        this.state = new ParseTreeProperty();
        State rootState = new State("agent");
        rootState.calculatePath(PathType.CHILD, false);
        this.state.put(userAgentContext, rootState);
        if (userAgent.hasSyntaxError()) {
            this.inform(null, "__SyntaxError__", "true");
        } else {
            this.inform(null, "__SyntaxError__", "false");
        }
        this.walker.walk(this, userAgentContext);
        return userAgent;
    }

    private void inform(ParseTree ctx, String path) {
        this.inform(ctx, path, AntlrUtils.getSourceText(ctx));
    }

    private void inform(ParseTree ctx, String name, String value) {
        this.inform(ctx, ctx, name, value, false);
    }

    private void inform(ParseTree ctx, String name, String value, boolean fakeChild) {
        this.inform(ctx, ctx, name, value, fakeChild);
    }

    private void inform(ParseTree stateCtx, ParseTree ctx, String name, String value, boolean fakeChild) {
        PathType childType;
        State myState = new State(stateCtx, name);
        if (!fakeChild) {
            this.state.put(stateCtx, myState);
        }
        switch (name) {
            case "comments": {
                childType = PathType.COMMENT;
                break;
            }
            case "version": {
                childType = PathType.VERSION;
                break;
            }
            default: {
                childType = PathType.CHILD;
            }
        }
        String path = myState.calculatePath(childType, fakeChild);
        this.analyzer.inform(path, value, ctx);
    }

    private UserAgentParser.UserAgentContext parseUserAgent(UserAgent userAgent) {
        String userAgentString = EvilManualUseragentStringHacks.fixIt(userAgent.getUserAgentString());
        ANTLRInputStream input = new ANTLRInputStream(userAgentString);
        UserAgentLexer lexer = new UserAgentLexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        UserAgentParser parser = new UserAgentParser(tokens);
        if (!this.verbose) {
            lexer.removeErrorListeners();
            parser.removeErrorListeners();
        }
        lexer.addErrorListener(userAgent);
        parser.addErrorListener(userAgent);
        return parser.userAgent();
    }

    @Override
    public void enterUserAgent(UserAgentParser.UserAgentContext ctx) {
        String input = ctx.start.getTokenSource().getInputStream().toString();
        this.inform(ctx, "agent", input);
    }

    @Override
    public void enterRootText(UserAgentParser.RootTextContext ctx) {
        this.informSubstrings(ctx, "text");
    }

    @Override
    public void enterProduct(UserAgentParser.ProductContext ctx) {
        this.informSubstrings(ctx, "product");
    }

    @Override
    public void enterCommentProduct(UserAgentParser.CommentProductContext ctx) {
        this.informSubstrings(ctx, "product");
    }

    @Override
    public void enterProductNameNoVersion(UserAgentParser.ProductNameNoVersionContext ctx) {
        this.informSubstrings(ctx, "product");
    }

    @Override
    public void enterProductNameEmail(UserAgentParser.ProductNameEmailContext ctx) {
        this.inform(ctx, "name");
        this.inform(ctx, "name.(1)email", ctx.getText(), true);
    }

    @Override
    public void enterProductNameUrl(UserAgentParser.ProductNameUrlContext ctx) {
        this.inform(ctx, "name");
        this.inform(ctx, "name.(1)url", ctx.getText(), true);
    }

    @Override
    public void enterProductNameWords(UserAgentParser.ProductNameWordsContext ctx) {
        this.informSubstrings(ctx, "name");
    }

    @Override
    public void enterProductNameKeyValue(UserAgentParser.ProductNameKeyValueContext ctx) {
        this.informSubstrings(ctx, "name");
    }

    @Override
    public void enterProductNameVersion(UserAgentParser.ProductNameVersionContext ctx) {
        this.informSubstrings(ctx, "name");
    }

    @Override
    public void enterProductNameUuid(UserAgentParser.ProductNameUuidContext ctx) {
        this.inform(ctx, "name");
    }

    @Override
    public void enterProductVersion(UserAgentParser.ProductVersionContext ctx) {
        this.enterProductVersion((ParseTree)ctx);
    }

    @Override
    public void enterProductVersionWithCommas(UserAgentParser.ProductVersionWithCommasContext ctx) {
        this.enterProductVersion(ctx);
    }

    public void enterProductVersion(ParseTree ctx) {
        if (ctx.getChildCount() != 1) {
            this.inform(ctx, "version");
            return;
        }
        ParseTree child = ctx.getChild(0);
        if (child instanceof UserAgentParser.SingleVersionContext || child instanceof UserAgentParser.SingleVersionWithCommasContext) {
            return;
        }
        this.inform(ctx, "version");
    }

    @Override
    public void enterProductVersionSingleWord(UserAgentParser.ProductVersionSingleWordContext ctx) {
        this.inform(ctx, "version");
    }

    @Override
    public void enterSingleVersion(UserAgentParser.SingleVersionContext ctx) {
        this.informSubVersions(ctx, "version");
    }

    @Override
    public void enterSingleVersionWithCommas(UserAgentParser.SingleVersionWithCommasContext ctx) {
        this.informSubVersions(ctx, "version");
    }

    @Override
    public void enterProductVersionWords(UserAgentParser.ProductVersionWordsContext ctx) {
        this.informSubstrings(ctx, "version");
    }

    @Override
    public void enterKeyValueProductVersionName(UserAgentParser.KeyValueProductVersionNameContext ctx) {
        this.informSubstrings(ctx, "version");
    }

    @Override
    public void enterCommentBlock(UserAgentParser.CommentBlockContext ctx) {
        this.inform(ctx, "comments");
    }

    @Override
    public void enterCommentEntry(UserAgentParser.CommentEntryContext ctx) {
        this.informSubstrings(ctx, "entry");
    }

    private void informSubstrings(ParserRuleContext ctx, String name) {
        String firstWords;
        String text = AntlrUtils.getSourceText(ctx);
        if (text == null) {
            return;
        }
        this.inform(ctx, name, text, false);
        int startOffsetPrevious = 0;
        int count = 1;
        char[] chars = text.toCharArray();
        while ((firstWords = WordSplitter.getFirstWords(text, count)) != null) {
            this.inform(ctx, ctx, name + "[1-" + count + "]", firstWords, true);
            if (count > 1) {
                this.inform(ctx, ctx, name + "[" + count + "-" + count + "]", firstWords.substring(startOffsetPrevious), true);
            }
            if (++count > 3) {
                return;
            }
            startOffsetPrevious = WordSplitter.findNextWordStart(chars, firstWords.length());
        }
    }

    private void informSubVersions(ParserRuleContext ctx, String name) {
        String firstVersions;
        String text = AntlrUtils.getSourceText(ctx);
        if (text == null) {
            return;
        }
        this.inform(ctx, name, text, false);
        int startOffsetPrevious = 0;
        int count = 1;
        char[] chars = text.toCharArray();
        while ((firstVersions = VersionSplitter.getFirstVersions(text, count)) != null) {
            this.inform(ctx, ctx, name + "[1-" + count + "]", firstVersions, true);
            if (count > 1) {
                this.inform(ctx, ctx, name + "[" + count + "-" + count + "]", firstVersions.substring(startOffsetPrevious), true);
            }
            if (++count > 3) {
                return;
            }
            startOffsetPrevious = VersionSplitter.findNextVersionStart(chars, firstVersions.length());
        }
    }

    @Override
    public void enterMultipleWords(UserAgentParser.MultipleWordsContext ctx) {
        this.informSubstrings(ctx, "text");
    }

    @Override
    public void enterKeyValue(UserAgentParser.KeyValueContext ctx) {
        this.inform(ctx, "keyvalue");
    }

    @Override
    public void enterKeyWithoutValue(UserAgentParser.KeyWithoutValueContext ctx) {
        this.inform(ctx, "keyvalue");
    }

    @Override
    public void enterKeyName(UserAgentParser.KeyNameContext ctx) {
        this.inform(ctx, "key");
    }

    @Override
    public void enterKeyValueVersionName(UserAgentParser.KeyValueVersionNameContext ctx) {
        this.informSubstrings(ctx, "version");
    }

    @Override
    public void enterVersionWords(UserAgentParser.VersionWordsContext ctx) {
        this.informSubstrings(ctx, "text");
    }

    @Override
    public void enterSiteUrl(UserAgentParser.SiteUrlContext ctx) {
        this.inform(ctx, "url", ctx.url.getText());
    }

    @Override
    public void enterUuId(UserAgentParser.UuIdContext ctx) {
        this.inform(ctx, "uuid", ctx.uuid.getText());
    }

    @Override
    public void enterEmailAddress(UserAgentParser.EmailAddressContext ctx) {
        this.inform(ctx, "email", ctx.email.getText());
    }

    @Override
    public void enterBase64(UserAgentParser.Base64Context ctx) {
        this.inform(ctx, "base64", ctx.value.getText());
    }

    @Override
    public void enterEmptyWord(UserAgentParser.EmptyWordContext ctx) {
        this.inform(ctx, "text", "");
    }

    public class State {
        long child = 0L;
        long version = 0L;
        long comment = 0L;
        final String name;
        String path;
        ParseTree ctx = null;

        public State(String name) {
            this.name = name;
        }

        public State(ParseTree ctx, String name) {
            this.ctx = ctx;
            this.name = name;
        }

        public String calculatePath(PathType type, boolean fakeChild) {
            ParseTree node = this.ctx;
            this.path = this.name;
            if (node == null) {
                return this.path;
            }
            State parentState = null;
            while (parentState == null) {
                if ((node = node.getParent()) == null) {
                    return this.path;
                }
                parentState = (State)UserAgentTreeFlattener.this.state.get(node);
            }
            long counter = 0L;
            switch (type) {
                case CHILD: {
                    if (!fakeChild) {
                        ++parentState.child;
                    }
                    counter = parentState.child;
                    break;
                }
                case COMMENT: {
                    if (!fakeChild) {
                        ++parentState.comment;
                    }
                    counter = parentState.comment;
                    break;
                }
                case VERSION: {
                    if (!fakeChild) {
                        ++parentState.version;
                    }
                    counter = parentState.version;
                    break;
                }
            }
            this.path = parentState.path + ".(" + counter + ')' + this.name;
            return this.path;
        }
    }

    static enum PathType {
        CHILD,
        COMMENT,
        VERSION;

    }
}

