/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.parse;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Pattern;

public final class EvilManualUseragentStringHacks {
    static Pattern missingProductAtStart = Pattern.compile("^\\(( |;|null|compatible|windows|android).*", 2);

    private EvilManualUseragentStringHacks() {
    }

    public static String fixIt(String useragent) {
        if (useragent == null) {
            return null;
        }
        String result = useragent;
        if (result.contains(" (Macintosh); ")) {
            result = EvilManualUseragentStringHacks.replaceString(result, " (Macintosh); ", " (Macintosh; ");
        }
        if (missingProductAtStart.matcher(result).matches()) {
            result = "Mozilla/5.0 " + result;
        } else if (result.startsWith("/")) {
            result = "Mozilla" + result;
        }
        if (useragent.endsWith(",gzip(gfe)")) {
            result = EvilManualUseragentStringHacks.replaceString(result, ",gzip(gfe)", "");
        }
        if (useragent.contains("__")) {
            result = EvilManualUseragentStringHacks.replaceString(result, "__", " ");
        }
        if (result.contains("%20")) {
            try {
                result = URLDecoder.decode(result, "UTF-8");
            }
            catch (UnsupportedEncodingException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static String replaceString(String input, String searchFor, String replaceWith) {
        int idxSearchFor;
        StringBuilder result = new StringBuilder(input.length() + 32);
        int startIdx = 0;
        while ((idxSearchFor = input.indexOf(searchFor, startIdx)) >= 0) {
            result.append(input.substring(startIdx, idxSearchFor));
            result.append(replaceWith);
            startIdx = idxSearchFor + searchFor.length();
        }
        result.append(input.substring(startIdx));
        return result.toString();
    }
}

