/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.analyze.Analyzer;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.analyze.MatcherAction;
import nl.basjes.parse.useragent.analyze.MatcherExtractAction;
import nl.basjes.parse.useragent.analyze.MatcherRequireAction;
import nl.basjes.parse.useragent.analyze.UselessMatcherException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Matcher {
    private static final Logger LOG = LoggerFactory.getLogger(Matcher.class);
    private final Analyzer analyzer;
    private final List<MatcherAction> dynamicActions;
    private final List<MatcherAction> fixedStringActions;
    private boolean forceEvaluation = false;
    final Map<String, Map<String, String>> lookups;
    private boolean verbose;
    private boolean permanentVerbose;
    private final UserAgent newValuesUserAgent = new UserAgent("dummy");
    boolean possiblyValid = false;

    Matcher(Analyzer analyzer, Map<String, Map<String, String>> lookups) {
        this.lookups = lookups;
        this.analyzer = analyzer;
        this.fixedStringActions = new ArrayList<MatcherAction>();
        this.dynamicActions = new ArrayList<MatcherAction>();
    }

    public Matcher(Analyzer analyzer, Map<String, Map<String, String>> lookups, Set<String> wantedFieldNames, Map<String, List<String>> matcherConfig) throws UselessMatcherException {
        List<String> requireConfigs;
        String attribute;
        String[] configParts;
        List<String> extractConfigs;
        this.lookups = lookups;
        this.analyzer = analyzer;
        this.fixedStringActions = new ArrayList<MatcherAction>();
        this.dynamicActions = new ArrayList<MatcherAction>();
        if (matcherConfig == null) {
            throw new InvalidParserConfigurationException("Got a 'null' config setting");
        }
        this.verbose = false;
        List<String> options = matcherConfig.get("options");
        if (options != null) {
            this.verbose = options.contains("verbose");
        }
        this.permanentVerbose = this.verbose;
        if (this.verbose) {
            LOG.info("---------------------------");
            LOG.info("- MATCHER -");
        }
        if ((extractConfigs = matcherConfig.get("extract")) == null) {
            throw new InvalidParserConfigurationException("Matcher does not extract anything");
        }
        if (wantedFieldNames != null) {
            boolean keep = false;
            for (String extractConfig : extractConfigs) {
                configParts = extractConfig.split(":", 3);
                if (configParts.length != 3) {
                    throw new InvalidParserConfigurationException("Invalid extract config line: " + extractConfig);
                }
                attribute = configParts[0].trim();
                if (!wantedFieldNames.contains(attribute)) continue;
                keep = true;
                break;
            }
            if (!keep) {
                throw new UselessMatcherException("Does not extract any wanted fields");
            }
        }
        if ((requireConfigs = matcherConfig.get("require")) != null) {
            for (String requireConfig : requireConfigs) {
                if (this.verbose) {
                    LOG.info("REQUIRE: {}", (Object)requireConfig);
                }
                this.dynamicActions.add(new MatcherRequireAction(requireConfig, this));
            }
        }
        for (String extractConfig : extractConfigs) {
            if (this.verbose) {
                LOG.info("EXTRACT: {}", (Object)extractConfig);
            }
            if ((configParts = extractConfig.split(":", 3)).length != 3) {
                throw new InvalidParserConfigurationException("Invalid extract config line: " + extractConfig);
            }
            attribute = configParts[0].trim();
            String confidence = configParts[1].trim();
            String config = configParts[2].trim();
            boolean wantThisAttribute = true;
            if (wantedFieldNames != null && !wantedFieldNames.contains(attribute)) {
                wantThisAttribute = false;
            }
            if (wantThisAttribute) {
                MatcherExtractAction action = new MatcherExtractAction(attribute, Long.parseLong(confidence), config, this);
                if (action.isFixedValue()) {
                    this.fixedStringActions.add(action);
                    continue;
                }
                this.dynamicActions.add(action);
                continue;
            }
            try {
                this.dynamicActions.add(new MatcherRequireAction(config, this));
            }
            catch (InvalidParserConfigurationException invalidParserConfigurationException) {}
        }
        for (MatcherAction action : this.dynamicActions) {
            action.reset();
            if (!action.canPossiblyBeValid()) continue;
            this.forceEvaluation = true;
            break;
        }
        if (this.verbose) {
            LOG.info("---------------------------");
        }
    }

    public Set<String> getAllPossibleFieldNames() {
        TreeSet<String> results = new TreeSet<String>();
        results.addAll(this.getAllPossibleFieldNames(this.dynamicActions));
        results.addAll(this.getAllPossibleFieldNames(this.fixedStringActions));
        results.remove("__Set_ALL_Fields__");
        return results;
    }

    private Set<String> getAllPossibleFieldNames(List<MatcherAction> actions) {
        TreeSet<String> results = new TreeSet<String>();
        for (MatcherAction action : actions) {
            if (!(action instanceof MatcherExtractAction)) continue;
            MatcherExtractAction extractAction = (MatcherExtractAction)action;
            results.add(extractAction.getAttribute());
        }
        return results;
    }

    public void informMeAbout(MatcherAction matcherAction, String keyPattern) {
        if (this.verbose) {
            LOG.info("Requested: {}", (Object)keyPattern);
        }
        this.analyzer.informMeAbout(matcherAction, keyPattern);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void analyze(UserAgent userAgent) {
        if (this.verbose) {
            LOG.info("");
            LOG.info("--- Matcher ------------------------");
            LOG.info("ANALYSE ----------------------------");
            boolean good = true;
            for (MatcherAction action : this.dynamicActions) {
                if (action.canPossiblyBeValid()) continue;
                LOG.error("CANNOT BE VALID : {}", (Object)action.getMatchExpression());
                good = false;
            }
            this.newValuesUserAgent.reset();
            for (MatcherAction action : this.dynamicActions) {
                if (action.obtainResult(this.newValuesUserAgent)) continue;
                LOG.error("FAILED : {}", (Object)action.getMatchExpression());
                good = false;
            }
            for (MatcherAction action : this.fixedStringActions) {
                if (action.obtainResult(this.newValuesUserAgent)) continue;
                LOG.error("FAILED : {}", (Object)action.getMatchExpression());
                good = false;
            }
            if (!good) {
                LOG.info("INCOMPLETE ----------------------------");
                return;
            }
            LOG.info("COMPLETE ----------------------------");
        } else {
            if (!this.forceEvaluation && !this.possiblyValid) {
                return;
            }
            for (MatcherAction action : this.dynamicActions) {
                if (action.canPossiblyBeValid()) continue;
                return;
            }
            this.newValuesUserAgent.reset();
            for (MatcherAction action : this.dynamicActions) {
                if (action.obtainResult(this.newValuesUserAgent)) continue;
                return;
            }
            for (MatcherAction action : this.fixedStringActions) {
                if (action.obtainResult(this.newValuesUserAgent)) continue;
                return;
            }
        }
        userAgent.set(this.newValuesUserAgent, this);
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void gotAStartingPoint() {
        this.possiblyValid = true;
    }

    public void reset(boolean setVerboseTemporarily) {
        this.possiblyValid = this.dynamicActions.isEmpty();
        for (MatcherAction action : this.dynamicActions) {
            action.reset();
            if (action.canPossiblyBeValid()) {
                this.possiblyValid = true;
            }
            if (setVerboseTemporarily) {
                this.verbose = true;
                action.setVerbose(true, true);
                continue;
            }
            this.verbose = this.permanentVerbose;
        }
    }

    public List<MatcherAction.Match> getMatches() {
        ArrayList<MatcherAction.Match> allMatches = new ArrayList<MatcherAction.Match>(128);
        for (MatcherAction action : this.dynamicActions) {
            allMatches.addAll(action.getMatches());
        }
        return allMatches;
    }

    public List<MatcherAction.Match> getUsedMatches() {
        ArrayList<MatcherAction.Match> allMatches = new ArrayList<MatcherAction.Match>(128);
        if (!this.possiblyValid) {
            return new ArrayList<MatcherAction.Match>();
        }
        for (MatcherAction action : this.dynamicActions) {
            if (action.canPossiblyBeValid()) continue;
            return new ArrayList<MatcherAction.Match>();
        }
        for (MatcherAction action : this.dynamicActions) {
            if (!action.obtainResult(this.newValuesUserAgent)) {
                return new ArrayList<MatcherAction.Match>();
            }
            allMatches.addAll(action.getMatches());
        }
        return allMatches;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append("MATCHER:\n");
        sb.append("    REQUIRE:\n");
        for (MatcherAction action : this.dynamicActions) {
            if (!(action instanceof MatcherRequireAction)) continue;
            sb.append("        ").append(action.getMatchExpression()).append("\n");
        }
        sb.append("    EXTRACT:\n");
        for (MatcherAction action : this.dynamicActions) {
            if (!(action instanceof MatcherExtractAction)) continue;
            sb.append("        ").append(action.toString()).append("\n");
        }
        for (MatcherAction action : this.fixedStringActions) {
            sb.append("        ").append(action.toString()).append("\n");
        }
        return sb.toString();
    }
}

