/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.Version;
import nl.basjes.parse.useragent.analyze.Analyzer;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.analyze.Matcher;
import nl.basjes.parse.useragent.analyze.MatcherAction;
import nl.basjes.parse.useragent.analyze.UselessMatcherException;
import nl.basjes.parse.useragent.parse.UserAgentTreeFlattener;
import nl.basjes.parse.useragent.utils.Normalize;
import nl.basjes.parse.useragent.utils.VersionSplitter;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.ParseTree;
import nl.basjes.shaded.org.springframework.core.io.Resource;
import nl.basjes.shaded.org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.apache.commons.collections4.map.LRUMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class UserAgentAnalyzer
extends Analyzer {
    private static final int INFORM_ACTIONS_HASHMAP_SIZE = 300000;
    private static final int DEFAULT_PARSE_CACHE_SIZE = 10000;
    private static final Logger LOG = LoggerFactory.getLogger(UserAgentAnalyzer.class);
    protected List<Matcher> allMatchers = new ArrayList<Matcher>();
    private Map<String, Set<MatcherAction>> informMatcherActions = new HashMap<String, Set<MatcherAction>>(300000);
    private final Map<String, List<Map<String, List<String>>>> matcherConfigs = new HashMap<String, List<Map<String, List<String>>>>(64);
    private boolean doingOnlyASingleTest = false;
    protected Set<String> wantedFieldNames = null;
    protected final List<Map<String, Map<String, String>>> testCases = new ArrayList<Map<String, Map<String, String>>>(2048);
    private Map<String, Map<String, String>> lookups = new HashMap<String, Map<String, String>>(128);
    protected UserAgentTreeFlattener flattener;
    private Yaml yaml;
    private LRUMap<String, UserAgent> parseCache = new LRUMap(10000);
    private boolean verbose = false;
    private static final List<String> HARD_CODED_GENERATED_FIELDS = new ArrayList<String>();

    public UserAgentAnalyzer() {
        this(true);
    }

    protected UserAgentAnalyzer(boolean initialize) {
        if (initialize) {
            this.initialize(true);
        }
    }

    protected void initialize(boolean showMatcherStats) {
        UserAgentAnalyzer.logVersion();
        this.loadResources("classpath*:UserAgents/**/*.yaml", showMatcherStats);
    }

    public UserAgentAnalyzer(String resourceString) {
        this.loadResources(resourceString, true);
    }

    public static void logVersion() {
        String[] lines = new String[]{"For more information: https://github.com/nielsbasjes/yauaa", "Copyright (C) 2013-2017 Niels Basjes - License Apache 2.0"};
        String version = UserAgentAnalyzer.getVersion();
        int width = version.length();
        for (String line : lines) {
            width = Math.max(width, line.length());
        }
        LOG.info("");
        LOG.info("/-{}-\\", (Object)UserAgentAnalyzer.padding('-', width));
        UserAgentAnalyzer.logLine(version, width);
        LOG.info("+-{}-+", (Object)UserAgentAnalyzer.padding('-', width));
        for (String line : lines) {
            UserAgentAnalyzer.logLine(line, width);
        }
        LOG.info("\\-{}-/", (Object)UserAgentAnalyzer.padding('-', width));
        LOG.info("");
    }

    private static String padding(char letter, int count) {
        StringBuilder sb = new StringBuilder(128);
        for (int i = 0; i < count; ++i) {
            sb.append(letter);
        }
        return sb.toString();
    }

    private static void logLine(String line, int width) {
        LOG.info("| {}{} |", (Object)line, (Object)UserAgentAnalyzer.padding(' ', width - line.length()));
    }

    public static String getVersion() {
        return "Yauaa " + Version.getProjectVersion() + " (" + Version.getGitCommitIdDescribeShort() + " @ " + Version.getBuildTimestamp() + ")";
    }

    /*
     * WARNING - void declaration
     */
    public void loadResources(String resourceString, boolean showMatcherStats) {
        void var7_14;
        LOG.info("Loading from: \"{}\"", (Object)resourceString);
        this.flattener = new UserAgentTreeFlattener(this);
        this.yaml = new Yaml();
        TreeMap<String, Resource> resources = new TreeMap<String, Resource>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resourceArray = resolver.getResources(resourceString);
            for (Resource resource : resourceArray) {
                resources.put(resource.getFilename(), resource);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.doingOnlyASingleTest = false;
        int maxFilenameLength = 0;
        if (resources.isEmpty()) {
            throw new InvalidParserConfigurationException("Unable to find ANY config files");
        }
        for (Map.Entry entry : resources.entrySet()) {
            try {
                Resource resource = (Resource)entry.getValue();
                String filename = resource.getFilename();
                maxFilenameLength = Math.max(maxFilenameLength, filename.length());
                this.loadResource(resource.getInputStream(), filename);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        LOG.info("Loaded {} files", (Object)resources.size());
        if (this.lookups != null && !this.lookups.isEmpty()) {
            HashMap<String, Map<String, String>> cleanedLookups = new HashMap<String, Map<String, String>>(this.lookups.size());
            for (Map.Entry<String, Map<String, String>> lookupsEntry : this.lookups.entrySet()) {
                HashMap<String, Object> cleanedLookup = new HashMap<String, Object>(lookupsEntry.getValue().size());
                for (Map.Entry<Object, Object> entry : lookupsEntry.getValue().entrySet()) {
                    cleanedLookup.put(((String)entry.getKey()).toLowerCase(), entry.getValue());
                }
                cleanedLookups.put(lookupsEntry.getKey(), cleanedLookup);
            }
            this.lookups = cleanedLookups;
        }
        LOG.info("Building all matchers");
        int totalNumberOfMatchers = 0;
        boolean bl = false;
        if (this.matcherConfigs != null) {
            long fullStart = System.nanoTime();
            for (Map.Entry entry : resources.entrySet()) {
                Resource resource = (Resource)entry.getValue();
                String configFilename = resource.getFilename();
                List<Map<String, List<String>>> matcherConfig = this.matcherConfigs.get(configFilename);
                if (matcherConfig == null) continue;
                long start = System.nanoTime();
                int startSize = this.informMatcherActions.size();
                for (Map<String, List<String>> map : matcherConfig) {
                    try {
                        this.allMatchers.add(new Matcher(this, this.lookups, this.wantedFieldNames, map));
                        ++totalNumberOfMatchers;
                    }
                    catch (UselessMatcherException ume) {
                        ++var7_14;
                    }
                }
                long stop = System.nanoTime();
                int stopSize = this.informMatcherActions.size();
                if (!showMatcherStats) continue;
                Formatter msg = new Formatter(Locale.ENGLISH);
                msg.format("Building %4d matchers from %-" + maxFilenameLength + "s took %5d msec resulted in %8d extra hashmap entries", matcherConfig.size(), configFilename, (stop - start) / 1000000L, stopSize - startSize);
                LOG.info(msg.toString());
            }
            long fullStop = System.nanoTime();
            Formatter msg = new Formatter(Locale.ENGLISH);
            msg.format("Building %4d (dropped %4d) matchers from %4d files took %5d msec resulted in %8d hashmap entries", totalNumberOfMatchers, (int)var7_14, this.matcherConfigs.size(), (fullStop - fullStart) / 1000000L, this.informMatcherActions.size());
            LOG.info(msg.toString());
        }
        LOG.info("Analyzer stats");
        LOG.info("Lookups      : {}", (Object)(this.lookups == null ? 0 : this.lookups.size()));
        LOG.info("Matchers     : {} (total:{} ; dropped: {})", new Object[]{this.allMatchers.size(), totalNumberOfMatchers, (int)var7_14});
        LOG.info("Hashmap size : {}", (Object)this.informMatcherActions.size());
        LOG.info("Testcases    : {}", (Object)this.testCases.size());
    }

    public void eraseTestCases() {
        this.testCases.clear();
    }

    public Set<String> getAllPossibleFieldNames() {
        TreeSet<String> results = new TreeSet<String>();
        results.addAll(HARD_CODED_GENERATED_FIELDS);
        for (Matcher matcher : this.allMatchers) {
            results.addAll(matcher.getAllPossibleFieldNames());
        }
        return results;
    }

    public List<String> getAllPossibleFieldNamesSorted() {
        ArrayList<String> fieldNames = new ArrayList<String>(this.getAllPossibleFieldNames());
        Collections.sort(fieldNames);
        ArrayList<String> result = new ArrayList<String>();
        for (String fieldName : UserAgent.PRE_SORTED_FIELDS_LIST) {
            fieldNames.remove(fieldName);
            result.add(fieldName);
        }
        for (String fieldName : fieldNames) {
            result.add(fieldName);
        }
        return result;
    }

    private void loadResource(InputStream yamlStream, String filename) {
        Object loadedYaml;
        try {
            loadedYaml = this.yaml.load(yamlStream);
        }
        catch (Exception e) {
            LOG.error("Caught exception during parse of file {}", (Object)filename);
            throw e;
        }
        if (!(loadedYaml instanceof Map)) {
            throw new InvalidParserConfigurationException("Yaml config  (" + filename + "): File must be a Map");
        }
        Object rawConfig = ((Map)loadedYaml).get("config");
        if (rawConfig == null) {
            throw new InvalidParserConfigurationException("Yaml config (" + filename + "): Missing 'config' top level entry");
        }
        if (!(rawConfig instanceof List)) {
            throw new InvalidParserConfigurationException("Yaml config (" + filename + "): Top level 'config' must be a Map");
        }
        List configList = (List)rawConfig;
        int entryCount = 0;
        block12: for (Object configEntry : configList) {
            ++entryCount;
            if (!(configEntry instanceof Map)) {
                throw new InvalidParserConfigurationException("Yaml config (" + filename + " [" + entryCount + "]): Entry must be a Map");
            }
            Map entry = (Map)configEntry;
            if (entry.size() != 1) {
                StringBuilder sb = new StringBuilder();
                for (String key : entry.keySet()) {
                    sb.append('\"').append(key).append("\" ");
                }
                throw new InvalidParserConfigurationException("Yaml config (" + filename + " [" + entryCount + "]): Entry has more than one child: " + sb.toString());
            }
            Map.Entry onlyEntry = entry.entrySet().iterator().next();
            String key = (String)onlyEntry.getKey();
            Object value = onlyEntry.getValue();
            switch (key) {
                case "lookup": {
                    if (!(value instanceof Map)) {
                        throw new InvalidParserConfigurationException("Yaml config (" + filename + " [" + entryCount + "]): Entry 'lookup' must be a Map");
                    }
                    Map newLookup = (Map)value;
                    Object rawName = newLookup.get("name");
                    if (rawName == null) {
                        throw new InvalidParserConfigurationException("Yaml config (" + filename + " [" + entryCount + "]): Lookup does not have 'name'");
                    }
                    if (!(rawName instanceof String)) {
                        throw new InvalidParserConfigurationException("Yaml config (" + filename + " [" + entryCount + "]): Lookup 'name' must be a String");
                    }
                    Object rawMap = newLookup.get("map");
                    if (rawMap == null) {
                        throw new InvalidParserConfigurationException("Yaml config (" + filename + " [" + entryCount + "]): Lookup does not have 'map'");
                    }
                    if (!(rawMap instanceof Map)) {
                        throw new InvalidParserConfigurationException("Yaml config (" + filename + " [" + entryCount + "]): Lookup 'map' must be a Map");
                    }
                    Map map = (Map)rawMap;
                    this.lookups.put((String)rawName, map);
                    continue block12;
                }
                case "matcher": {
                    if (!(value instanceof Map)) {
                        throw new InvalidParserConfigurationException("Yaml config (" + filename + "): Entry 'matcher' must be a Map");
                    }
                    Map matcherConfig = (Map)value;
                    List<Map<String, List<String>>> matcherConfigList = this.matcherConfigs.get(filename);
                    if (matcherConfigList == null) {
                        matcherConfigList = new ArrayList<Map<String, List<String>>>(32);
                        this.matcherConfigs.put(filename, matcherConfigList);
                    }
                    matcherConfigList.add(matcherConfig);
                    continue block12;
                }
                case "test": {
                    if (this.doingOnlyASingleTest) continue block12;
                    if (!(value instanceof Map)) {
                        throw new InvalidParserConfigurationException("Yaml config (" + filename + "): Entry 'testcase' must be a Map");
                    }
                    Map testCase = (Map)value;
                    HashMap<String, String> metaData = (HashMap<String, String>)testCase.get("metaData");
                    if (metaData == null) {
                        metaData = new HashMap<String, String>();
                        testCase.put("metaData", metaData);
                    }
                    metaData.put("filename", filename);
                    metaData.put("fileentry", String.valueOf(entryCount));
                    List options = (List)testCase.get("options");
                    Map expected = (Map)testCase.get("expected");
                    if (options != null && options.contains("only")) {
                        this.doingOnlyASingleTest = true;
                        this.testCases.clear();
                    }
                    if (expected == null || expected.isEmpty()) {
                        this.doingOnlyASingleTest = true;
                        this.testCases.clear();
                    }
                    this.testCases.add(testCase);
                    continue block12;
                }
            }
            throw new InvalidParserConfigurationException("Yaml config (" + filename + "): Found unexpected config entry: " + key + ", allowed are 'lookup, 'matcher' and 'test'");
        }
    }

    @Override
    public void informMeAbout(MatcherAction matcherAction, String keyPattern) {
        String hashKey = keyPattern.toLowerCase();
        Set<MatcherAction> analyzerSet = this.informMatcherActions.get(hashKey);
        if (analyzerSet == null) {
            analyzerSet = new HashSet<MatcherAction>();
            this.informMatcherActions.put(hashKey, analyzerSet);
        }
        analyzerSet.add(matcherAction);
    }

    public void setVerbose(boolean newVerbose) {
        this.verbose = newVerbose;
        this.flattener.setVerbose(newVerbose);
    }

    public UserAgent parse(String userAgentString) {
        UserAgent userAgent = new UserAgent(userAgentString);
        return this.cachedParse(userAgent);
    }

    public UserAgent parse(UserAgent userAgent) {
        userAgent.reset();
        return this.cachedParse(userAgent);
    }

    public void disableCaching() {
        this.setCacheSize(0);
    }

    public void setCacheSize(int newCacheSize) {
        this.parseCache = newCacheSize >= 1 ? new LRUMap(newCacheSize) : null;
    }

    public int getCacheSize() {
        if (this.parseCache == null) {
            return 0;
        }
        return this.parseCache.maxSize();
    }

    private synchronized UserAgent cachedParse(UserAgent userAgent) {
        if (this.parseCache == null) {
            return this.nonCachedParse(userAgent);
        }
        String userAgentString = userAgent.getUserAgentString();
        UserAgent cachedValue = (UserAgent)this.parseCache.get((Object)userAgentString);
        if (cachedValue != null) {
            userAgent.clone(cachedValue);
        } else {
            cachedValue = new UserAgent(this.nonCachedParse(userAgent));
            this.parseCache.put((Object)userAgentString, (Object)cachedValue);
        }
        return userAgent;
    }

    private UserAgent nonCachedParse(UserAgent userAgent) {
        boolean setVerboseTemporarily = userAgent.isDebug();
        for (Matcher matcher : this.allMatchers) {
            matcher.reset(setVerboseTemporarily);
        }
        userAgent = this.flattener.parse(userAgent);
        for (Matcher matcher : this.allMatchers) {
            matcher.analyze(userAgent);
        }
        userAgent.processSetAll();
        return this.hardCodedPostProcessing(userAgent);
    }

    private UserAgent hardCodedPostProcessing(UserAgent userAgent) {
        UserAgent.AgentField deviceName;
        UserAgent.AgentField email;
        if ("true".equals(userAgent.getValue("__SyntaxError__")) && userAgent.get("DeviceClass").getConfidence() == -1L && userAgent.get("OperatingSystemClass").getConfidence() == -1L && userAgent.get("LayoutEngineClass").getConfidence() == -1L) {
            userAgent.set("DeviceClass", "Hacker", 10L);
            userAgent.set("DeviceBrand", "Hacker", 10L);
            userAgent.set("DeviceName", "Hacker", 10L);
            userAgent.set("DeviceVersion", "Hacker", 10L);
            userAgent.set("OperatingSystemClass", "Hacker", 10L);
            userAgent.set("OperatingSystemName", "Hacker", 10L);
            userAgent.set("OperatingSystemVersion", "Hacker", 10L);
            userAgent.set("LayoutEngineClass", "Hacker", 10L);
            userAgent.set("LayoutEngineName", "Hacker", 10L);
            userAgent.set("LayoutEngineVersion", "Hacker", 10L);
            userAgent.set("LayoutEngineVersionMajor", "Hacker", 10L);
            userAgent.set("AgentClass", "Hacker", 10L);
            userAgent.set("AgentName", "Hacker", 10L);
            userAgent.set("AgentVersion", "Hacker", 10L);
            userAgent.set("AgentVersionMajor", "Hacker", 10L);
            userAgent.set("HackerToolkit", "Unknown", 10L);
            userAgent.set("HackerAttackVector", "Unknown", 10L);
        }
        this.addMajorVersionField(userAgent, "AgentVersion", "AgentVersionMajor");
        this.addMajorVersionField(userAgent, "LayoutEngineVersion", "LayoutEngineVersionMajor");
        this.addMajorVersionField(userAgent, "WebviewAppVersion", "WebviewAppVersionMajor");
        this.concatFieldValuesNONDuplicated(userAgent, "AgentNameVersion", "AgentName", "AgentVersion");
        this.concatFieldValuesNONDuplicated(userAgent, "AgentNameVersionMajor", "AgentName", "AgentVersionMajor");
        this.concatFieldValuesNONDuplicated(userAgent, "WebviewAppNameVersionMajor", "WebviewAppName", "WebviewAppVersionMajor");
        this.concatFieldValuesNONDuplicated(userAgent, "LayoutEngineNameVersion", "LayoutEngineName", "LayoutEngineVersion");
        this.concatFieldValuesNONDuplicated(userAgent, "LayoutEngineNameVersionMajor", "LayoutEngineName", "LayoutEngineVersionMajor");
        this.concatFieldValuesNONDuplicated(userAgent, "OperatingSystemNameVersion", "OperatingSystemName", "OperatingSystemVersion");
        UserAgent.AgentField deviceBrand = userAgent.get("DeviceBrand");
        if (deviceBrand.getConfidence() >= 0L) {
            userAgent.set("DeviceBrand", Normalize.brand(deviceBrand.getValue()), deviceBrand.getConfidence() + 1L);
        }
        if ((email = userAgent.get("AgentInformationEmail")) != null && email.getConfidence() >= 0L) {
            userAgent.set("AgentInformationEmail", Normalize.email(email.getValue()), email.getConfidence() + 1L);
        }
        if ((deviceName = userAgent.get("DeviceName")).getConfidence() >= 0L) {
            deviceBrand = userAgent.get("DeviceBrand");
            String deviceNameValue = deviceName.getValue();
            String deviceBrandValue = deviceBrand.getValue();
            deviceNameValue = deviceName.getConfidence() >= 0L && deviceBrand.getConfidence() >= 0L && !deviceBrandValue.equals("Unknown") ? Normalize.cleanupDeviceBrandName(deviceBrandValue, deviceNameValue) : Normalize.brand(deviceNameValue);
            userAgent.set("DeviceName", deviceNameValue, deviceName.getConfidence() + 1L);
        }
        return userAgent;
    }

    private void concatFieldValuesNONDuplicated(UserAgent userAgent, String targetName, String firstName, String secondName) {
        UserAgent.AgentField firstField = userAgent.get(firstName);
        UserAgent.AgentField secondField = userAgent.get(secondName);
        String first = null;
        long firstConfidence = -1L;
        String second = null;
        long secondConfidence = -1L;
        if (firstField != null) {
            first = firstField.getValue();
            firstConfidence = firstField.getConfidence();
        }
        if (secondField != null) {
            second = secondField.getValue();
            secondConfidence = secondField.getConfidence();
        }
        if (first == null && second == null) {
            return;
        }
        if (second == null) {
            if (firstConfidence >= 0L) {
                userAgent.set(targetName, first, firstConfidence);
                return;
            }
            return;
        }
        if (first == null) {
            if (secondConfidence >= 0L) {
                userAgent.set(targetName, second, secondConfidence);
                return;
            }
            return;
        }
        if (first.equals(second)) {
            userAgent.set(targetName, first, firstConfidence);
        } else if (second.startsWith(first)) {
            userAgent.set(targetName, second, secondConfidence);
        } else {
            userAgent.set(targetName, first + " " + second, Math.max(firstField.getConfidence(), secondField.getConfidence()));
        }
    }

    private void addMajorVersionField(UserAgent userAgent, String versionName, String majorVersionName) {
        UserAgent.AgentField agentVersion;
        UserAgent.AgentField agentVersionMajor = userAgent.get(majorVersionName);
        if ((agentVersionMajor == null || agentVersionMajor.getConfidence() == -1L) && (agentVersion = userAgent.get(versionName)) != null) {
            userAgent.set(majorVersionName, VersionSplitter.getSingleVersion(agentVersion.getValue(), 1), agentVersion.getConfidence());
        }
    }

    @Override
    public void inform(String key, String value, ParseTree ctx) {
        this.inform(key, key, value, ctx);
        this.inform(key + "=\"" + value + '\"', key, value, ctx);
    }

    private void inform(String match, String key, String value, ParseTree ctx) {
        Set<MatcherAction> relevantActions = this.informMatcherActions.get(match.toLowerCase());
        if (this.verbose) {
            if (relevantActions == null) {
                LOG.info("--- Have (0): {}", (Object)match);
            } else {
                LOG.info("+++ Have ({}): {}", (Object)relevantActions.size(), (Object)match);
                int count = 1;
                for (MatcherAction action : relevantActions) {
                    LOG.info("+++ -------> ({}): {}", (Object)count, (Object)action.toString());
                    ++count;
                }
            }
        }
        if (relevantActions != null) {
            for (MatcherAction matcherAction : relevantActions) {
                matcherAction.inform(key, value, ctx);
            }
        }
    }

    public static List<String> getAllPaths(String agent) {
        return new GetAllPathsAnalyzer(agent).getValues();
    }

    public static GetAllPathsAnalyzer getAllPathsAnalyzer(String agent) {
        return new GetAllPathsAnalyzer(agent);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static {
        HARD_CODED_GENERATED_FIELDS.add("__SyntaxError__");
        HARD_CODED_GENERATED_FIELDS.add("AgentVersionMajor");
        HARD_CODED_GENERATED_FIELDS.add("LayoutEngineVersionMajor");
        HARD_CODED_GENERATED_FIELDS.add("AgentNameVersion");
        HARD_CODED_GENERATED_FIELDS.add("AgentNameVersionMajor");
        HARD_CODED_GENERATED_FIELDS.add("LayoutEngineNameVersion");
        HARD_CODED_GENERATED_FIELDS.add("LayoutEngineNameVersionMajor");
        HARD_CODED_GENERATED_FIELDS.add("OperatingSystemNameVersion");
        HARD_CODED_GENERATED_FIELDS.add("WebviewAppVersionMajor");
        HARD_CODED_GENERATED_FIELDS.add("WebviewAppNameVersionMajor");
    }

    public static class Builder {
        private final UserAgentAnalyzer uaa;
        boolean showMatcherLoadStats = true;

        protected Builder() {
            this.uaa = new UserAgentAnalyzer(false);
        }

        protected Builder(UserAgentAnalyzer forceAnalyzer) {
            this.uaa = forceAnalyzer;
        }

        public Builder withCache(int cacheSize) {
            this.uaa.setCacheSize(cacheSize);
            return this;
        }

        public Builder withoutCache() {
            this.uaa.setCacheSize(0);
            return this;
        }

        public Builder withField(String fieldName) {
            if (this.uaa.wantedFieldNames == null) {
                this.uaa.wantedFieldNames = new HashSet<String>(32);
            }
            this.uaa.wantedFieldNames.add(fieldName);
            return this;
        }

        public Builder withFields(Collection<String> fieldNames) {
            if (fieldNames == null) {
                return this;
            }
            for (String fieldName : fieldNames) {
                this.withField(fieldName);
            }
            return this;
        }

        public Builder withAllFields() {
            this.uaa.wantedFieldNames = null;
            return this;
        }

        public Builder showMatcherLoadStats() {
            this.showMatcherLoadStats = true;
            return this;
        }

        public Builder hideMatcherLoadStats() {
            this.showMatcherLoadStats = false;
            return this;
        }

        private void addGeneratedFields(String result, String ... dependencies) {
            if (this.uaa.wantedFieldNames.contains(result)) {
                Collections.addAll(this.uaa.wantedFieldNames, dependencies);
            }
        }

        public UserAgentAnalyzer build() {
            if (this.uaa.wantedFieldNames != null) {
                this.addGeneratedFields("AgentNameVersion", "AgentName", "AgentVersion");
                this.addGeneratedFields("AgentNameVersionMajor", "AgentName", "AgentVersionMajor");
                this.addGeneratedFields("WebviewAppNameVersionMajor", "WebviewAppName", "WebviewAppVersionMajor");
                this.addGeneratedFields("LayoutEngineNameVersion", "LayoutEngineName", "LayoutEngineVersion");
                this.addGeneratedFields("LayoutEngineNameVersionMajor", "LayoutEngineName", "LayoutEngineVersionMajor");
                this.addGeneratedFields("OperatingSystemNameVersion", "OperatingSystemName", "OperatingSystemVersion");
                this.addGeneratedFields("DeviceName", "DeviceBrand");
                this.addGeneratedFields("AgentVersionMajor", "AgentVersion");
                this.addGeneratedFields("LayoutEngineVersionMajor", "LayoutEngineVersion");
                this.addGeneratedFields("WebviewAppVersionMajor", "WebviewAppVersion");
                this.uaa.wantedFieldNames.add("__Set_ALL_Fields__");
            }
            this.uaa.initialize(this.showMatcherLoadStats);
            return this.uaa;
        }
    }

    public static class GetAllPathsAnalyzer
    extends Analyzer {
        final List<String> values = new ArrayList<String>(128);
        final UserAgentTreeFlattener flattener = new UserAgentTreeFlattener(this);
        private final UserAgent result;

        GetAllPathsAnalyzer(String useragent) {
            this.result = this.flattener.parse(useragent);
        }

        public List<String> getValues() {
            return this.values;
        }

        public UserAgent getResult() {
            return this.result;
        }

        @Override
        public void inform(String path, String value, ParseTree ctx) {
            this.values.add(path);
            this.values.add(path + "=\"" + value + "\"");
        }

        @Override
        public void informMeAbout(MatcherAction matcherAction, String keyPattern) {
        }
    }
}

