/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.PrimitiveUType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.UntypedAtomicValue;

public class MapUntypedContains
extends ExtensionFunctionDefinition {
    private static final StructuredQName name = new StructuredQName("map", "http://www.w3.org/2005/xpath-functions/map", "untyped-contains");
    private static final SequenceType[] ARG_TYPES = new SequenceType[]{HashTrieMap.SINGLE_MAP_TYPE, SequenceType.SINGLE_ATOMIC};

    public StructuredQName getFunctionQName() {
        return name;
    }

    public int getMinimumNumberOfArguments() {
        return 2;
    }

    public SequenceType[] getArgumentTypes() {
        return ARG_TYPES;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_BOOLEAN;
    }

    public boolean trustResultType() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
                ConversionRules rules = context.getConfiguration().getConversionRules();
                MapItem map = (MapItem)arguments[0].head();
                AtomicValue key = (AtomicValue)arguments[1].head();
                if (key instanceof UntypedAtomicValue) {
                    for (PrimitiveUType prim : map.getKeyUType().decompose()) {
                        BuiltInAtomicType t = (BuiltInAtomicType)prim.toItemType();
                        StringConverter converter = t.getStringConverter(rules);
                        ConversionResult av = converter.convert(key);
                        if (av instanceof ValidationFailure || map.get(av.asAtomic()) == null) continue;
                        return BooleanValue.TRUE;
                    }
                    return BooleanValue.FALSE;
                }
                boolean result = map.get(key) != null;
                return BooleanValue.get(result);
            }
        };
    }
}

