/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.lyra;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import net.jodah.lyra.ConnectionOptions;
import net.jodah.lyra.config.Config;
import net.jodah.lyra.config.ConfigurableConnection;
import net.jodah.lyra.internal.ConnectionHandler;
import net.jodah.lyra.internal.util.Assert;

public final class Connections {
    private static final Class<?>[] CONNECTION_TYPES = new Class[]{ConfigurableConnection.class};

    private Connections() {
    }

    public static ConfigurableConnection create(Config config) throws IOException {
        return Connections.create(new ConnectionOptions(), config);
    }

    public static ConfigurableConnection create(ConnectionFactory connectionFactory, Config config) throws IOException {
        Assert.notNull(connectionFactory, "connectionFactory");
        return Connections.create(new ConnectionOptions(connectionFactory), config);
    }

    public static ConfigurableConnection create(ConnectionOptions options, Config config) throws IOException {
        Assert.notNull(options, "options");
        Assert.notNull(config, "config");
        ConnectionHandler handler = new ConnectionHandler(options.copy(), new Config(config));
        ConfigurableConnection proxy = (ConfigurableConnection)Proxy.newProxyInstance(Connection.class.getClassLoader(), CONNECTION_TYPES, (InvocationHandler)handler);
        handler.createConnection(proxy);
        return proxy;
    }
}

