/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.dongliu.requests.ResponseProcessor;
import net.dongliu.requests.struct.Headers;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;

final class FileResponseProcessor
implements ResponseProcessor<File> {
    private final File file;

    public FileResponseProcessor(String filePath) {
        this.file = new File(filePath);
    }

    public FileResponseProcessor(File file) {
        this.file = file;
    }

    @Override
    public File convert(int statusCode, Headers headers, HttpEntity httpEntity) throws IOException {
        if (statusCode != 200) {
            EntityUtils.consume((HttpEntity)httpEntity);
            return null;
        }
        try (InputStream in = httpEntity.getContent();
             FileOutputStream out = new FileOutputStream(this.file);){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, len);
            }
        }
        return this.file;
    }
}

