/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Objects;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import net.dongliu.requests.AllRedirectStrategy;
import net.dongliu.requests.AllTrustManager;
import net.dongliu.requests.Client;
import net.dongliu.requests.ClientBuilderInterface;
import net.dongliu.requests.CustomConnectionSocketFactory;
import net.dongliu.requests.CustomSSLConnectionSocketFactory;
import net.dongliu.requests.struct.Proxy;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;

public abstract class ClientBuilder<T extends ClientBuilder<T>>
implements ClientBuilderInterface<T> {
    static final String defaultUserAgent = "Requests/2.1.5, Java " + System.getProperty("java.version");
    static final int defaultTimeout = 10000;
    protected long timeToLive = -1L;
    private Proxy proxy;
    private boolean verify = true;
    private boolean compress = true;
    private boolean allowRedirects = true;
    private String userAgent = defaultUserAgent;
    private int connectTimeout = 10000;
    private int socketTimeout = 10000;
    private boolean closeOnRequstFinished = false;

    ClientBuilder() {
    }

    public Client build() {
        Registry<ConnectionSocketFactory> registry = this.getConnectionSocketFactoryRegistry(this.proxy, this.verify);
        HttpClientConnectionManager connectionManager = this.buildManager(registry);
        HttpClientBuilder clientBuilder = HttpClients.custom().setUserAgent(this.userAgent);
        clientBuilder.setConnectionManager(connectionManager);
        RequestConfig.Builder configBuilder = RequestConfig.custom().setConnectTimeout(this.connectTimeout).setSocketTimeout(this.socketTimeout).setConnectionRequestTimeout(this.connectTimeout).setCookieSpec("default");
        clientBuilder.setDefaultRequestConfig(configBuilder.build());
        if (!this.compress) {
            clientBuilder.disableContentCompression();
        }
        if (this.allowRedirects) {
            clientBuilder.setRedirectStrategy((RedirectStrategy)new AllRedirectStrategy());
        } else {
            clientBuilder.disableRedirectHandling();
        }
        return new Client(clientBuilder.build(), this.closeOnRequstFinished);
    }

    protected Registry<ConnectionSocketFactory> getConnectionSocketFactoryRegistry(Proxy proxy, boolean verify) {
        SSLContext sslContext;
        if (!verify) {
            try {
                sslContext = SSLContexts.custom().useTLS().build();
                sslContext.init(new KeyManager[0], new TrustManager[]{new AllTrustManager()}, new SecureRandom());
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        } else {
            sslContext = SSLContexts.createSystemDefault();
        }
        CustomSSLConnectionSocketFactory sslsf = new CustomSSLConnectionSocketFactory(sslContext, proxy, verify);
        CustomConnectionSocketFactory psf = new CustomConnectionSocketFactory(proxy);
        return RegistryBuilder.create().register("http", (Object)psf).register("https", (Object)sslsf).build();
    }

    @Override
    public T timeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
        return this.self();
    }

    @Override
    public T userAgent(String userAgent) {
        Objects.requireNonNull(userAgent);
        this.userAgent = userAgent;
        return this.self();
    }

    @Override
    public T verify(boolean verify) {
        this.verify = verify;
        return this.self();
    }

    @Override
    public T allowRedirects(boolean allowRedirects) {
        this.allowRedirects = allowRedirects;
        return this.self();
    }

    @Override
    public T compress(boolean compress) {
        this.compress = compress;
        return this.self();
    }

    @Override
    public T proxy(Proxy proxy) {
        this.proxy = proxy;
        return this.self();
    }

    @Override
    public T timeout(int timeout) {
        this.connectTimeout = this.socketTimeout = timeout;
        return this.self();
    }

    @Override
    public T socketTimeout(int timeout) {
        this.socketTimeout = timeout;
        return this.self();
    }

    @Override
    public T connectTimeout(int timeout) {
        this.connectTimeout = timeout;
        return this.self();
    }

    T closeOnRequstFinished(boolean closeOnRequstFinished) {
        this.closeOnRequstFinished = closeOnRequstFinished;
        return this.self();
    }

    protected abstract T self();

    protected abstract HttpClientConnectionManager buildManager(Registry<ConnectionSocketFactory> var1);
}

