/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.InetAddressUtilities;
import com.github.kristofa.brave.ServerClientAndLocalSpanState;
import com.github.kristofa.brave.ServerSpan;
import com.github.kristofa.brave.internal.Util;
import com.twitter.zipkin.gen.Endpoint;
import com.twitter.zipkin.gen.Span;
import java.net.InetAddress;

public final class ThreadLocalServerClientAndLocalSpanState
implements ServerClientAndLocalSpanState {
    private static final ThreadLocal<ServerSpan> currentServerSpan = new ThreadLocal<ServerSpan>(){

        @Override
        protected ServerSpan initialValue() {
            return ServerSpan.EMPTY;
        }
    };
    private static final ThreadLocal<Span> currentClientSpan = new ThreadLocal();
    private static final ThreadLocal<Span> currentLocalSpan = new ThreadLocal();
    private final Endpoint endpoint;

    @Deprecated
    public ThreadLocalServerClientAndLocalSpanState(InetAddress ip, int port, String serviceName) {
        this(InetAddressUtilities.toInt(Util.checkNotNull(ip, "ip address must be specified.", new Object[0])), port, serviceName);
    }

    public ThreadLocalServerClientAndLocalSpanState(int ip, int port, String serviceName) {
        this(Endpoint.builder().ipv4(ip).port(port).serviceName(serviceName).build());
    }

    public ThreadLocalServerClientAndLocalSpanState(Endpoint endpoint) {
        Util.checkNotNull(endpoint, "endpoint must be specified.", new Object[0]);
        Util.checkNotBlank(endpoint.service_name, "Service name must be specified.", new Object[0]);
        this.endpoint = endpoint;
    }

    @Override
    public ServerSpan getCurrentServerSpan() {
        return currentServerSpan.get();
    }

    @Override
    public void setCurrentServerSpan(ServerSpan span) {
        if (span == null) {
            currentServerSpan.remove();
        } else {
            currentServerSpan.set(span);
        }
    }

    @Override
    public Endpoint endpoint() {
        return this.endpoint;
    }

    @Override
    public Span getCurrentClientSpan() {
        return currentClientSpan.get();
    }

    @Override
    public void setCurrentClientSpan(Span span) {
        currentClientSpan.set(span);
    }

    @Override
    public Boolean sample() {
        return currentServerSpan.get().getSample();
    }

    @Override
    public Span getCurrentLocalSpan() {
        return currentLocalSpan.get();
    }

    @Override
    public void setCurrentLocalSpan(Span span) {
        if (span == null) {
            currentLocalSpan.remove();
        } else {
            currentLocalSpan.set(span);
        }
    }
}

