/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.sql;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.sql.ResultSet;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class ResultSetConverter {
    public static void fromJson(JsonObject json, ResultSet obj) {
        ArrayList<String> list;
        if (json.getValue("columnNames") instanceof JsonArray) {
            list = new ArrayList<String>();
            json.getJsonArray("columnNames").forEach(item -> {
                if (item instanceof String) {
                    list.add((String)item);
                }
            });
            obj.setColumnNames(list);
        }
        if (json.getValue("output") instanceof JsonArray) {
            obj.setOutput(((JsonArray)json.getValue("output")).copy());
        }
        if (json.getValue("results") instanceof JsonArray) {
            list = new ArrayList();
            json.getJsonArray("results").forEach(item -> {
                if (item instanceof JsonArray) {
                    list.add((String)((JsonArray)item).copy());
                }
            });
            obj.setResults(list);
        }
        if (json.getValue("rows") instanceof JsonArray) {
            // empty if block
        }
    }

    public static void toJson(ResultSet obj, JsonObject json) {
        if (obj.getColumnNames() != null) {
            json.put("columnNames", new JsonArray(obj.getColumnNames().stream().map(item -> item).collect(Collectors.toList())));
        }
        json.put("numColumns", Integer.valueOf(obj.getNumColumns()));
        json.put("numRows", Integer.valueOf(obj.getNumRows()));
        if (obj.getOutput() != null) {
            json.put("output", obj.getOutput());
        }
        if (obj.getResults() != null) {
            json.put("results", new JsonArray(obj.getResults().stream().map(item -> item).collect(Collectors.toList())));
        }
        if (obj.getRows() != null) {
            json.put("rows", new JsonArray(obj.getRows().stream().map(item -> item).collect(Collectors.toList())));
        }
    }
}

