/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rxjava.core.http.HttpConnection;
import io.vertx.rxjava.core.http.HttpServerRequest;
import io.vertx.rxjava.core.http.HttpServerRequestStream;
import io.vertx.rxjava.core.http.ServerWebSocket;
import io.vertx.rxjava.core.http.ServerWebSocketStream;
import io.vertx.rxjava.core.metrics.Measured;
import rx.Observable;

public class HttpServer
implements Measured {
    final io.vertx.core.http.HttpServer delegate;
    private HttpServerRequestStream cached_0;
    private ServerWebSocketStream cached_1;

    public HttpServer(io.vertx.core.http.HttpServer delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public HttpServerRequestStream requestStream() {
        HttpServerRequestStream ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = HttpServerRequestStream.newInstance(this.delegate.requestStream());
        return ret;
    }

    public HttpServer requestHandler(final Handler<HttpServerRequest> handler) {
        this.delegate.requestHandler((Handler)new Handler<io.vertx.core.http.HttpServerRequest>(){

            public void handle(io.vertx.core.http.HttpServerRequest event) {
                handler.handle((Object)HttpServerRequest.newInstance(event));
            }
        });
        return this;
    }

    public HttpServer connectionHandler(final Handler<HttpConnection> handler) {
        this.delegate.connectionHandler((Handler)new Handler<io.vertx.core.http.HttpConnection>(){

            public void handle(io.vertx.core.http.HttpConnection event) {
                handler.handle((Object)HttpConnection.newInstance(event));
            }
        });
        return this;
    }

    public ServerWebSocketStream websocketStream() {
        ServerWebSocketStream ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = ServerWebSocketStream.newInstance(this.delegate.websocketStream());
        return ret;
    }

    public HttpServer websocketHandler(final Handler<ServerWebSocket> handler) {
        this.delegate.websocketHandler((Handler)new Handler<io.vertx.core.http.ServerWebSocket>(){

            public void handle(io.vertx.core.http.ServerWebSocket event) {
                handler.handle((Object)ServerWebSocket.newInstance(event));
            }
        });
        return this;
    }

    public HttpServer listen() {
        this.delegate.listen();
        return this;
    }

    public HttpServer listen(int port, String host) {
        this.delegate.listen(port, host);
        return this;
    }

    public HttpServer listen(int port, String host, final Handler<AsyncResult<HttpServer>> listenHandler) {
        this.delegate.listen(port, host, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpServer>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Observable<HttpServer> listenObservable(int port, String host) {
        ObservableFuture<HttpServer> listenHandler = RxHelper.observableFuture();
        this.listen(port, host, listenHandler.toHandler());
        return listenHandler;
    }

    public HttpServer listen(int port) {
        this.delegate.listen(port);
        return this;
    }

    public HttpServer listen(int port, final Handler<AsyncResult<HttpServer>> listenHandler) {
        this.delegate.listen(port, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpServer>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Observable<HttpServer> listenObservable(int port) {
        ObservableFuture<HttpServer> listenHandler = RxHelper.observableFuture();
        this.listen(port, listenHandler.toHandler());
        return listenHandler;
    }

    public HttpServer listen(final Handler<AsyncResult<HttpServer>> listenHandler) {
        this.delegate.listen((Handler)new Handler<AsyncResult<io.vertx.core.http.HttpServer>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Observable<HttpServer> listenObservable() {
        ObservableFuture<HttpServer> listenHandler = RxHelper.observableFuture();
        this.listen(listenHandler.toHandler());
        return listenHandler;
    }

    public void close() {
        this.delegate.close();
    }

    public void close(Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.close(completionHandler);
    }

    public Observable<Void> closeObservable() {
        ObservableFuture<Void> completionHandler = RxHelper.observableFuture();
        this.close(completionHandler.toHandler());
        return completionHandler;
    }

    public int actualPort() {
        int ret = this.delegate.actualPort();
        return ret;
    }

    public static HttpServer newInstance(io.vertx.core.http.HttpServer arg) {
        return arg != null ? new HttpServer(arg) : null;
    }
}

