/*
 * Decompiled with CFR 0.152.
 */
package examples;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.FileSystem;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.ObservableHandler;
import io.vertx.rx.java.RxHelper;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.plugins.RxJavaPlugins;
import rx.plugins.RxJavaSchedulersHook;

public class NativeExamples {
    public void readStream(Vertx vertx) {
        FileSystem fileSystem = vertx.fileSystem();
        fileSystem.open("/data.txt", new OpenOptions(), result -> {
            AsyncFile file = (AsyncFile)result.result();
            Observable observable = RxHelper.toObservable(file);
            observable.forEach(data -> System.out.println("Read data: " + data.toString("UTF-8")));
        });
    }

    public void observableHandler(Vertx vertx) {
        ObservableHandler observable = RxHelper.observableHandler();
        observable.subscribe(id -> {});
        vertx.setTimer(1000L, observable.toHandler());
    }

    public void observableFuture(Vertx vertx) {
        ObservableFuture observable = RxHelper.observableFuture();
        observable.subscribe(server -> {}, failure -> {});
        vertx.createHttpServer(new HttpServerOptions().setPort(1234).setHost("localhost")).listen(observable.toHandler());
    }

    public void observableToHandler() {
        Observer<HttpServer> observer = new Observer<HttpServer>(){

            public void onNext(HttpServer o) {
            }

            public void onError(Throwable e) {
            }

            public void onCompleted() {
            }
        };
        Handler<AsyncResult<HttpServer>> handler = RxHelper.toFuture(observer);
    }

    public void actionsToHandler() {
        Action1 onNext = httpServer -> {};
        Action1 onError = httpServer -> {};
        Action0 onComplete = () -> {};
        Handler handler1 = RxHelper.toFuture(onNext);
        Handler handler2 = RxHelper.toFuture(onNext, (Action1<Throwable>)onError);
        Handler handler3 = RxHelper.toFuture(onNext, (Action1<Throwable>)onError, onComplete);
    }

    public void scheduler(Vertx vertx) {
        Scheduler scheduler = RxHelper.scheduler(vertx);
        Observable timer = Observable.timer((long)100L, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)scheduler);
    }

    public void blockingScheduler(Vertx vertx, Observable<Integer> blockingObservable) {
        Scheduler scheduler = RxHelper.blockingScheduler(vertx);
        Observable obs = blockingObservable.observeOn(scheduler);
    }

    public void schedulerHook(Vertx vertx) {
        RxJavaSchedulersHook hook = RxHelper.schedulerHook(vertx);
        RxJavaPlugins.getInstance().registerSchedulersHook(hook);
    }

    public void unmarshaller(FileSystem fileSystem) {
        fileSystem.open("/data.txt", new OpenOptions(), result -> {
            AsyncFile file = (AsyncFile)result.result();
            Observable observable = RxHelper.toObservable(file);
            observable.lift(RxHelper.unmarshaller(MyPojo.class)).subscribe(mypojo -> {});
        });
    }

    private class MyPojo {
        private MyPojo() {
        }
    }
}

