/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.streams;

import java.util.Map;
import rx.Observable;
import io.vertx.core.Handler;

/**
 *
 * Represents a stream of data that can be written to.
 * <p>
 * Any class that implements this interface can be used by a {@link io.vertx.rxjava.core.streams.Pump} to pump data from a <code>ReadStream</code>
 * to it.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.streams.WriteStream original} non RX-ified interface using Vert.x codegen.
 */

public interface WriteStream<T> extends StreamBase {

  Object getDelegate();

  /**
   * Set an exception handler on the write stream.
   * @param handler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  public WriteStream<T> exceptionHandler(Handler<Throwable> handler);

  /**
   * Write some data to the stream. The data is put on an internal write queue, and the write actually happens
   * asynchronously. To avoid running out of memory by putting too much on the write queue,
   * check the {@link io.vertx.rxjava.core.streams.WriteStream#writeQueueFull} method before writing. This is done automatically if using a {@link io.vertx.rxjava.core.streams.Pump}.
   * @param data the data to write
   * @return a reference to this, so the API can be used fluently
   */
  public WriteStream<T> write(T data);

  /**
   * Ends the stream.
   * <p>
   * Once the stream has ended, it cannot be used any more.
   */
  public void end();

  /**
   * Same as {@link io.vertx.rxjava.core.streams.WriteStream#end} but writes some data to the stream before ending.
   * @param t 
   */
  public void end(T t);

  /**
   * Set the maximum size of the write queue to <code>maxSize</code>. You will still be able to write to the stream even
   * if there is more than <code>maxSize</code> items in the write queue. This is used as an indicator by classes such as
   * <code>Pump</code> to provide flow control.
   * <p/>
   * The value is defined by the implementation of the stream, e.g in bytes for a
   * {@link io.vertx.rxjava.core.net.NetSocket}, the number of {@link io.vertx.rxjava.core.eventbus.Message} for a
   * {@link io.vertx.rxjava.core.eventbus.MessageProducer}, etc...
   * @param maxSize the max size of the write stream
   * @return a reference to this, so the API can be used fluently
   */
  public WriteStream<T> setWriteQueueMaxSize(int maxSize);

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.rxjava.core.streams.WriteStream#setWriteQueueMaxSize}
   * @return true if write queue is full
   */
  public boolean writeQueueFull();

  /**
   * Set a drain handler on the stream. If the write queue is full, then the handler will be called when the write
   * queue is ready to accept buffers again. See {@link io.vertx.rxjava.core.streams.Pump} for an example of this being used.
   * <p/>
   * The stream implementation defines when the drain handler, for example it could be when the queue size has been
   * reduced to <code>maxSize / 2</code>.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public WriteStream<T> drainHandler(Handler<Void> handler);


  public static <T> WriteStream newInstance(io.vertx.core.streams.WriteStream arg) {
    return arg != null ? new WriteStreamImpl<T> (arg) : null;
  }
}

class WriteStreamImpl<T> implements WriteStream<T> {
  final io.vertx.core.streams.WriteStream delegate;

  public WriteStreamImpl(io.vertx.core.streams.WriteStream delegate) {
    this.delegate = delegate;
  }

  public Object getDelegate() {
    return delegate;
  }

  /**
   * Set an exception handler on the write stream.
   * @param handler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  public WriteStream<T> exceptionHandler(Handler<Throwable> handler) { 
    ((io.vertx.core.streams.WriteStream) delegate).exceptionHandler(handler);
    return this;
  }

  /**
   * Write some data to the stream. The data is put on an internal write queue, and the write actually happens
   * asynchronously. To avoid running out of memory by putting too much on the write queue,
   * check the {@link io.vertx.rxjava.core.streams.WriteStream#writeQueueFull} method before writing. This is done automatically if using a {@link io.vertx.rxjava.core.streams.Pump}.
   * @param data the data to write
   * @return a reference to this, so the API can be used fluently
   */
  public WriteStream<T> write(T data) { 
    delegate.write(data);
    return this;
  }

  /**
   * Ends the stream.
   * <p>
   * Once the stream has ended, it cannot be used any more.
   */
  public void end() { 
    delegate.end();
  }

  /**
   * Same as {@link io.vertx.rxjava.core.streams.WriteStream#end} but writes some data to the stream before ending.
   * @param t 
   */
  public void end(T t) { 
    delegate.end(t);
  }

  /**
   * Set the maximum size of the write queue to <code>maxSize</code>. You will still be able to write to the stream even
   * if there is more than <code>maxSize</code> items in the write queue. This is used as an indicator by classes such as
   * <code>Pump</code> to provide flow control.
   * <p/>
   * The value is defined by the implementation of the stream, e.g in bytes for a
   * {@link io.vertx.rxjava.core.net.NetSocket}, the number of {@link io.vertx.rxjava.core.eventbus.Message} for a
   * {@link io.vertx.rxjava.core.eventbus.MessageProducer}, etc...
   * @param maxSize the max size of the write stream
   * @return a reference to this, so the API can be used fluently
   */
  public WriteStream<T> setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.rxjava.core.streams.WriteStream#setWriteQueueMaxSize}
   * @return true if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * Set a drain handler on the stream. If the write queue is full, then the handler will be called when the write
   * queue is ready to accept buffers again. See {@link io.vertx.rxjava.core.streams.Pump} for an example of this being used.
   * <p/>
   * The stream implementation defines when the drain handler, for example it could be when the queue size has been
   * reduced to <code>maxSize / 2</code>.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public WriteStream<T> drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

}
