/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.file;

import java.util.Map;
import rx.Observable;

/**
 * Represents properties of the file system.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.file.FileSystemProps original} non RX-ified interface using Vert.x codegen.
 */

public class FileSystemProps {

  final io.vertx.core.file.FileSystemProps delegate;

  public FileSystemProps(io.vertx.core.file.FileSystemProps delegate) {
    this.delegate = delegate;
  }

  public Object getDelegate() {
    return delegate;
  }

  /**
   * @return The total space on the file system, in bytes
   */
  public long totalSpace() { 
    long ret = delegate.totalSpace();
    return ret;
  }

  /**
   * @return The total un-allocated space on the file system, in bytes
   */
  public long unallocatedSpace() { 
    long ret = delegate.unallocatedSpace();
    return ret;
  }

  /**
   * @return The total usable space on the file system, in bytes
   */
  public long usableSpace() { 
    long ret = delegate.usableSpace();
    return ret;
  }


  public static FileSystemProps newInstance(io.vertx.core.file.FileSystemProps arg) {
    return arg != null ? new FileSystemProps(arg) : null;
  }
}
