/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.datagram;

import java.util.Map;
import rx.Observable;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.core.streams.WriteStream;
import io.vertx.core.Handler;

/**
 * A {@link io.vertx.rxjava.core.streams.WriteStream} for sending packets to a {@link io.vertx.rxjava.core.net.SocketAddress}.
 * The stream  is called when the write fails.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.datagram.PacketWritestream original} non RX-ified interface using Vert.x codegen.
 */

public class PacketWritestream implements WriteStream<Buffer> {

  final io.vertx.core.datagram.PacketWritestream delegate;

  public PacketWritestream(io.vertx.core.datagram.PacketWritestream delegate) {
    this.delegate = delegate;
  }

  public Object getDelegate() {
    return delegate;
  }

  /**
   * Ends the stream.
   * <p>
   * Once the stream has ended, it cannot be used any more.
   */
  public void end() { 
    delegate.end();
  }

  /**
   * Same as {@link io.vertx.rxjava.core.streams.WriteStream#end} but writes some data to the stream before ending.
   * @param t 
   */
  public void end(Buffer t) { 
    delegate.end((io.vertx.core.buffer.Buffer)t.getDelegate());
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.rxjava.core.datagram.PacketWritestream#setWriteQueueMaxSize}
   * @return true if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  public PacketWritestream exceptionHandler(Handler<Throwable> handler) { 
    ((io.vertx.core.datagram.PacketWritestream) delegate).exceptionHandler(handler);
    return this;
  }

  public PacketWritestream write(Buffer data) { 
    ((io.vertx.core.datagram.PacketWritestream) delegate).write((io.vertx.core.buffer.Buffer)data.getDelegate());
    return this;
  }

  public PacketWritestream setWriteQueueMaxSize(int maxSize) { 
    ((io.vertx.core.datagram.PacketWritestream) delegate).setWriteQueueMaxSize(maxSize);
    return this;
  }

  public PacketWritestream drainHandler(Handler<Void> handler) { 
    ((io.vertx.core.datagram.PacketWritestream) delegate).drainHandler(handler);
    return this;
  }


  public static PacketWritestream newInstance(io.vertx.core.datagram.PacketWritestream arg) {
    return arg != null ? new PacketWritestream(arg) : null;
  }
}
