/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.redis;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.RedisOptions;
import io.vertx.redis.op.AggregateOptions;
import io.vertx.redis.op.BitOperation;
import io.vertx.redis.op.FailoverOptions;
import io.vertx.redis.op.GeoMember;
import io.vertx.redis.op.GeoRadiusOptions;
import io.vertx.redis.op.GeoUnit;
import io.vertx.redis.op.InsertOptions;
import io.vertx.redis.op.KillFilter;
import io.vertx.redis.op.LimitOptions;
import io.vertx.redis.op.MigrateOptions;
import io.vertx.redis.op.ObjectCmd;
import io.vertx.redis.op.RangeLimitOptions;
import io.vertx.redis.op.RangeOptions;
import io.vertx.redis.op.ResetOptions;
import io.vertx.redis.op.ScanOptions;
import io.vertx.redis.op.SetOptions;
import io.vertx.redis.op.SlotCmd;
import io.vertx.redis.op.SortOptions;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rxjava.redis.RedisTransaction;
import java.util.List;
import java.util.Map;
import rx.Observable;

public class RedisClient {
    final io.vertx.redis.RedisClient delegate;

    public RedisClient(io.vertx.redis.RedisClient delegate) {
        this.delegate = delegate;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public static RedisClient create(io.vertx.rxjava.core.Vertx vertx) {
        RedisClient ret = RedisClient.newInstance(io.vertx.redis.RedisClient.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static RedisClient create(io.vertx.rxjava.core.Vertx vertx, RedisOptions config) {
        RedisClient ret = RedisClient.newInstance(io.vertx.redis.RedisClient.create((Vertx)vertx.getDelegate(), config));
        return ret;
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public Observable<Void> closeObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.close((Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public RedisClient append(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.append(key, value, handler);
        return this;
    }

    public Observable<Long> appendObservable(String key, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.append(key, value, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient auth(String password, Handler<AsyncResult<String>> handler) {
        this.delegate.auth(password, handler);
        return this;
    }

    public Observable<String> authObservable(String password) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.auth(password, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient bgrewriteaof(Handler<AsyncResult<String>> handler) {
        this.delegate.bgrewriteaof(handler);
        return this;
    }

    public Observable<String> bgrewriteaofObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.bgrewriteaof((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient bgsave(Handler<AsyncResult<String>> handler) {
        this.delegate.bgsave(handler);
        return this;
    }

    public Observable<String> bgsaveObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.bgsave((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient bitcount(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.bitcount(key, handler);
        return this;
    }

    public Observable<Long> bitcountObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.bitcount(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient bitcountRange(String key, long start, long end, Handler<AsyncResult<Long>> handler) {
        this.delegate.bitcountRange(key, start, end, handler);
        return this;
    }

    public Observable<Long> bitcountRangeObservable(String key, long start, long end) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.bitcountRange(key, start, end, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient bitop(BitOperation operation, String destkey, List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.bitop(operation, destkey, keys, handler);
        return this;
    }

    public Observable<Long> bitopObservable(BitOperation operation, String destkey, List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.bitop(operation, destkey, keys, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient bitpos(String key, int bit, Handler<AsyncResult<Long>> handler) {
        this.delegate.bitpos(key, bit, handler);
        return this;
    }

    public Observable<Long> bitposObservable(String key, int bit) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.bitpos(key, bit, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient bitposFrom(String key, int bit, int start, Handler<AsyncResult<Long>> handler) {
        this.delegate.bitposFrom(key, bit, start, handler);
        return this;
    }

    public Observable<Long> bitposFromObservable(String key, int bit, int start) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.bitposFrom(key, bit, start, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient bitposRange(String key, int bit, int start, int stop, Handler<AsyncResult<Long>> handler) {
        this.delegate.bitposRange(key, bit, start, stop, handler);
        return this;
    }

    public Observable<Long> bitposRangeObservable(String key, int bit, int start, int stop) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.bitposRange(key, bit, start, stop, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient blpop(String key, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.blpop(key, seconds, handler);
        return this;
    }

    public Observable<JsonArray> blpopObservable(String key, int seconds) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.blpop(key, seconds, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient blpopMany(List<String> keys, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.blpopMany(keys, seconds, handler);
        return this;
    }

    public Observable<JsonArray> blpopManyObservable(List<String> keys, int seconds) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.blpopMany(keys, seconds, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient brpop(String key, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.brpop(key, seconds, handler);
        return this;
    }

    public Observable<JsonArray> brpopObservable(String key, int seconds) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.brpop(key, seconds, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient brpopMany(List<String> keys, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.brpopMany(keys, seconds, handler);
        return this;
    }

    public Observable<JsonArray> brpopManyObservable(List<String> keys, int seconds) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.brpopMany(keys, seconds, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient brpoplpush(String key, String destkey, int seconds, Handler<AsyncResult<String>> handler) {
        this.delegate.brpoplpush(key, destkey, seconds, handler);
        return this;
    }

    public Observable<String> brpoplpushObservable(String key, String destkey, int seconds) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.brpoplpush(key, destkey, seconds, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient clientKill(KillFilter filter, Handler<AsyncResult<Long>> handler) {
        this.delegate.clientKill(filter, handler);
        return this;
    }

    public Observable<Long> clientKillObservable(KillFilter filter) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clientKill(filter, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient clientList(Handler<AsyncResult<String>> handler) {
        this.delegate.clientList(handler);
        return this;
    }

    public Observable<String> clientListObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clientList((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient clientGetname(Handler<AsyncResult<String>> handler) {
        this.delegate.clientGetname(handler);
        return this;
    }

    public Observable<String> clientGetnameObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clientGetname((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient clientPause(long millis, Handler<AsyncResult<String>> handler) {
        this.delegate.clientPause(millis, handler);
        return this;
    }

    public Observable<String> clientPauseObservable(long millis) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clientPause(millis, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient clientSetname(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.clientSetname(name, handler);
        return this;
    }

    public Observable<String> clientSetnameObservable(String name) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clientSetname(name, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient clusterAddslots(List<Long> slots, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterAddslots(slots, handler);
        return this;
    }

    public Observable<Void> clusterAddslotsObservable(List<Long> slots) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterAddslots(slots, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public RedisClient clusterCountFailureReports(String nodeId, Handler<AsyncResult<Long>> handler) {
        this.delegate.clusterCountFailureReports(nodeId, handler);
        return this;
    }

    public Observable<Long> clusterCountFailureReportsObservable(String nodeId) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterCountFailureReports(nodeId, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient clusterCountkeysinslot(long slot, Handler<AsyncResult<Long>> handler) {
        this.delegate.clusterCountkeysinslot(slot, handler);
        return this;
    }

    public Observable<Long> clusterCountkeysinslotObservable(long slot) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterCountkeysinslot(slot, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient clusterDelslots(long slot, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterDelslots(slot, handler);
        return this;
    }

    public Observable<Void> clusterDelslotsObservable(long slot) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterDelslots(slot, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public RedisClient clusterDelslotsMany(List<Long> slots, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterDelslotsMany(slots, handler);
        return this;
    }

    public Observable<Void> clusterDelslotsManyObservable(List<Long> slots) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterDelslotsMany(slots, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public RedisClient clusterFailover(Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterFailover(handler);
        return this;
    }

    public Observable<Void> clusterFailoverObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterFailover((Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public RedisClient clusterFailOverWithOptions(FailoverOptions options, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterFailOverWithOptions(options, handler);
        return this;
    }

    public Observable<Void> clusterFailOverWithOptionsObservable(FailoverOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterFailOverWithOptions(options, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public RedisClient clusterForget(String nodeId, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterForget(nodeId, handler);
        return this;
    }

    public Observable<Void> clusterForgetObservable(String nodeId) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterForget(nodeId, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public RedisClient clusterGetkeysinslot(long slot, long count, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.clusterGetkeysinslot(slot, count, handler);
        return this;
    }

    public Observable<JsonArray> clusterGetkeysinslotObservable(long slot, long count) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterGetkeysinslot(slot, count, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient clusterInfo(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.clusterInfo(handler);
        return this;
    }

    public Observable<JsonArray> clusterInfoObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterInfo((Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient clusterKeyslot(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.clusterKeyslot(key, handler);
        return this;
    }

    public Observable<Long> clusterKeyslotObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterKeyslot(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient clusterMeet(String ip, long port, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterMeet(ip, port, handler);
        return this;
    }

    public Observable<Void> clusterMeetObservable(String ip, long port) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterMeet(ip, port, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public RedisClient clusterNodes(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.clusterNodes(handler);
        return this;
    }

    public Observable<JsonArray> clusterNodesObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterNodes((Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient clusterReplicate(String nodeId, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterReplicate(nodeId, handler);
        return this;
    }

    public Observable<Void> clusterReplicateObservable(String nodeId) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterReplicate(nodeId, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public RedisClient clusterReset(Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterReset(handler);
        return this;
    }

    public Observable<Void> clusterResetObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterReset((Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public RedisClient clusterResetWithOptions(ResetOptions options, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterResetWithOptions(options, handler);
        return this;
    }

    public Observable<Void> clusterResetWithOptionsObservable(ResetOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterResetWithOptions(options, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public RedisClient clusterSaveconfig(Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterSaveconfig(handler);
        return this;
    }

    public Observable<Void> clusterSaveconfigObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterSaveconfig((Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public RedisClient clusterSetConfigEpoch(long epoch, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterSetConfigEpoch(epoch, handler);
        return this;
    }

    public Observable<Void> clusterSetConfigEpochObservable(long epoch) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterSetConfigEpoch(epoch, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public RedisClient clusterSetslot(long slot, SlotCmd subcommand, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterSetslot(slot, subcommand, handler);
        return this;
    }

    public Observable<Void> clusterSetslotObservable(long slot, SlotCmd subcommand) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterSetslot(slot, subcommand, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public RedisClient clusterSetslotWithNode(long slot, SlotCmd subcommand, String nodeId, Handler<AsyncResult<Void>> handler) {
        this.delegate.clusterSetslotWithNode(slot, subcommand, nodeId, handler);
        return this;
    }

    public Observable<Void> clusterSetslotWithNodeObservable(long slot, SlotCmd subcommand, String nodeId) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterSetslotWithNode(slot, subcommand, nodeId, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public RedisClient clusterSlaves(String nodeId, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.clusterSlaves(nodeId, handler);
        return this;
    }

    public Observable<JsonArray> clusterSlavesObservable(String nodeId) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterSlaves(nodeId, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient clusterSlots(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.clusterSlots(handler);
        return this;
    }

    public Observable<JsonArray> clusterSlotsObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.clusterSlots((Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient command(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.command(handler);
        return this;
    }

    public Observable<JsonArray> commandObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.command((Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient commandCount(Handler<AsyncResult<Long>> handler) {
        this.delegate.commandCount(handler);
        return this;
    }

    public Observable<Long> commandCountObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.commandCount((Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient commandGetkeys(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.commandGetkeys(handler);
        return this;
    }

    public Observable<JsonArray> commandGetkeysObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.commandGetkeys((Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient commandInfo(List<String> commands, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.commandInfo(commands, handler);
        return this;
    }

    public Observable<JsonArray> commandInfoObservable(List<String> commands) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.commandInfo(commands, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient configGet(String parameter, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.configGet(parameter, handler);
        return this;
    }

    public Observable<JsonArray> configGetObservable(String parameter) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.configGet(parameter, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient configRewrite(Handler<AsyncResult<String>> handler) {
        this.delegate.configRewrite(handler);
        return this;
    }

    public Observable<String> configRewriteObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.configRewrite((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient configSet(String parameter, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.configSet(parameter, value, handler);
        return this;
    }

    public Observable<String> configSetObservable(String parameter, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.configSet(parameter, value, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient configResetstat(Handler<AsyncResult<String>> handler) {
        this.delegate.configResetstat(handler);
        return this;
    }

    public Observable<String> configResetstatObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.configResetstat((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient dbsize(Handler<AsyncResult<Long>> handler) {
        this.delegate.dbsize(handler);
        return this;
    }

    public Observable<Long> dbsizeObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.dbsize((Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient debugObject(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.debugObject(key, handler);
        return this;
    }

    public Observable<String> debugObjectObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.debugObject(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient debugSegfault(Handler<AsyncResult<String>> handler) {
        this.delegate.debugSegfault(handler);
        return this;
    }

    public Observable<String> debugSegfaultObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.debugSegfault((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient decr(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.decr(key, handler);
        return this;
    }

    public Observable<Long> decrObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.decr(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient decrby(String key, long decrement, Handler<AsyncResult<Long>> handler) {
        this.delegate.decrby(key, decrement, handler);
        return this;
    }

    public Observable<Long> decrbyObservable(String key, long decrement) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.decrby(key, decrement, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient del(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.del(key, handler);
        return this;
    }

    public Observable<Long> delObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.del(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient delMany(List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.delMany(keys, handler);
        return this;
    }

    public Observable<Long> delManyObservable(List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.delMany(keys, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient dump(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.dump(key, handler);
        return this;
    }

    public Observable<String> dumpObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.dump(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient echo(String message, Handler<AsyncResult<String>> handler) {
        this.delegate.echo(message, handler);
        return this;
    }

    public Observable<String> echoObservable(String message) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.echo(message, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient eval(String script, List<String> keys, List<String> args, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.eval(script, keys, args, handler);
        return this;
    }

    public Observable<JsonArray> evalObservable(String script, List<String> keys, List<String> args) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.eval(script, keys, args, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient evalsha(String sha1, List<String> keys, List<String> values, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.evalsha(sha1, keys, values, handler);
        return this;
    }

    public Observable<JsonArray> evalshaObservable(String sha1, List<String> keys, List<String> values) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.evalsha(sha1, keys, values, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient exists(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.exists(key, handler);
        return this;
    }

    public Observable<Long> existsObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.exists(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient expire(String key, int seconds, Handler<AsyncResult<Long>> handler) {
        this.delegate.expire(key, seconds, handler);
        return this;
    }

    public Observable<Long> expireObservable(String key, int seconds) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.expire(key, seconds, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient expireat(String key, long seconds, Handler<AsyncResult<Long>> handler) {
        this.delegate.expireat(key, seconds, handler);
        return this;
    }

    public Observable<Long> expireatObservable(String key, long seconds) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.expireat(key, seconds, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient flushall(Handler<AsyncResult<String>> handler) {
        this.delegate.flushall(handler);
        return this;
    }

    public Observable<String> flushallObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.flushall((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient flushdb(Handler<AsyncResult<String>> handler) {
        this.delegate.flushdb(handler);
        return this;
    }

    public Observable<String> flushdbObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.flushdb((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient get(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.get(key, handler);
        return this;
    }

    public Observable<String> getObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.get(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient getBinary(String key, final Handler<AsyncResult<io.vertx.rxjava.core.buffer.Buffer>> handler) {
        this.delegate.getBinary(key, new Handler<AsyncResult<Buffer>>(){

            public void handle(AsyncResult<Buffer> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)io.vertx.rxjava.core.buffer.Buffer.newInstance((Buffer)((Buffer)ar.result()))));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Observable<io.vertx.rxjava.core.buffer.Buffer> getBinaryObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.getBinary(key, (Handler<AsyncResult<io.vertx.rxjava.core.buffer.Buffer>>)handler.toHandler());
        return handler;
    }

    public RedisClient getbit(String key, long offset, Handler<AsyncResult<Long>> handler) {
        this.delegate.getbit(key, offset, handler);
        return this;
    }

    public Observable<Long> getbitObservable(String key, long offset) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.getbit(key, offset, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient getrange(String key, long start, long end, Handler<AsyncResult<String>> handler) {
        this.delegate.getrange(key, start, end, handler);
        return this;
    }

    public Observable<String> getrangeObservable(String key, long start, long end) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.getrange(key, start, end, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient getset(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.getset(key, value, handler);
        return this;
    }

    public Observable<String> getsetObservable(String key, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.getset(key, value, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient hdel(String key, String field, Handler<AsyncResult<Long>> handler) {
        this.delegate.hdel(key, field, handler);
        return this;
    }

    public Observable<Long> hdelObservable(String key, String field) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hdel(key, field, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient hdelMany(String key, List<String> fields, Handler<AsyncResult<Long>> handler) {
        this.delegate.hdelMany(key, fields, handler);
        return this;
    }

    public Observable<Long> hdelManyObservable(String key, List<String> fields) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hdelMany(key, fields, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient hexists(String key, String field, Handler<AsyncResult<Long>> handler) {
        this.delegate.hexists(key, field, handler);
        return this;
    }

    public Observable<Long> hexistsObservable(String key, String field) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hexists(key, field, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient hget(String key, String field, Handler<AsyncResult<String>> handler) {
        this.delegate.hget(key, field, handler);
        return this;
    }

    public Observable<String> hgetObservable(String key, String field) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hget(key, field, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient hgetall(String key, Handler<AsyncResult<JsonObject>> handler) {
        this.delegate.hgetall(key, handler);
        return this;
    }

    public Observable<JsonObject> hgetallObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hgetall(key, (Handler<AsyncResult<JsonObject>>)handler.toHandler());
        return handler;
    }

    public RedisClient hincrby(String key, String field, long increment, Handler<AsyncResult<Long>> handler) {
        this.delegate.hincrby(key, field, increment, handler);
        return this;
    }

    public Observable<Long> hincrbyObservable(String key, String field, long increment) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hincrby(key, field, increment, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient hincrbyfloat(String key, String field, double increment, Handler<AsyncResult<String>> handler) {
        this.delegate.hincrbyfloat(key, field, increment, handler);
        return this;
    }

    public Observable<String> hincrbyfloatObservable(String key, String field, double increment) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hincrbyfloat(key, field, increment, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient hkeys(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.hkeys(key, handler);
        return this;
    }

    public Observable<JsonArray> hkeysObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hkeys(key, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient hlen(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.hlen(key, handler);
        return this;
    }

    public Observable<Long> hlenObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hlen(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient hmget(String key, List<String> fields, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.hmget(key, fields, handler);
        return this;
    }

    public Observable<JsonArray> hmgetObservable(String key, List<String> fields) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hmget(key, fields, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient hmset(String key, JsonObject values, Handler<AsyncResult<String>> handler) {
        this.delegate.hmset(key, values, handler);
        return this;
    }

    public Observable<String> hmsetObservable(String key, JsonObject values) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hmset(key, values, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient hset(String key, String field, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.hset(key, field, value, handler);
        return this;
    }

    public Observable<Long> hsetObservable(String key, String field, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hset(key, field, value, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient hsetnx(String key, String field, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.hsetnx(key, field, value, handler);
        return this;
    }

    public Observable<Long> hsetnxObservable(String key, String field, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hsetnx(key, field, value, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient hvals(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.hvals(key, handler);
        return this;
    }

    public Observable<JsonArray> hvalsObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hvals(key, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient incr(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.incr(key, handler);
        return this;
    }

    public Observable<Long> incrObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.incr(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient incrby(String key, long increment, Handler<AsyncResult<Long>> handler) {
        this.delegate.incrby(key, increment, handler);
        return this;
    }

    public Observable<Long> incrbyObservable(String key, long increment) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.incrby(key, increment, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient incrbyfloat(String key, double increment, Handler<AsyncResult<String>> handler) {
        this.delegate.incrbyfloat(key, increment, handler);
        return this;
    }

    public Observable<String> incrbyfloatObservable(String key, double increment) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.incrbyfloat(key, increment, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient info(Handler<AsyncResult<JsonObject>> handler) {
        this.delegate.info(handler);
        return this;
    }

    public Observable<JsonObject> infoObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.info((Handler<AsyncResult<JsonObject>>)handler.toHandler());
        return handler;
    }

    public RedisClient infoSection(String section, Handler<AsyncResult<JsonObject>> handler) {
        this.delegate.infoSection(section, handler);
        return this;
    }

    public Observable<JsonObject> infoSectionObservable(String section) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.infoSection(section, (Handler<AsyncResult<JsonObject>>)handler.toHandler());
        return handler;
    }

    public RedisClient keys(String pattern, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.keys(pattern, handler);
        return this;
    }

    public Observable<JsonArray> keysObservable(String pattern) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.keys(pattern, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient lastsave(Handler<AsyncResult<Long>> handler) {
        this.delegate.lastsave(handler);
        return this;
    }

    public Observable<Long> lastsaveObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lastsave((Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient lindex(String key, int index, Handler<AsyncResult<String>> handler) {
        this.delegate.lindex(key, index, handler);
        return this;
    }

    public Observable<String> lindexObservable(String key, int index) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lindex(key, index, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient linsert(String key, InsertOptions option, String pivot, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.linsert(key, option, pivot, value, handler);
        return this;
    }

    public Observable<Long> linsertObservable(String key, InsertOptions option, String pivot, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.linsert(key, option, pivot, value, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient llen(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.llen(key, handler);
        return this;
    }

    public Observable<Long> llenObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.llen(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient lpop(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.lpop(key, handler);
        return this;
    }

    public Observable<String> lpopObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lpop(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient lpushMany(String key, List<String> values, Handler<AsyncResult<Long>> handler) {
        this.delegate.lpushMany(key, values, handler);
        return this;
    }

    public Observable<Long> lpushManyObservable(String key, List<String> values) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lpushMany(key, values, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient lpush(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.lpush(key, value, handler);
        return this;
    }

    public Observable<Long> lpushObservable(String key, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lpush(key, value, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient lpushx(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.lpushx(key, value, handler);
        return this;
    }

    public Observable<Long> lpushxObservable(String key, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lpushx(key, value, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient lrange(String key, long from, long to, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.lrange(key, from, to, handler);
        return this;
    }

    public Observable<JsonArray> lrangeObservable(String key, long from, long to) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lrange(key, from, to, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient lrem(String key, long count, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.lrem(key, count, value, handler);
        return this;
    }

    public Observable<Long> lremObservable(String key, long count, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lrem(key, count, value, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient lset(String key, long index, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.lset(key, index, value, handler);
        return this;
    }

    public Observable<String> lsetObservable(String key, long index, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.lset(key, index, value, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient ltrim(String key, long from, long to, Handler<AsyncResult<String>> handler) {
        this.delegate.ltrim(key, from, to, handler);
        return this;
    }

    public Observable<String> ltrimObservable(String key, long from, long to) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.ltrim(key, from, to, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient mget(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.mget(key, handler);
        return this;
    }

    public Observable<JsonArray> mgetObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.mget(key, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient mgetMany(List<String> keys, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.mgetMany(keys, handler);
        return this;
    }

    public Observable<JsonArray> mgetManyObservable(List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.mgetMany(keys, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient migrate(String host, int port, String key, int destdb, long timeout, MigrateOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.migrate(host, port, key, destdb, timeout, options, handler);
        return this;
    }

    public Observable<String> migrateObservable(String host, int port, String key, int destdb, long timeout, MigrateOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.migrate(host, port, key, destdb, timeout, options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient monitor(Handler<AsyncResult<Void>> handler) {
        this.delegate.monitor(handler);
        return this;
    }

    public Observable<Void> monitorObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.monitor((Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public RedisClient move(String key, int destdb, Handler<AsyncResult<Long>> handler) {
        this.delegate.move(key, destdb, handler);
        return this;
    }

    public Observable<Long> moveObservable(String key, int destdb) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.move(key, destdb, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient mset(JsonObject keyvals, Handler<AsyncResult<String>> handler) {
        this.delegate.mset(keyvals, handler);
        return this;
    }

    public Observable<String> msetObservable(JsonObject keyvals) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.mset(keyvals, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient msetnx(JsonObject keyvals, Handler<AsyncResult<Long>> handler) {
        this.delegate.msetnx(keyvals, handler);
        return this;
    }

    public Observable<Long> msetnxObservable(JsonObject keyvals) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.msetnx(keyvals, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient object(String key, ObjectCmd cmd, Handler<AsyncResult<Void>> handler) {
        this.delegate.object(key, cmd, handler);
        return this;
    }

    public Observable<Void> objectObservable(String key, ObjectCmd cmd) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.object(key, cmd, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public RedisClient persist(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.persist(key, handler);
        return this;
    }

    public Observable<Long> persistObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.persist(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient pexpire(String key, long millis, Handler<AsyncResult<Long>> handler) {
        this.delegate.pexpire(key, millis, handler);
        return this;
    }

    public Observable<Long> pexpireObservable(String key, long millis) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pexpire(key, millis, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient pexpireat(String key, long millis, Handler<AsyncResult<Long>> handler) {
        this.delegate.pexpireat(key, millis, handler);
        return this;
    }

    public Observable<Long> pexpireatObservable(String key, long millis) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pexpireat(key, millis, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient pfadd(String key, String element, Handler<AsyncResult<Long>> handler) {
        this.delegate.pfadd(key, element, handler);
        return this;
    }

    public Observable<Long> pfaddObservable(String key, String element) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pfadd(key, element, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient pfaddMany(String key, List<String> elements, Handler<AsyncResult<Long>> handler) {
        this.delegate.pfaddMany(key, elements, handler);
        return this;
    }

    public Observable<Long> pfaddManyObservable(String key, List<String> elements) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pfaddMany(key, elements, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient pfcount(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.pfcount(key, handler);
        return this;
    }

    public Observable<Long> pfcountObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pfcount(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient pfcountMany(List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.pfcountMany(keys, handler);
        return this;
    }

    public Observable<Long> pfcountManyObservable(List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pfcountMany(keys, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient pfmerge(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.pfmerge(destkey, keys, handler);
        return this;
    }

    public Observable<String> pfmergeObservable(String destkey, List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pfmerge(destkey, keys, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient ping(Handler<AsyncResult<String>> handler) {
        this.delegate.ping(handler);
        return this;
    }

    public Observable<String> pingObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.ping((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient psetex(String key, long millis, String value, Handler<AsyncResult<Void>> handler) {
        this.delegate.psetex(key, millis, value, handler);
        return this;
    }

    public Observable<Void> psetexObservable(String key, long millis, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.psetex(key, millis, value, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public RedisClient psubscribe(String pattern, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.psubscribe(pattern, handler);
        return this;
    }

    public Observable<JsonArray> psubscribeObservable(String pattern) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.psubscribe(pattern, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient psubscribeMany(List<String> patterns, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.psubscribeMany(patterns, handler);
        return this;
    }

    public Observable<JsonArray> psubscribeManyObservable(List<String> patterns) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.psubscribeMany(patterns, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient pubsubChannels(String pattern, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.pubsubChannels(pattern, handler);
        return this;
    }

    public Observable<JsonArray> pubsubChannelsObservable(String pattern) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pubsubChannels(pattern, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient pubsubNumsub(List<String> channels, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.pubsubNumsub(channels, handler);
        return this;
    }

    public Observable<JsonArray> pubsubNumsubObservable(List<String> channels) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pubsubNumsub(channels, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient pubsubNumpat(Handler<AsyncResult<Long>> handler) {
        this.delegate.pubsubNumpat(handler);
        return this;
    }

    public Observable<Long> pubsubNumpatObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pubsubNumpat((Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient pttl(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.pttl(key, handler);
        return this;
    }

    public Observable<Long> pttlObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.pttl(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient publish(String channel, String message, Handler<AsyncResult<Long>> handler) {
        this.delegate.publish(channel, message, handler);
        return this;
    }

    public Observable<Long> publishObservable(String channel, String message) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.publish(channel, message, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient punsubscribe(List<String> patterns, Handler<AsyncResult<Void>> handler) {
        this.delegate.punsubscribe(patterns, handler);
        return this;
    }

    public Observable<Void> punsubscribeObservable(List<String> patterns) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.punsubscribe(patterns, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public RedisClient randomkey(Handler<AsyncResult<String>> handler) {
        this.delegate.randomkey(handler);
        return this;
    }

    public Observable<String> randomkeyObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.randomkey((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient rename(String key, String newkey, Handler<AsyncResult<String>> handler) {
        this.delegate.rename(key, newkey, handler);
        return this;
    }

    public Observable<String> renameObservable(String key, String newkey) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.rename(key, newkey, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient renamenx(String key, String newkey, Handler<AsyncResult<Long>> handler) {
        this.delegate.renamenx(key, newkey, handler);
        return this;
    }

    public Observable<Long> renamenxObservable(String key, String newkey) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.renamenx(key, newkey, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient restore(String key, long millis, String serialized, Handler<AsyncResult<String>> handler) {
        this.delegate.restore(key, millis, serialized, handler);
        return this;
    }

    public Observable<String> restoreObservable(String key, long millis, String serialized) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.restore(key, millis, serialized, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient role(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.role(handler);
        return this;
    }

    public Observable<JsonArray> roleObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.role((Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient rpop(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.rpop(key, handler);
        return this;
    }

    public Observable<String> rpopObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.rpop(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient rpoplpush(String key, String destkey, Handler<AsyncResult<String>> handler) {
        this.delegate.rpoplpush(key, destkey, handler);
        return this;
    }

    public Observable<String> rpoplpushObservable(String key, String destkey) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.rpoplpush(key, destkey, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient rpushMany(String key, List<String> values, Handler<AsyncResult<Long>> handler) {
        this.delegate.rpushMany(key, values, handler);
        return this;
    }

    public Observable<Long> rpushManyObservable(String key, List<String> values) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.rpushMany(key, values, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient rpush(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.rpush(key, value, handler);
        return this;
    }

    public Observable<Long> rpushObservable(String key, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.rpush(key, value, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient rpushx(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.rpushx(key, value, handler);
        return this;
    }

    public Observable<Long> rpushxObservable(String key, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.rpushx(key, value, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient sadd(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.sadd(key, member, handler);
        return this;
    }

    public Observable<Long> saddObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sadd(key, member, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient saddMany(String key, List<String> members, Handler<AsyncResult<Long>> handler) {
        this.delegate.saddMany(key, members, handler);
        return this;
    }

    public Observable<Long> saddManyObservable(String key, List<String> members) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.saddMany(key, members, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient save(Handler<AsyncResult<String>> handler) {
        this.delegate.save(handler);
        return this;
    }

    public Observable<String> saveObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.save((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient scard(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.scard(key, handler);
        return this;
    }

    public Observable<Long> scardObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.scard(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient scriptExists(String script, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.scriptExists(script, handler);
        return this;
    }

    public Observable<JsonArray> scriptExistsObservable(String script) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.scriptExists(script, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient scriptExistsMany(List<String> scripts, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.scriptExistsMany(scripts, handler);
        return this;
    }

    public Observable<JsonArray> scriptExistsManyObservable(List<String> scripts) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.scriptExistsMany(scripts, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient scriptFlush(Handler<AsyncResult<String>> handler) {
        this.delegate.scriptFlush(handler);
        return this;
    }

    public Observable<String> scriptFlushObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.scriptFlush((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient scriptKill(Handler<AsyncResult<String>> handler) {
        this.delegate.scriptKill(handler);
        return this;
    }

    public Observable<String> scriptKillObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.scriptKill((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient scriptLoad(String script, Handler<AsyncResult<String>> handler) {
        this.delegate.scriptLoad(script, handler);
        return this;
    }

    public Observable<String> scriptLoadObservable(String script) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.scriptLoad(script, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient sdiff(String key, List<String> cmpkeys, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.sdiff(key, cmpkeys, handler);
        return this;
    }

    public Observable<JsonArray> sdiffObservable(String key, List<String> cmpkeys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sdiff(key, cmpkeys, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient sdiffstore(String destkey, String key, List<String> cmpkeys, Handler<AsyncResult<Long>> handler) {
        this.delegate.sdiffstore(destkey, key, cmpkeys, handler);
        return this;
    }

    public Observable<Long> sdiffstoreObservable(String destkey, String key, List<String> cmpkeys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sdiffstore(destkey, key, cmpkeys, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient select(int dbindex, Handler<AsyncResult<String>> handler) {
        this.delegate.select(dbindex, handler);
        return this;
    }

    public Observable<String> selectObservable(int dbindex) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.select(dbindex, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient set(String key, String value, Handler<AsyncResult<Void>> handler) {
        this.delegate.set(key, value, handler);
        return this;
    }

    public Observable<Void> setObservable(String key, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.set(key, value, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public RedisClient setWithOptions(String key, String value, SetOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.setWithOptions(key, value, options, handler);
        return this;
    }

    public Observable<String> setWithOptionsObservable(String key, String value, SetOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.setWithOptions(key, value, options, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient setBinary(String key, io.vertx.rxjava.core.buffer.Buffer value, Handler<AsyncResult<Void>> handler) {
        this.delegate.setBinary(key, (Buffer)value.getDelegate(), handler);
        return this;
    }

    public Observable<Void> setBinaryObservable(String key, io.vertx.rxjava.core.buffer.Buffer value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.setBinary(key, value, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public RedisClient setBinaryWithOptions(String key, io.vertx.rxjava.core.buffer.Buffer value, SetOptions options, Handler<AsyncResult<Void>> handler) {
        this.delegate.setBinaryWithOptions(key, (Buffer)value.getDelegate(), options, handler);
        return this;
    }

    public Observable<Void> setBinaryWithOptionsObservable(String key, io.vertx.rxjava.core.buffer.Buffer value, SetOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.setBinaryWithOptions(key, value, options, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public RedisClient setbit(String key, long offset, int bit, Handler<AsyncResult<Long>> handler) {
        this.delegate.setbit(key, offset, bit, handler);
        return this;
    }

    public Observable<Long> setbitObservable(String key, long offset, int bit) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.setbit(key, offset, bit, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient setex(String key, long seconds, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.setex(key, seconds, value, handler);
        return this;
    }

    public Observable<String> setexObservable(String key, long seconds, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.setex(key, seconds, value, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient setnx(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.setnx(key, value, handler);
        return this;
    }

    public Observable<Long> setnxObservable(String key, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.setnx(key, value, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient setrange(String key, int offset, String value, Handler<AsyncResult<Long>> handler) {
        this.delegate.setrange(key, offset, value, handler);
        return this;
    }

    public Observable<Long> setrangeObservable(String key, int offset, String value) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.setrange(key, offset, value, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient sinter(List<String> keys, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.sinter(keys, handler);
        return this;
    }

    public Observable<JsonArray> sinterObservable(List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sinter(keys, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient sinterstore(String destkey, List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.sinterstore(destkey, keys, handler);
        return this;
    }

    public Observable<Long> sinterstoreObservable(String destkey, List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sinterstore(destkey, keys, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient sismember(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.sismember(key, member, handler);
        return this;
    }

    public Observable<Long> sismemberObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sismember(key, member, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient slaveof(String host, int port, Handler<AsyncResult<String>> handler) {
        this.delegate.slaveof(host, port, handler);
        return this;
    }

    public Observable<String> slaveofObservable(String host, int port) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.slaveof(host, port, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient slaveofNoone(Handler<AsyncResult<String>> handler) {
        this.delegate.slaveofNoone(handler);
        return this;
    }

    public Observable<String> slaveofNooneObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.slaveofNoone((Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient slowlogGet(int limit, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.slowlogGet(limit, handler);
        return this;
    }

    public Observable<JsonArray> slowlogGetObservable(int limit) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.slowlogGet(limit, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient slowlogLen(Handler<AsyncResult<Long>> handler) {
        this.delegate.slowlogLen(handler);
        return this;
    }

    public Observable<Long> slowlogLenObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.slowlogLen((Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient slowlogReset(Handler<AsyncResult<Void>> handler) {
        this.delegate.slowlogReset(handler);
        return this;
    }

    public Observable<Void> slowlogResetObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.slowlogReset((Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public RedisClient smembers(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.smembers(key, handler);
        return this;
    }

    public Observable<JsonArray> smembersObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.smembers(key, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient smove(String key, String destkey, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.smove(key, destkey, member, handler);
        return this;
    }

    public Observable<Long> smoveObservable(String key, String destkey, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.smove(key, destkey, member, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient sort(String key, SortOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.sort(key, options, handler);
        return this;
    }

    public Observable<JsonArray> sortObservable(String key, SortOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sort(key, options, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient spop(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.spop(key, handler);
        return this;
    }

    public Observable<String> spopObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.spop(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient spopMany(String key, int count, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.spopMany(key, count, handler);
        return this;
    }

    public Observable<JsonArray> spopManyObservable(String key, int count) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.spopMany(key, count, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient srandmember(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.srandmember(key, handler);
        return this;
    }

    public Observable<String> srandmemberObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.srandmember(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient srandmemberCount(String key, int count, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.srandmemberCount(key, count, handler);
        return this;
    }

    public Observable<JsonArray> srandmemberCountObservable(String key, int count) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.srandmemberCount(key, count, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient srem(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.srem(key, member, handler);
        return this;
    }

    public Observable<Long> sremObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.srem(key, member, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient sremMany(String key, List<String> members, Handler<AsyncResult<Long>> handler) {
        this.delegate.sremMany(key, members, handler);
        return this;
    }

    public Observable<Long> sremManyObservable(String key, List<String> members) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sremMany(key, members, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient strlen(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.strlen(key, handler);
        return this;
    }

    public Observable<Long> strlenObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.strlen(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient subscribe(String channel, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.subscribe(channel, handler);
        return this;
    }

    public Observable<JsonArray> subscribeObservable(String channel) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.subscribe(channel, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient subscribeMany(List<String> channels, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.subscribeMany(channels, handler);
        return this;
    }

    public Observable<JsonArray> subscribeManyObservable(List<String> channels) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.subscribeMany(channels, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient sunion(List<String> keys, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.sunion(keys, handler);
        return this;
    }

    public Observable<JsonArray> sunionObservable(List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sunion(keys, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient sunionstore(String destkey, List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.delegate.sunionstore(destkey, keys, handler);
        return this;
    }

    public Observable<Long> sunionstoreObservable(String destkey, List<String> keys) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sunionstore(destkey, keys, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient sync(Handler<AsyncResult<Void>> handler) {
        this.delegate.sync(handler);
        return this;
    }

    public Observable<Void> syncObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sync((Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public RedisClient time(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.time(handler);
        return this;
    }

    public Observable<JsonArray> timeObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.time((Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisTransaction transaction() {
        RedisTransaction ret = RedisTransaction.newInstance(this.delegate.transaction());
        return ret;
    }

    public RedisClient ttl(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.ttl(key, handler);
        return this;
    }

    public Observable<Long> ttlObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.ttl(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient type(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.type(key, handler);
        return this;
    }

    public Observable<String> typeObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.type(key, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient unsubscribe(List<String> channels, Handler<AsyncResult<Void>> handler) {
        this.delegate.unsubscribe(channels, handler);
        return this;
    }

    public Observable<Void> unsubscribeObservable(List<String> channels) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.unsubscribe(channels, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public RedisClient wait(long numSlaves, long timeout, Handler<AsyncResult<String>> handler) {
        this.delegate.wait(numSlaves, timeout, handler);
        return this;
    }

    public Observable<String> waitObservable(long numSlaves, long timeout) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.wait(numSlaves, timeout, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient zadd(String key, double score, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.zadd(key, score, member, handler);
        return this;
    }

    public Observable<Long> zaddObservable(String key, double score, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zadd(key, score, member, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient zaddMany(String key, Map<String, Double> members, Handler<AsyncResult<Long>> handler) {
        this.delegate.zaddMany(key, members, handler);
        return this;
    }

    public Observable<Long> zaddManyObservable(String key, Map<String, Double> members) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zaddMany(key, members, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient zcard(String key, Handler<AsyncResult<Long>> handler) {
        this.delegate.zcard(key, handler);
        return this;
    }

    public Observable<Long> zcardObservable(String key) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zcard(key, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient zcount(String key, double min, double max, Handler<AsyncResult<Long>> handler) {
        this.delegate.zcount(key, min, max, handler);
        return this;
    }

    public Observable<Long> zcountObservable(String key, double min, double max) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zcount(key, min, max, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient zincrby(String key, double increment, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.zincrby(key, increment, member, handler);
        return this;
    }

    public Observable<String> zincrbyObservable(String key, double increment, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zincrby(key, increment, member, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient zinterstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.delegate.zinterstore(destkey, sets, options, handler);
        return this;
    }

    public Observable<Long> zinterstoreObservable(String destkey, List<String> sets, AggregateOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zinterstore(destkey, sets, options, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient zinterstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.delegate.zinterstoreWeighed(destkey, sets, options, handler);
        return this;
    }

    public Observable<Long> zinterstoreWeighedObservable(String destkey, Map<String, Double> sets, AggregateOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zinterstoreWeighed(destkey, sets, options, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient zlexcount(String key, String min, String max, Handler<AsyncResult<Long>> handler) {
        this.delegate.zlexcount(key, min, max, handler);
        return this;
    }

    public Observable<Long> zlexcountObservable(String key, String min, String max) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zlexcount(key, min, max, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient zrange(String key, long start, long stop, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrange(key, start, stop, handler);
        return this;
    }

    public Observable<JsonArray> zrangeObservable(String key, long start, long stop) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrange(key, start, stop, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient zrangeWithOptions(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrangeWithOptions(key, start, stop, options, handler);
        return this;
    }

    public Observable<JsonArray> zrangeWithOptionsObservable(String key, long start, long stop, RangeOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrangeWithOptions(key, start, stop, options, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient zrangebylex(String key, String min, String max, LimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrangebylex(key, min, max, options, handler);
        return this;
    }

    public Observable<JsonArray> zrangebylexObservable(String key, String min, String max, LimitOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrangebylex(key, min, max, options, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient zrangebyscore(String key, String min, String max, RangeLimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrangebyscore(key, min, max, options, handler);
        return this;
    }

    public Observable<JsonArray> zrangebyscoreObservable(String key, String min, String max, RangeLimitOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrangebyscore(key, min, max, options, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient zrank(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.zrank(key, member, handler);
        return this;
    }

    public Observable<Long> zrankObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrank(key, member, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient zrem(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.zrem(key, member, handler);
        return this;
    }

    public Observable<Long> zremObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrem(key, member, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient zremMany(String key, List<String> members, Handler<AsyncResult<Long>> handler) {
        this.delegate.zremMany(key, members, handler);
        return this;
    }

    public Observable<Long> zremManyObservable(String key, List<String> members) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zremMany(key, members, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient zremrangebylex(String key, String min, String max, Handler<AsyncResult<Long>> handler) {
        this.delegate.zremrangebylex(key, min, max, handler);
        return this;
    }

    public Observable<Long> zremrangebylexObservable(String key, String min, String max) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zremrangebylex(key, min, max, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient zremrangebyrank(String key, long start, long stop, Handler<AsyncResult<Long>> handler) {
        this.delegate.zremrangebyrank(key, start, stop, handler);
        return this;
    }

    public Observable<Long> zremrangebyrankObservable(String key, long start, long stop) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zremrangebyrank(key, start, stop, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient zremrangebyscore(String key, String min, String max, Handler<AsyncResult<Long>> handler) {
        this.delegate.zremrangebyscore(key, min, max, handler);
        return this;
    }

    public Observable<Long> zremrangebyscoreObservable(String key, String min, String max) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zremrangebyscore(key, min, max, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient zrevrange(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrevrange(key, start, stop, options, handler);
        return this;
    }

    public Observable<JsonArray> zrevrangeObservable(String key, long start, long stop, RangeOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrevrange(key, start, stop, options, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient zrevrangebylex(String key, String max, String min, LimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrevrangebylex(key, max, min, options, handler);
        return this;
    }

    public Observable<JsonArray> zrevrangebylexObservable(String key, String max, String min, LimitOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrevrangebylex(key, max, min, options, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient zrevrangebyscore(String key, String max, String min, RangeLimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zrevrangebyscore(key, max, min, options, handler);
        return this;
    }

    public Observable<JsonArray> zrevrangebyscoreObservable(String key, String max, String min, RangeLimitOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrevrangebyscore(key, max, min, options, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient zrevrank(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.zrevrank(key, member, handler);
        return this;
    }

    public Observable<Long> zrevrankObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zrevrank(key, member, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient zscore(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.zscore(key, member, handler);
        return this;
    }

    public Observable<String> zscoreObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zscore(key, member, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient zunionstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.delegate.zunionstore(destkey, sets, options, handler);
        return this;
    }

    public Observable<Long> zunionstoreObservable(String destkey, List<String> sets, AggregateOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zunionstore(destkey, sets, options, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient zunionstoreWeighed(String key, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.delegate.zunionstoreWeighed(key, sets, options, handler);
        return this;
    }

    public Observable<Long> zunionstoreWeighedObservable(String key, Map<String, Double> sets, AggregateOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zunionstoreWeighed(key, sets, options, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient scan(String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.scan(cursor, options, handler);
        return this;
    }

    public Observable<JsonArray> scanObservable(String cursor, ScanOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.scan(cursor, options, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient sscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.sscan(key, cursor, options, handler);
        return this;
    }

    public Observable<JsonArray> sscanObservable(String key, String cursor, ScanOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.sscan(key, cursor, options, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient hscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.hscan(key, cursor, options, handler);
        return this;
    }

    public Observable<JsonArray> hscanObservable(String key, String cursor, ScanOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.hscan(key, cursor, options, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient zscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.zscan(key, cursor, options, handler);
        return this;
    }

    public Observable<JsonArray> zscanObservable(String key, String cursor, ScanOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.zscan(key, cursor, options, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient geoadd(String key, double longitude, double latitude, String member, Handler<AsyncResult<Long>> handler) {
        this.delegate.geoadd(key, longitude, latitude, member, handler);
        return this;
    }

    public Observable<Long> geoaddObservable(String key, double longitude, double latitude, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.geoadd(key, longitude, latitude, member, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient geoaddMany(String key, List<GeoMember> members, Handler<AsyncResult<Long>> handler) {
        this.delegate.geoaddMany(key, members, handler);
        return this;
    }

    public Observable<Long> geoaddManyObservable(String key, List<GeoMember> members) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.geoaddMany(key, members, (Handler<AsyncResult<Long>>)handler.toHandler());
        return handler;
    }

    public RedisClient geohash(String key, String member, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.geohash(key, member, handler);
        return this;
    }

    public Observable<JsonArray> geohashObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.geohash(key, member, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient geohashMany(String key, List<String> members, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.geohashMany(key, members, handler);
        return this;
    }

    public Observable<JsonArray> geohashManyObservable(String key, List<String> members) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.geohashMany(key, members, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient geopos(String key, String member, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.geopos(key, member, handler);
        return this;
    }

    public Observable<JsonArray> geoposObservable(String key, String member) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.geopos(key, member, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient geoposMany(String key, List<String> members, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.geoposMany(key, members, handler);
        return this;
    }

    public Observable<JsonArray> geoposManyObservable(String key, List<String> members) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.geoposMany(key, members, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient geodist(String key, String member1, String member2, Handler<AsyncResult<String>> handler) {
        this.delegate.geodist(key, member1, member2, handler);
        return this;
    }

    public Observable<String> geodistObservable(String key, String member1, String member2) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.geodist(key, member1, member2, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient geodistWithUnit(String key, String member1, String member2, GeoUnit unit, Handler<AsyncResult<String>> handler) {
        this.delegate.geodistWithUnit(key, member1, member2, unit, handler);
        return this;
    }

    public Observable<String> geodistWithUnitObservable(String key, String member1, String member2, GeoUnit unit) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.geodistWithUnit(key, member1, member2, unit, (Handler<AsyncResult<String>>)handler.toHandler());
        return handler;
    }

    public RedisClient georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.georadius(key, longitude, latitude, radius, unit, handler);
        return this;
    }

    public Observable<JsonArray> georadiusObservable(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.georadius(key, longitude, latitude, radius, unit, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient georadiusWithOptions(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.georadiusWithOptions(key, longitude, latitude, radius, unit, options, handler);
        return this;
    }

    public Observable<JsonArray> georadiusWithOptionsObservable(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.georadiusWithOptions(key, longitude, latitude, radius, unit, options, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient georadiusbymember(String key, String member, double radius, GeoUnit unit, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.georadiusbymember(key, member, radius, unit, handler);
        return this;
    }

    public Observable<JsonArray> georadiusbymemberObservable(String key, String member, double radius, GeoUnit unit) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.georadiusbymember(key, member, radius, unit, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public RedisClient georadiusbymemberWithOptions(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.georadiusbymemberWithOptions(key, member, radius, unit, options, handler);
        return this;
    }

    public Observable<JsonArray> georadiusbymemberWithOptionsObservable(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.georadiusbymemberWithOptions(key, member, radius, unit, options, (Handler<AsyncResult<JsonArray>>)handler.toHandler());
        return handler;
    }

    public static RedisClient newInstance(io.vertx.redis.RedisClient arg) {
        return arg != null ? new RedisClient(arg) : null;
    }
}

