/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.asyncsql.impl;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Objects;
import scala.concurrent.ExecutionContext;

public class VertxEventLoopExecutionContext
implements ExecutionContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxEventLoopExecutionContext.class);
    private final Context context;
    private final Handler<Throwable> errorHandler;

    public static ExecutionContext create(Vertx vertx) {
        return new VertxEventLoopExecutionContext(vertx, (Handler<Throwable>)((Handler)ex -> LOGGER.error((Object)"An exception occurred", ex)));
    }

    public static ExecutionContext create(Vertx vertx, Handler<Throwable> handler) {
        return new VertxEventLoopExecutionContext(vertx, handler);
    }

    private VertxEventLoopExecutionContext(Vertx vertx, Handler<Throwable> errorHandler) {
        Objects.requireNonNull(errorHandler);
        Objects.requireNonNull(vertx);
        Context ctx = Vertx.currentContext();
        if (ctx == null) {
            ctx = vertx.getOrCreateContext();
        }
        this.context = ctx;
        this.errorHandler = errorHandler;
    }

    public void execute(Runnable runnable) {
        if (this.context == Vertx.currentContext()) {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                this.reportFailure(e);
            }
        } else {
            this.context.runOnContext(v -> {
                try {
                    runnable.run();
                }
                catch (Throwable e) {
                    this.reportFailure(e);
                }
            });
        }
    }

    public void reportFailure(Throwable cause) {
        this.errorHandler.handle((Object)cause);
    }

    public ExecutionContext prepare() {
        return this;
    }
}

