/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import io.vertx.ext.jdbc.impl.actions.AbstractJDBCAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class JDBCExecute
extends AbstractJDBCAction<Void> {
    private final String sql;
    private final int timeout;

    public JDBCExecute(Vertx vertx, Connection connection, WorkerExecutor exec, int timeout, String sql) {
        super(vertx, connection, exec);
        this.sql = sql;
        this.timeout = timeout;
    }

    @Override
    protected Void execute() throws SQLException {
        try (Statement stmt = this.conn.createStatement();){
            boolean isResultSet;
            if (this.timeout >= 0) {
                stmt.setQueryTimeout(this.timeout);
            }
            if (isResultSet = stmt.execute(this.sql)) {
                while (stmt.getMoreResults()) {
                    ResultSet rs = stmt.getResultSet();
                    Throwable throwable = null;
                    if (rs == null) continue;
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    rs.close();
                }
            }
            Void void_ = null;
            return void_;
        }
    }

    @Override
    protected String name() {
        return "execute";
    }
}

