/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.hazelcast.impl;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import java.io.IOException;

class ConversionUtils {
    ConversionUtils() {
    }

    static <T> T convertParam(T obj) {
        if (obj instanceof ClusterSerializable) {
            ClusterSerializable cobj = (ClusterSerializable)obj;
            return (T)new DataSerializableHolder(cobj);
        }
        return obj;
    }

    static <T> T convertReturn(Object obj) {
        if (obj instanceof DataSerializableHolder) {
            DataSerializableHolder cobj = (DataSerializableHolder)obj;
            return (T)cobj.clusterSerializable();
        }
        return (T)obj;
    }

    private static final class DataSerializableHolder
    implements DataSerializable {
        private ClusterSerializable clusterSerializable;

        public DataSerializableHolder() {
        }

        private DataSerializableHolder(ClusterSerializable clusterSerializable) {
            this.clusterSerializable = clusterSerializable;
        }

        public void writeData(ObjectDataOutput objectDataOutput) throws IOException {
            objectDataOutput.writeUTF(this.clusterSerializable.getClass().getName());
            Buffer buffer = Buffer.buffer();
            this.clusterSerializable.writeToBuffer(buffer);
            byte[] bytes = buffer.getBytes();
            objectDataOutput.writeInt(bytes.length);
            objectDataOutput.write(bytes);
        }

        public void readData(ObjectDataInput objectDataInput) throws IOException {
            String className = objectDataInput.readUTF();
            int length = objectDataInput.readInt();
            byte[] bytes = new byte[length];
            objectDataInput.readFully(bytes);
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                this.clusterSerializable = (ClusterSerializable)clazz.newInstance();
                this.clusterSerializable.readFromBuffer(0, Buffer.buffer((byte[])bytes));
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to load class " + e.getMessage(), e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DataSerializableHolder)) {
                return false;
            }
            DataSerializableHolder that = (DataSerializableHolder)o;
            return !(this.clusterSerializable != null ? !this.clusterSerializable.equals(that.clusterSerializable) : that.clusterSerializable != null);
        }

        public int hashCode() {
            return this.clusterSerializable != null ? this.clusterSerializable.hashCode() : 0;
        }

        public ClusterSerializable clusterSerializable() {
            return this.clusterSerializable;
        }
    }
}

