/*
 * Copyright (c) 2011-2014 The original author or authors
 * ------------------------------------------------------
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Apache License v2.0 which accompanies this distribution.
 *
 *     The Eclipse Public License is available at
 *     http://www.eclipse.org/legal/epl-v10.html
 *
 *     The Apache License v2.0 is available at
 *     http://www.opensource.org/licenses/apache2.0.php
 *
 * You may elect to redistribute this code under either of these licenses.
 */

package io.vertx.core.impl;

import io.vertx.core.Future;
import io.vertx.core.spi.FutureFactory;

/**
 * @author <a href="http://tfox.org">Tim Fox</a>
 */
public class FutureFactoryImpl implements FutureFactory {

  @Override
  public <T> Future<T> future() {
    return new FutureImpl<>();
  }

  // TODO - for completed futures with null values we could maybe reuse a static instance to save allocation
  @Override
  public <T> Future<T> succeededFuture() {
    return new FutureImpl<>((T)null);
  }

  @Override
  public <T> Future<T> succeededFuture(T result) {
    return new FutureImpl<>(result);
  }

  @Override
  public <T> Future<T> failedFuture(Throwable t) {
    return new FutureImpl<>(t);
  }

  @Override
  public <T> Future<T> failureFuture(String failureMessage) {
    return new FutureImpl<>(failureMessage);
  }
}
