/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.AbstractServerConnection;
import io.undertow.server.Connectors;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RenegotiationRequiredException;
import io.undertow.server.SSLSessionInfo;
import io.undertow.server.protocol.http.HttpServerConnection;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.security.cert.Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.Options;
import org.xnio.SslClientAuthMode;
import org.xnio.channels.Channels;
import org.xnio.channels.SslChannel;
import org.xnio.channels.StreamSourceChannel;

public class ConnectionSSLSessionInfo
implements SSLSessionInfo {
    private static final long MAX_RENEGOTIATION_WAIT = 30000L;
    private final SslChannel channel;
    private final HttpServerConnection serverConnection;

    public ConnectionSSLSessionInfo(SslChannel channel, HttpServerConnection serverConnection) {
        this.channel = channel;
        this.serverConnection = serverConnection;
    }

    @Override
    public byte[] getSessionId() {
        return this.channel.getSslSession().getId();
    }

    @Override
    public String getCipherSuite() {
        return this.channel.getSslSession().getCipherSuite();
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException, RenegotiationRequiredException {
        try {
            return this.channel.getSslSession().getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException e) {
            try {
                SslClientAuthMode sslClientAuthMode = (SslClientAuthMode)this.channel.getOption(Options.SSL_CLIENT_AUTH_MODE);
                if (sslClientAuthMode == SslClientAuthMode.NOT_REQUESTED) {
                    throw new RenegotiationRequiredException();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public void renegotiate(HttpServerExchange exchange, SslClientAuthMode sslClientAuthMode) throws IOException {
        if (exchange.isRequestComplete()) {
            this.renegotiateNoRequest(exchange, sslClientAuthMode);
        } else {
            this.renegotiateBufferRequest(exchange, sslClientAuthMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renegotiateBufferRequest(HttpServerExchange exchange, SslClientAuthMode newAuthMode) throws IOException {
        int maxSize = exchange.getConnection().getUndertowOptions().get(UndertowOptions.MAX_BUFFERED_REQUEST_SIZE, 16384);
        if (maxSize <= 0) {
            throw new SSLPeerUnverifiedException("");
        }
        boolean requestResetRequired = false;
        StreamSourceChannel requestChannel = Connectors.getExistingRequestChannel(exchange);
        if (requestChannel == null) {
            requestChannel = exchange.getRequestChannel();
            requestResetRequired = true;
        }
        PooledByteBuffer pooled = exchange.getConnection().getByteBufferPool().allocate();
        boolean free = true;
        int usedBuffers = 0;
        PooledByteBuffer[] poolArray = null;
        int bufferSize = pooled.getBuffer().remaining();
        int allowedBuffers = (maxSize + bufferSize - 1) / bufferSize;
        poolArray = new PooledByteBuffer[allowedBuffers];
        poolArray[usedBuffers++] = pooled;
        try {
            int res;
            do {
                ByteBuffer buf = pooled.getBuffer();
                res = Channels.readBlocking((ReadableByteChannel)requestChannel, (ByteBuffer)buf);
                if (buf.hasRemaining()) continue;
                if (usedBuffers == allowedBuffers) {
                    throw new SSLPeerUnverifiedException("");
                }
                buf.flip();
                pooled = exchange.getConnection().getByteBufferPool().allocate();
                poolArray[usedBuffers++] = pooled;
            } while (res != -1);
            free = false;
            pooled.getBuffer().flip();
            Connectors.ungetRequestBytes(exchange, poolArray);
            this.renegotiateNoRequest(exchange, newAuthMode);
        }
        finally {
            if (free) {
                for (PooledByteBuffer buf : poolArray) {
                    if (buf == null) continue;
                    buf.close();
                }
            }
            if (requestResetRequired) {
                exchange.requestChannel = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renegotiateNoRequest(HttpServerExchange exchange, SslClientAuthMode newAuthMode) throws IOException {
        AbstractServerConnection.ConduitState oldState = this.serverConnection.resetChannel();
        try {
            SslClientAuthMode sslClientAuthMode = (SslClientAuthMode)this.channel.getOption(Options.SSL_CLIENT_AUTH_MODE);
            if (sslClientAuthMode == SslClientAuthMode.NOT_REQUESTED) {
                SslHandshakeWaiter waiter = new SslHandshakeWaiter();
                this.channel.getHandshakeSetter().set((ChannelListener)waiter);
                this.channel.setOption(Options.SSL_CLIENT_AUTH_MODE, (Object)newAuthMode);
                this.channel.getSslSession().invalidate();
                this.channel.startHandshake();
                this.serverConnection.getOriginalSinkConduit().flush();
                ByteBuffer buff = ByteBuffer.wrap(new byte[1]);
                long end = System.currentTimeMillis() + 30000L;
                while (!waiter.isDone() && this.serverConnection.isOpen() && System.currentTimeMillis() < end) {
                    int read = this.serverConnection.getSourceChannel().read(buff);
                    if (read != 0) {
                        throw new SSLPeerUnverifiedException("");
                    }
                    if (waiter.isDone()) continue;
                    this.serverConnection.getSourceChannel().awaitReadable(end - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                }
                if (!waiter.isDone()) {
                    if (this.serverConnection.isOpen()) {
                        IoUtils.safeClose((Closeable)((Object)this.serverConnection));
                        throw UndertowMessages.MESSAGES.rengotiationTimedOut();
                    }
                    IoUtils.safeClose((Closeable)((Object)this.serverConnection));
                    throw UndertowMessages.MESSAGES.rengotiationFailed();
                }
            }
        }
        finally {
            if (oldState != null) {
                this.serverConnection.restoreChannel(oldState);
            }
        }
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException, RenegotiationRequiredException {
        try {
            return this.channel.getSslSession().getPeerCertificateChain();
        }
        catch (SSLPeerUnverifiedException e) {
            try {
                SslClientAuthMode sslClientAuthMode = (SslClientAuthMode)this.channel.getOption(Options.SSL_CLIENT_AUTH_MODE);
                if (sslClientAuthMode == SslClientAuthMode.NOT_REQUESTED) {
                    throw new RenegotiationRequiredException();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    private static class SslHandshakeWaiter
    implements ChannelListener<SslChannel> {
        private volatile boolean done = false;

        private SslHandshakeWaiter() {
        }

        boolean isDone() {
            return this.done;
        }

        public void handleEvent(SslChannel channel) {
            this.done = true;
        }
    }
}

