/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins;

import io.tesla.proviso.archive.UnArchiver;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.wrapper.DefaultDownloader;

@Mojo(name="wrapper", requiresProject=false, aggregator=true)
public class WrapperMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="0.1.5", property="version")
    private String version;
    @Parameter(defaultValue="3.3.9", property="maven")
    private String maven;
    @Parameter(property="distributionUrl")
    private String distributionUrl;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File localRepository = new File(System.getProperty("user.home"), ".m2/repository");
        String artifactPath = String.format("io/takari/maven-wrapper/%s/maven-wrapper-%s.tar.gz", this.version, this.version);
        String wrapperUrl = String.format("http://repo1.maven.org/maven2/%s", artifactPath);
        File destination = new File(localRepository, artifactPath);
        DefaultDownloader downloader = new DefaultDownloader("mvnw", this.version);
        try {
            downloader.download(new URI(wrapperUrl), destination);
            UnArchiver unarchiver = UnArchiver.builder().useRoot(false).build();
            Path rootDirectory = Paths.get(this.session.getExecutionRootDirectory(), new String[0]);
            unarchiver.unarchive(destination, rootDirectory.toFile());
            this.overwriteDistributionUrl(rootDirectory, this.getDistributionUrl());
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"The Maven Wrapper has been successfully setup for your project.");
            this.getLog().info((CharSequence)"");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error installing the maven-wrapper archive.", e);
        }
    }

    private void overwriteDistributionUrl(Path rootDirectory, String distributionUrl) throws IOException {
        Path wrapperProperties;
        if (!WrapperMojo.isNullOrEmpty(distributionUrl) && Files.isWritable(wrapperProperties = rootDirectory.resolve(Paths.get(".mvn", "wrapper", "maven-wrapper.properties")))) {
            String distroKeyValue = "distributionUrl=" + distributionUrl;
            Files.write(wrapperProperties, distroKeyValue.getBytes(Charset.forName("UTF-8")), new OpenOption[0]);
        }
    }

    protected String getDistributionUrl() {
        if (WrapperMojo.isNullOrEmpty(this.distributionUrl) && !WrapperMojo.isNullOrEmpty(this.maven)) {
            this.distributionUrl = String.format("https://repo1.maven.org/maven2/org/apache/maven/apache-maven/%s/apache-maven-%s-bin.zip", this.maven, this.maven);
        }
        return this.distributionUrl;
    }

    private static boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }
}

