/*
 * Decompiled with CFR 0.152.
 */
package springfox.petstore.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import springfox.petstore.Responses;
import springfox.petstore.controller.NotFoundException;
import springfox.petstore.model.Pet;
import springfox.petstore.model.Pets;
import springfox.petstore.repository.MapBackedRepository;

@Controller
@RequestMapping(value={"/api/pet"}, produces={"application/json", "application/xml"})
@Api(value="/pet", description="Operations about pets")
public class PetController {
    PetRepository petData = new PetRepository();

    @RequestMapping(value={"/{petId}"}, method={RequestMethod.GET})
    @ApiOperation(value="Find pet by ID", notes="Returns a pet when ID < 10. ID > 10 or nonintegers will simulate API error conditions", response=Pet.class, authorizations={@Authorization(value="api_key"), @Authorization(value="petstore_auth", scopes={@AuthorizationScope(scope="write:pets", description=""), @AuthorizationScope(scope="read:pets", description="")})})
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid ID supplied"), @ApiResponse(code=404, message="Pet not found")})
    public ResponseEntity<Pet> getPetById(@ApiParam(value="ID of pet that needs to be fetched", allowableValues="range[1,5]", required=true) @PathVariable(value="petId") String petId) throws NotFoundException {
        Pet pet = (Pet)this.petData.get(Long.valueOf(petId));
        if (null != pet) {
            return Responses.ok(pet);
        }
        throw new NotFoundException(404, "Pet not found");
    }

    @RequestMapping(method={RequestMethod.POST})
    @ApiOperation(value="Add a new pet to the store", authorizations={@Authorization(value="petstore_auth", scopes={@AuthorizationScope(scope="write:pets", description=""), @AuthorizationScope(scope="read:pets", description="")})})
    @ApiResponses(value={@ApiResponse(code=405, message="Invalid input")})
    public ResponseEntity<String> addPet(@ApiParam(value="Pet object that needs to be added to the store", required=true) @RequestBody Pet pet) {
        this.petData.add(pet);
        return Responses.ok("SUCCESS");
    }

    @RequestMapping(method={RequestMethod.PUT})
    @ApiOperation(value="Update an existing pet", authorizations={@Authorization(value="petstore_auth", scopes={@AuthorizationScope(scope="write:pets", description=""), @AuthorizationScope(scope="read:pets", description="")})})
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid ID supplied"), @ApiResponse(code=404, message="Pet not found"), @ApiResponse(code=405, message="Validation exception")})
    public ResponseEntity<String> updatePet(@ApiParam(value="Pet object that needs to be added to the store", required=true) @RequestBody Pet pet) {
        this.petData.add(pet);
        return Responses.ok("SUCCESS");
    }

    @RequestMapping(value={"/findByStatus"}, method={RequestMethod.GET})
    @ApiOperation(value="Finds Pets by status", notes="Multiple status values can be provided with comma seperated strings", response=Pet.class, responseContainer="List", authorizations={@Authorization(value="petstore_auth", scopes={@AuthorizationScope(scope="write:pets", description=""), @AuthorizationScope(scope="read:pets", description="")})})
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid status value")})
    public ResponseEntity<List<Pet>> findPetsByStatus(@ApiParam(value="Status values that need to be considered for filter", required=true, defaultValue="available", allowableValues="available,pending,sold", allowMultiple=true) @RequestParam(value="status") String status) {
        return Responses.ok(this.petData.findPetByStatus(status));
    }

    @RequestMapping(value={"/findByTags"}, method={RequestMethod.GET})
    @ApiOperation(value="Finds Pets by tags", notes="Muliple tags can be provided with comma seperated strings. Use tag1, tag2, tag3 for testing.", response=Pet.class, responseContainer="List", authorizations={@Authorization(value="petstore_auth", scopes={@AuthorizationScope(scope="write:pets", description=""), @AuthorizationScope(scope="read:pets", description="")})})
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid tag value")})
    @Deprecated
    public ResponseEntity<List<Pet>> findPetsByTags(@ApiParam(value="Tags to filter by", required=true, allowMultiple=true) @RequestParam(value="tags") String tags) {
        return Responses.ok(this.petData.findPetByTags(tags));
    }

    static class PetRepository
    extends MapBackedRepository<Long, Pet> {
        PetRepository() {
        }

        public List<Pet> findPetByStatus(String status) {
            return this.where(Pets.statusIs(status));
        }

        public List<Pet> findPetByTags(String tags) {
            return this.where(Pets.tagsContain(tags));
        }
    }
}

