/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.functions.Action0;
import rx.internal.operators.BackpressureUtils;
import rx.internal.operators.NotificationLite;
import rx.internal.producers.ProducerArbiter;
import rx.observers.SerializedSubscriber;
import rx.subscriptions.SerialSubscription;
import rx.subscriptions.Subscriptions;

public final class OperatorConcat<T>
implements Observable.Operator<T, Observable<? extends T>> {
    public static <T> OperatorConcat<T> instance() {
        return Holder.INSTANCE;
    }

    OperatorConcat() {
    }

    @Override
    public Subscriber<? super Observable<? extends T>> call(Subscriber<? super T> child) {
        SerializedSubscriber<? super T> s = new SerializedSubscriber<T>(child);
        SerialSubscription current = new SerialSubscription();
        child.add(current);
        ConcatSubscriber<? super T> cs = new ConcatSubscriber<T>(s, current);
        ConcatProducer<? super T> cp = new ConcatProducer<T>(cs);
        child.setProducer(cp);
        return cs;
    }

    static class ConcatInnerSubscriber<T>
    extends Subscriber<T> {
        private final Subscriber<T> child;
        private final ConcatSubscriber<T> parent;
        private final AtomicBoolean once = new AtomicBoolean();
        private final ProducerArbiter arbiter;
        long produced;

        public ConcatInnerSubscriber(ConcatSubscriber<T> parent, Subscriber<T> child, ProducerArbiter arbiter) {
            this.parent = parent;
            this.child = child;
            this.arbiter = arbiter;
        }

        @Override
        public void onNext(T t) {
            ++this.produced;
            this.child.onNext(t);
        }

        @Override
        public void onError(Throwable e) {
            if (this.once.compareAndSet(false, true)) {
                this.parent.onError(e);
            }
        }

        @Override
        public void onCompleted() {
            if (this.once.compareAndSet(false, true)) {
                ConcatSubscriber<T> p = this.parent;
                p.produced(this.produced);
                p.completeInner();
            }
        }

        @Override
        public void setProducer(Producer producer) {
            this.arbiter.setProducer(producer);
        }
    }

    static final class ConcatSubscriber<T>
    extends Subscriber<Observable<? extends T>> {
        final NotificationLite<Observable<? extends T>> nl = NotificationLite.instance();
        private final Subscriber<T> child;
        private final SerialSubscription current;
        final ConcurrentLinkedQueue<Object> queue;
        volatile ConcatInnerSubscriber<T> currentSubscriber;
        final AtomicInteger wip = new AtomicInteger();
        private final AtomicLong requested = new AtomicLong();
        private final ProducerArbiter arbiter;

        public ConcatSubscriber(Subscriber<T> s, SerialSubscription current) {
            super(s);
            this.child = s;
            this.current = current;
            this.arbiter = new ProducerArbiter();
            this.queue = new ConcurrentLinkedQueue();
            this.add(Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    ConcatSubscriber.this.queue.clear();
                }
            }));
        }

        @Override
        public void onStart() {
            this.request(2L);
        }

        private void requestFromChild(long n) {
            if (n <= 0L) {
                return;
            }
            AtomicLong requestedField = this.requested;
            long previous = requestedField.get() != Long.MAX_VALUE ? BackpressureUtils.getAndAddRequest(requestedField, n) : Long.MAX_VALUE;
            this.arbiter.request(n);
            if (previous == 0L && this.currentSubscriber == null && this.wip.get() > 0) {
                this.subscribeNext();
            }
        }

        @Override
        public void onNext(Observable<? extends T> t) {
            this.queue.add(this.nl.next(t));
            if (this.wip.getAndIncrement() == 0) {
                this.subscribeNext();
            }
        }

        @Override
        public void onError(Throwable e) {
            this.child.onError(e);
            this.unsubscribe();
        }

        @Override
        public void onCompleted() {
            this.queue.add(this.nl.completed());
            if (this.wip.getAndIncrement() == 0) {
                this.subscribeNext();
            }
        }

        void completeInner() {
            this.currentSubscriber = null;
            if (this.wip.decrementAndGet() > 0) {
                this.subscribeNext();
            }
            this.request(1L);
        }

        void subscribeNext() {
            if (this.requested.get() > 0L) {
                Object o = this.queue.poll();
                if (this.nl.isCompleted(o)) {
                    this.child.onCompleted();
                } else if (o != null) {
                    Observable<T> obs = this.nl.getValue(o);
                    this.currentSubscriber = new ConcatInnerSubscriber<T>(this, this.child, this.arbiter);
                    this.current.set(this.currentSubscriber);
                    obs.unsafeSubscribe(this.currentSubscriber);
                }
            } else {
                Object o = this.queue.peek();
                if (this.nl.isCompleted(o)) {
                    this.child.onCompleted();
                }
            }
        }

        void produced(long c) {
            if (c != 0L) {
                this.arbiter.produced(c);
                BackpressureUtils.produced(this.requested, c);
            }
        }
    }

    static final class ConcatProducer<T>
    implements Producer {
        final ConcatSubscriber<T> cs;

        ConcatProducer(ConcatSubscriber<T> cs) {
            this.cs = cs;
        }

        @Override
        public void request(long n) {
            ((ConcatSubscriber)this.cs).requestFromChild(n);
        }
    }

    private static final class Holder {
        static final OperatorConcat<Object> INSTANCE = new OperatorConcat();

        private Holder() {
        }
    }
}

