/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.impl;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

abstract class AbstractSpan
implements Span,
SpanContext {
    private String operationName;
    private final Map<String, String> baggage = new HashMap<String, String>();
    private final Instant start;
    private Duration duration;
    private final Map<String, Object> tags = new HashMap<String, Object>();
    private final List<LogData> logs = new ArrayList<LogData>();

    AbstractSpan(String operationName) {
        this(operationName, Instant.now());
    }

    AbstractSpan(String operationName, Instant start) {
        this.operationName = operationName;
        this.start = start;
    }

    public final SpanContext context() {
        return this;
    }

    public void finish() {
        assert (null == this.duration);
        this.duration = Duration.between(this.start, Instant.now());
    }

    public void finish(long finishMicros) {
        long finishEpochSeconds = TimeUnit.MICROSECONDS.toSeconds(finishMicros);
        long nanos = TimeUnit.MICROSECONDS.toNanos(finishMicros) - TimeUnit.SECONDS.toNanos(finishEpochSeconds);
        assert (null == this.duration);
        this.duration = Duration.between(this.start, Instant.ofEpochSecond(finishEpochSeconds, nanos));
    }

    public final String getOperationName() {
        return this.operationName;
    }

    public Span setOperationName(String operationName) {
        this.operationName = operationName;
        return this;
    }

    public final Instant getStart() {
        return this.start;
    }

    public final Duration getDuration() {
        return this.duration;
    }

    public final void close() {
        this.finish();
    }

    public final Span setTag(String key, String value) {
        this.tags.put(key, value);
        return this;
    }

    public final Span setTag(String key, boolean value) {
        this.tags.put(key, value);
        return this;
    }

    public final Span setTag(String key, Number value) {
        this.tags.put(key, value);
        return this;
    }

    public final Map<String, Object> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    public AbstractSpan setBaggageItem(String key, String value) {
        this.baggage.put(key, value);
        return this;
    }

    public String getBaggageItem(String key) {
        return this.baggage.get(key);
    }

    public final Iterable<Map.Entry<String, String>> baggageItems() {
        return this.baggage.entrySet();
    }

    public final Map<String, String> getBaggage() {
        return Collections.unmodifiableMap(this.baggage);
    }

    public final Span log(String event) {
        return this.log(AbstractSpan.nowMicros(), event);
    }

    public final Span log(long timestampMicros, String event) {
        return this.log(timestampMicros, Collections.singletonMap("event", event));
    }

    public final Span log(Map<String, ?> fields) {
        return this.log(AbstractSpan.nowMicros(), fields);
    }

    public final Span log(long timestampMicros, Map<String, ?> fields) {
        Instant timestamp = Instant.ofEpochSecond(timestampMicros / 1000000L, timestampMicros % 1000000L * 1000L);
        this.logs.add(new LogData(timestamp, fields));
        return this;
    }

    public final Span log(String event, Object payload) {
        Instant now = Instant.now();
        return this.log(TimeUnit.SECONDS.toMicros(now.getEpochSecond()) + TimeUnit.NANOSECONDS.toMicros(now.getNano()), event, payload);
    }

    public final Span log(long timestampMicros, String event, Object payload) {
        Instant timestamp = Instant.ofEpochSecond(timestampMicros / 1000000L, timestampMicros % 1000000L * 1000L);
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("event", event);
        if (payload != null) {
            fields.put("payload", payload);
        }
        this.logs.add(new LogData(timestamp, fields));
        return this;
    }

    public final List<LogData> getLogs() {
        return Collections.unmodifiableList(this.logs);
    }

    static long nowMicros() {
        Instant now = Instant.now();
        return now.getEpochSecond() * 1000000L + (long)(now.getNano() / 1000);
    }

    final class LogData {
        private final Instant time;
        private final Map<String, ?> fields;

        LogData(Instant time, Map<String, ?> fields) {
            this.time = time;
            this.fields = fields;
        }
    }
}

