/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderDateFormat;
import io.netty.handler.codec.http.HttpHeaderEntity;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class HttpHeaders
implements Iterable<Map.Entry<String, String>> {
    private static final byte[] HEADER_SEPERATOR = new byte[]{58, 32};
    private static final byte[] CRLF = new byte[]{13, 10};
    public static final HttpHeaders EMPTY_HEADERS = new HttpHeaders(){

        @Override
        public String get(CharSequence name) {
            return null;
        }

        @Override
        public List<String> getAll(CharSequence name) {
            return Collections.emptyList();
        }

        @Override
        public List<Map.Entry<String, String>> entries() {
            return Collections.emptyList();
        }

        @Override
        public boolean contains(CharSequence name) {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Set<String> names() {
            return Collections.emptySet();
        }

        @Override
        public HttpHeaders add(CharSequence name, Object value) {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public HttpHeaders add(CharSequence name, Iterable<?> values) {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public HttpHeaders set(CharSequence name, Object value) {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public HttpHeaders set(CharSequence name, Iterable<?> values) {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public HttpHeaders remove(CharSequence name) {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public HttpHeaders clear() {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return this.entries().iterator();
        }
    };

    public static boolean isKeepAlive(HttpMessage message) {
        String connection = message.headers().get(Names.CONNECTION);
        if (connection != null && HttpHeaders.equalsIgnoreCase(Values.CLOSE, connection)) {
            return false;
        }
        if (message.getProtocolVersion().isKeepAliveDefault()) {
            return !HttpHeaders.equalsIgnoreCase(Values.CLOSE, connection);
        }
        return HttpHeaders.equalsIgnoreCase(Values.KEEP_ALIVE, connection);
    }

    public static void setKeepAlive(HttpMessage message, boolean keepAlive) {
        HttpHeaders h = message.headers();
        if (message.getProtocolVersion().isKeepAliveDefault()) {
            if (keepAlive) {
                h.remove(Names.CONNECTION);
            } else {
                h.set(Names.CONNECTION, Values.CLOSE);
            }
        } else if (keepAlive) {
            h.set(Names.CONNECTION, Values.KEEP_ALIVE);
        } else {
            h.remove(Names.CONNECTION);
        }
    }

    public static String getHeader(HttpMessage message, CharSequence name) {
        return message.headers().get(name);
    }

    public static String getHeader(HttpMessage message, CharSequence name, String defaultValue) {
        String value = message.headers().get(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static void setHeader(HttpMessage message, CharSequence name, Object value) {
        message.headers().set(name, value);
    }

    public static void setHeader(HttpMessage message, CharSequence name, Iterable<?> values) {
        message.headers().set(name, values);
    }

    public static void addHeader(HttpMessage message, CharSequence name, Object value) {
        message.headers().add(name, value);
    }

    public static void removeHeader(HttpMessage message, CharSequence name) {
        message.headers().remove(name);
    }

    public static void clearHeaders(HttpMessage message) {
        message.headers().clear();
    }

    public static int getIntHeader(HttpMessage message, CharSequence name) {
        String value = HttpHeaders.getHeader(message, name);
        if (value == null) {
            throw new NumberFormatException("header not found: " + name);
        }
        return Integer.parseInt(value);
    }

    public static int getIntHeader(HttpMessage message, CharSequence name, int defaultValue) {
        String value = HttpHeaders.getHeader(message, name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static void setIntHeader(HttpMessage message, CharSequence name, int value) {
        message.headers().set(name, value);
    }

    public static void setIntHeader(HttpMessage message, CharSequence name, Iterable<Integer> values) {
        message.headers().set(name, values);
    }

    public static void addIntHeader(HttpMessage message, CharSequence name, int value) {
        message.headers().add(name, value);
    }

    public static Date getDateHeader(HttpMessage message, CharSequence name) throws ParseException {
        String value = HttpHeaders.getHeader(message, name);
        if (value == null) {
            throw new ParseException("header not found: " + name, 0);
        }
        return HttpHeaderDateFormat.get().parse(value);
    }

    public static Date getDateHeader(HttpMessage message, CharSequence name, Date defaultValue) {
        String value = HttpHeaders.getHeader(message, name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return HttpHeaderDateFormat.get().parse(value);
        }
        catch (ParseException e) {
            return defaultValue;
        }
    }

    public static void setDateHeader(HttpMessage message, CharSequence name, Date value) {
        if (value != null) {
            message.headers().set(name, HttpHeaderDateFormat.get().format(value));
        } else {
            message.headers().set(name, null);
        }
    }

    public static void setDateHeader(HttpMessage message, CharSequence name, Iterable<Date> values) {
        message.headers().set(name, values);
    }

    public static void addDateHeader(HttpMessage message, CharSequence name, Date value) {
        message.headers().add(name, value);
    }

    public static long getContentLength(HttpMessage message) {
        String value = HttpHeaders.getHeader(message, Names.CONTENT_LENGTH);
        if (value != null) {
            return Long.parseLong(value);
        }
        long webSocketContentLength = HttpHeaders.getWebSocketContentLength(message);
        if (webSocketContentLength >= 0L) {
            return webSocketContentLength;
        }
        throw new NumberFormatException("header not found: " + Names.CONTENT_LENGTH);
    }

    public static long getContentLength(HttpMessage message, long defaultValue) {
        String contentLength = message.headers().get(Names.CONTENT_LENGTH);
        if (contentLength != null) {
            try {
                return Long.parseLong(contentLength);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        long webSocketContentLength = HttpHeaders.getWebSocketContentLength(message);
        if (webSocketContentLength >= 0L) {
            return webSocketContentLength;
        }
        return defaultValue;
    }

    private static int getWebSocketContentLength(HttpMessage message) {
        HttpResponse res;
        HttpHeaders h = message.headers();
        if (message instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)message;
            if (HttpMethod.GET.equals(req.getMethod()) && h.contains(Names.SEC_WEBSOCKET_KEY1) && h.contains(Names.SEC_WEBSOCKET_KEY2)) {
                return 8;
            }
        } else if (message instanceof HttpResponse && (res = (HttpResponse)message).getStatus().code() == 101 && h.contains(Names.SEC_WEBSOCKET_ORIGIN) && h.contains(Names.SEC_WEBSOCKET_LOCATION)) {
            return 16;
        }
        return -1;
    }

    public static void setContentLength(HttpMessage message, long length) {
        message.headers().set(Names.CONTENT_LENGTH, length);
    }

    public static String getHost(HttpMessage message) {
        return message.headers().get(Names.HOST);
    }

    public static String getHost(HttpMessage message, String defaultValue) {
        return HttpHeaders.getHeader(message, Names.HOST, defaultValue);
    }

    public static void setHost(HttpMessage message, String value) {
        message.headers().set(Names.HOST, value);
    }

    public static Date getDate(HttpMessage message) throws ParseException {
        return HttpHeaders.getDateHeader(message, Names.DATE);
    }

    public static Date getDate(HttpMessage message, Date defaultValue) {
        return HttpHeaders.getDateHeader(message, Names.DATE, defaultValue);
    }

    public static void setDate(HttpMessage message, Date value) {
        if (value != null) {
            message.headers().set(Names.DATE, HttpHeaderDateFormat.get().format(value));
        } else {
            message.headers().set(Names.DATE, null);
        }
    }

    public static boolean is100ContinueExpected(HttpMessage message) {
        if (!(message instanceof HttpRequest)) {
            return false;
        }
        if (message.getProtocolVersion().compareTo(HttpVersion.HTTP_1_1) < 0) {
            return false;
        }
        String value = message.headers().get(Names.EXPECT);
        if (value == null) {
            return false;
        }
        if (HttpHeaders.equalsIgnoreCase(Values.CONTINUE, value)) {
            return true;
        }
        return message.headers().contains(Names.EXPECT, Values.CONTINUE, true);
    }

    public static void set100ContinueExpected(HttpMessage message) {
        HttpHeaders.set100ContinueExpected(message, true);
    }

    public static void set100ContinueExpected(HttpMessage message, boolean set) {
        if (set) {
            message.headers().set(Names.EXPECT, Values.CONTINUE);
        } else {
            message.headers().remove(Names.EXPECT);
        }
    }

    static void validateHeaderName(CharSequence headerName) {
        if (headerName == null) {
            throw new NullPointerException("Header names cannot be null");
        }
        for (int index = 0; index < headerName.length(); ++index) {
            char character = headerName.charAt(index);
            if (character > '\u007f') {
                throw new IllegalArgumentException("Header name cannot contain non-ASCII characters: " + headerName);
            }
            switch (character) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ':': 
                case ';': 
                case '=': {
                    throw new IllegalArgumentException("Header name cannot contain the following prohibited characters: =,;: \\t\\r\\n\\v\\f: " + headerName);
                }
            }
        }
    }

    static void validateHeaderValue(CharSequence headerValue) {
        if (headerValue == null) {
            throw new NullPointerException("Header values cannot be null");
        }
        int state = 0;
        block19: for (int index = 0; index < headerValue.length(); ++index) {
            char character = headerValue.charAt(index);
            switch (character) {
                case '\u000b': {
                    throw new IllegalArgumentException("Header value contains a prohibited character '\\v': " + headerValue);
                }
                case '\f': {
                    throw new IllegalArgumentException("Header value contains a prohibited character '\\f': " + headerValue);
                }
            }
            switch (state) {
                case 0: {
                    switch (character) {
                        case '\r': {
                            state = 1;
                            break;
                        }
                        case '\n': {
                            state = 2;
                        }
                    }
                    continue block19;
                }
                case 1: {
                    switch (character) {
                        case '\n': {
                            state = 2;
                            continue block19;
                        }
                    }
                    throw new IllegalArgumentException("Only '\\n' is allowed after '\\r': " + headerValue);
                }
                case 2: {
                    switch (character) {
                        case '\t': 
                        case ' ': {
                            state = 0;
                            continue block19;
                        }
                    }
                    throw new IllegalArgumentException("Only ' ' and '\\t' are allowed after '\\n': " + headerValue);
                }
            }
        }
        if (state != 0) {
            throw new IllegalArgumentException("Header value must not end with '\\r' or '\\n':" + headerValue);
        }
    }

    public static boolean isTransferEncodingChunked(HttpMessage message) {
        return message.headers().contains(Names.TRANSFER_ENCODING, Values.CHUNKED, true);
    }

    public static void removeTransferEncodingChunked(HttpMessage m) {
        List<String> values = m.headers().getAll(Names.TRANSFER_ENCODING);
        if (values.isEmpty()) {
            return;
        }
        Iterator<String> valuesIt = values.iterator();
        while (valuesIt.hasNext()) {
            String value = valuesIt.next();
            if (!HttpHeaders.equalsIgnoreCase(value, Values.CHUNKED)) continue;
            valuesIt.remove();
        }
        if (values.isEmpty()) {
            m.headers().remove(Names.TRANSFER_ENCODING);
        } else {
            m.headers().set(Names.TRANSFER_ENCODING, values);
        }
    }

    public static void setTransferEncodingChunked(HttpMessage m) {
        HttpHeaders.addHeader(m, Names.TRANSFER_ENCODING, Values.CHUNKED);
        HttpHeaders.removeHeader(m, Names.CONTENT_LENGTH);
    }

    public static boolean isContentLengthSet(HttpMessage m) {
        return m.headers().contains(Names.CONTENT_LENGTH);
    }

    public static boolean equalsIgnoreCase(CharSequence name1, CharSequence name2) {
        if (name1 == name2) {
            return true;
        }
        if (name1 == null || name2 == null) {
            return false;
        }
        int nameLen = name1.length();
        if (nameLen != name2.length()) {
            return false;
        }
        for (int i = nameLen - 1; i >= 0; --i) {
            char c2;
            char c1 = name1.charAt(i);
            if (c1 == (c2 = name2.charAt(i))) continue;
            if (c1 >= 'A' && c1 <= 'Z') {
                c1 = (char)(c1 + 32);
            }
            if (c2 >= 'A' && c2 <= 'Z') {
                c2 = (char)(c2 + 32);
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }

    static int hash(CharSequence name) {
        if (name instanceof HttpHeaderEntity) {
            return ((HttpHeaderEntity)name).hash();
        }
        int h = 0;
        for (int i = name.length() - 1; i >= 0; --i) {
            char c = name.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            h = 31 * h + c;
        }
        if (h > 0) {
            return h;
        }
        if (h == Integer.MIN_VALUE) {
            return Integer.MAX_VALUE;
        }
        return -h;
    }

    static void encode(HttpHeaders headers, ByteBuf buf) {
        if (headers instanceof DefaultHttpHeaders) {
            ((DefaultHttpHeaders)headers).encode(buf);
        } else {
            for (Map.Entry header : headers) {
                HttpHeaders.encode((CharSequence)header.getKey(), (CharSequence)header.getValue(), buf);
            }
        }
    }

    static void encode(CharSequence key, CharSequence value, ByteBuf buf) {
        HttpHeaders.encodeAscii(key, buf);
        buf.writeBytes(HEADER_SEPERATOR);
        HttpHeaders.encodeAscii(value, buf);
        buf.writeBytes(CRLF);
    }

    public static void encodeAscii(CharSequence seq, ByteBuf buf) {
        if (seq instanceof HttpHeaderEntity) {
            ((HttpHeaderEntity)seq).encode(buf);
        } else {
            HttpHeaders.encodeAscii0(seq, buf);
        }
    }

    static void encodeAscii0(CharSequence seq, ByteBuf buf) {
        int length = seq.length();
        for (int i = 0; i < length; ++i) {
            buf.writeByte((byte)seq.charAt(i));
        }
    }

    public static CharSequence newEntity(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return new HttpHeaderEntity(name);
    }

    protected HttpHeaders() {
    }

    public abstract String get(CharSequence var1);

    public abstract List<String> getAll(CharSequence var1);

    public abstract List<Map.Entry<String, String>> entries();

    public abstract boolean contains(CharSequence var1);

    public abstract boolean isEmpty();

    public abstract Set<String> names();

    public abstract HttpHeaders add(CharSequence var1, Object var2);

    public abstract HttpHeaders add(CharSequence var1, Iterable<?> var2);

    public HttpHeaders add(HttpHeaders headers) {
        if (headers == null) {
            throw new NullPointerException("headers");
        }
        for (Map.Entry e : headers) {
            this.add((CharSequence)e.getKey(), e.getValue());
        }
        return this;
    }

    public abstract HttpHeaders set(CharSequence var1, Object var2);

    public abstract HttpHeaders set(CharSequence var1, Iterable<?> var2);

    public HttpHeaders set(HttpHeaders headers) {
        if (headers == null) {
            throw new NullPointerException("headers");
        }
        this.clear();
        for (Map.Entry e : headers) {
            this.add((CharSequence)e.getKey(), e.getValue());
        }
        return this;
    }

    public abstract HttpHeaders remove(CharSequence var1);

    public abstract HttpHeaders clear();

    public boolean contains(CharSequence name, CharSequence value, boolean ignoreCaseValue) {
        List<String> values = this.getAll(name);
        if (values.isEmpty()) {
            return false;
        }
        for (String v : values) {
            if (!(ignoreCaseValue ? HttpHeaders.equalsIgnoreCase(v, value) : v.equals(value))) continue;
            return true;
        }
        return false;
    }

    public static final class Values {
        public static final CharSequence APPLICATION_X_WWW_FORM_URLENCODED = HttpHeaders.newEntity("application/x-www-form-urlencoded");
        public static final CharSequence BASE64 = HttpHeaders.newEntity("base64");
        public static final CharSequence BINARY = HttpHeaders.newEntity("binary");
        public static final CharSequence BOUNDARY = HttpHeaders.newEntity("boundary");
        public static final CharSequence BYTES = HttpHeaders.newEntity("bytes");
        public static final CharSequence CHARSET = HttpHeaders.newEntity("charset");
        public static final CharSequence CHUNKED = HttpHeaders.newEntity("chunked");
        public static final CharSequence CLOSE = HttpHeaders.newEntity("close");
        public static final CharSequence COMPRESS = HttpHeaders.newEntity("compress");
        public static final CharSequence CONTINUE = HttpHeaders.newEntity("100-continue");
        public static final CharSequence DEFLATE = HttpHeaders.newEntity("deflate");
        public static final CharSequence GZIP = HttpHeaders.newEntity("gzip");
        public static final CharSequence IDENTITY = HttpHeaders.newEntity("identity");
        public static final CharSequence KEEP_ALIVE = HttpHeaders.newEntity("keep-alive");
        public static final CharSequence MAX_AGE = HttpHeaders.newEntity("max-age");
        public static final CharSequence MAX_STALE = HttpHeaders.newEntity("max-stale");
        public static final CharSequence MIN_FRESH = HttpHeaders.newEntity("min-fresh");
        public static final CharSequence MULTIPART_FORM_DATA = HttpHeaders.newEntity("multipart/form-data");
        public static final CharSequence MUST_REVALIDATE = HttpHeaders.newEntity("must-revalidate");
        public static final CharSequence NO_CACHE = HttpHeaders.newEntity("no-cache");
        public static final CharSequence NO_STORE = HttpHeaders.newEntity("no-store");
        public static final CharSequence NO_TRANSFORM = HttpHeaders.newEntity("no-transform");
        public static final CharSequence NONE = HttpHeaders.newEntity("none");
        public static final CharSequence ONLY_IF_CACHED = HttpHeaders.newEntity("only-if-cached");
        public static final CharSequence PRIVATE = HttpHeaders.newEntity("private");
        public static final CharSequence PROXY_REVALIDATE = HttpHeaders.newEntity("proxy-revalidate");
        public static final CharSequence PUBLIC = HttpHeaders.newEntity("public");
        public static final CharSequence QUOTED_PRINTABLE = HttpHeaders.newEntity("quoted-printable");
        public static final CharSequence S_MAXAGE = HttpHeaders.newEntity("s-maxage");
        public static final CharSequence TRAILERS = HttpHeaders.newEntity("trailers");
        public static final CharSequence UPGRADE = HttpHeaders.newEntity("Upgrade");
        public static final CharSequence WEBSOCKET = HttpHeaders.newEntity("WebSocket");

        private Values() {
        }
    }

    public static final class Names {
        public static final CharSequence ACCEPT = HttpHeaders.newEntity("Accept");
        public static final CharSequence ACCEPT_CHARSET = HttpHeaders.newEntity("Accept-Charset");
        public static final CharSequence ACCEPT_ENCODING = HttpHeaders.newEntity("Accept-Encoding");
        public static final CharSequence ACCEPT_LANGUAGE = HttpHeaders.newEntity("Accept-Language");
        public static final CharSequence ACCEPT_RANGES = HttpHeaders.newEntity("Accept-Ranges");
        public static final CharSequence ACCEPT_PATCH = HttpHeaders.newEntity("Accept-Patch");
        public static final CharSequence ACCESS_CONTROL_ALLOW_CREDENTIALS = HttpHeaders.newEntity("Access-Control-Allow-Credentials");
        public static final CharSequence ACCESS_CONTROL_ALLOW_HEADERS = HttpHeaders.newEntity("Access-Control-Allow-Headers");
        public static final CharSequence ACCESS_CONTROL_ALLOW_METHODS = HttpHeaders.newEntity("Access-Control-Allow-Methods");
        public static final CharSequence ACCESS_CONTROL_ALLOW_ORIGIN = HttpHeaders.newEntity("Access-Control-Allow-Origin");
        public static final CharSequence ACCESS_CONTROL_EXPOSE_HEADERS = HttpHeaders.newEntity("Access-Control-Expose-Headers");
        public static final CharSequence ACCESS_CONTROL_MAX_AGE = HttpHeaders.newEntity("Access-Control-Max-Age");
        public static final CharSequence ACCESS_CONTROL_REQUEST_HEADERS = HttpHeaders.newEntity("Access-Control-Request-Headers");
        public static final CharSequence ACCESS_CONTROL_REQUEST_METHOD = HttpHeaders.newEntity("Access-Control-Request-Method");
        public static final CharSequence AGE = HttpHeaders.newEntity("Age");
        public static final CharSequence ALLOW = HttpHeaders.newEntity("Allow");
        public static final CharSequence AUTHORIZATION = HttpHeaders.newEntity("Authorization");
        public static final CharSequence CACHE_CONTROL = HttpHeaders.newEntity("Cache-Control");
        public static final CharSequence CONNECTION = HttpHeaders.newEntity("Connection");
        public static final CharSequence CONTENT_BASE = HttpHeaders.newEntity("Content-Base");
        public static final CharSequence CONTENT_ENCODING = HttpHeaders.newEntity("Content-Encoding");
        public static final CharSequence CONTENT_LANGUAGE = HttpHeaders.newEntity("Content-Language");
        public static final CharSequence CONTENT_LENGTH = HttpHeaders.newEntity("Content-Length");
        public static final CharSequence CONTENT_LOCATION = HttpHeaders.newEntity("Content-Location");
        public static final CharSequence CONTENT_TRANSFER_ENCODING = HttpHeaders.newEntity("Content-Transfer-Encoding");
        public static final CharSequence CONTENT_MD5 = HttpHeaders.newEntity("Content-MD5");
        public static final CharSequence CONTENT_RANGE = HttpHeaders.newEntity("Content-Range");
        public static final CharSequence CONTENT_TYPE = HttpHeaders.newEntity("Content-Type");
        public static final CharSequence COOKIE = HttpHeaders.newEntity("Cookie");
        public static final CharSequence DATE = HttpHeaders.newEntity("Date");
        public static final CharSequence ETAG = HttpHeaders.newEntity("ETag");
        public static final CharSequence EXPECT = HttpHeaders.newEntity("Expect");
        public static final CharSequence EXPIRES = HttpHeaders.newEntity("Expires");
        public static final CharSequence FROM = HttpHeaders.newEntity("From");
        public static final CharSequence HOST = HttpHeaders.newEntity("Host");
        public static final CharSequence IF_MATCH = HttpHeaders.newEntity("If-Match");
        public static final CharSequence IF_MODIFIED_SINCE = HttpHeaders.newEntity("If-Modified-Since");
        public static final CharSequence IF_NONE_MATCH = HttpHeaders.newEntity("If-None-Match");
        public static final CharSequence IF_RANGE = HttpHeaders.newEntity("If-Range");
        public static final CharSequence IF_UNMODIFIED_SINCE = HttpHeaders.newEntity("If-Unmodified-Since");
        public static final CharSequence LAST_MODIFIED = HttpHeaders.newEntity("Last-Modified");
        public static final CharSequence LOCATION = HttpHeaders.newEntity("Location");
        public static final CharSequence MAX_FORWARDS = HttpHeaders.newEntity("Max-Forwards");
        public static final CharSequence ORIGIN = HttpHeaders.newEntity("Origin");
        public static final CharSequence PRAGMA = HttpHeaders.newEntity("Pragma");
        public static final CharSequence PROXY_AUTHENTICATE = HttpHeaders.newEntity("Proxy-Authenticate");
        public static final CharSequence PROXY_AUTHORIZATION = HttpHeaders.newEntity("Proxy-Authorization");
        public static final CharSequence RANGE = HttpHeaders.newEntity("Range");
        public static final CharSequence REFERER = HttpHeaders.newEntity("Referer");
        public static final CharSequence RETRY_AFTER = HttpHeaders.newEntity("Retry-After");
        public static final CharSequence SEC_WEBSOCKET_KEY1 = HttpHeaders.newEntity("Sec-WebSocket-Key1");
        public static final CharSequence SEC_WEBSOCKET_KEY2 = HttpHeaders.newEntity("Sec-WebSocket-Key2");
        public static final CharSequence SEC_WEBSOCKET_LOCATION = HttpHeaders.newEntity("Sec-WebSocket-Location");
        public static final CharSequence SEC_WEBSOCKET_ORIGIN = HttpHeaders.newEntity("Sec-WebSocket-Origin");
        public static final CharSequence SEC_WEBSOCKET_PROTOCOL = HttpHeaders.newEntity("Sec-WebSocket-Protocol");
        public static final CharSequence SEC_WEBSOCKET_VERSION = HttpHeaders.newEntity("Sec-WebSocket-Version");
        public static final CharSequence SEC_WEBSOCKET_KEY = HttpHeaders.newEntity("Sec-WebSocket-Key");
        public static final CharSequence SEC_WEBSOCKET_ACCEPT = HttpHeaders.newEntity("Sec-WebSocket-Accept");
        public static final CharSequence SERVER = HttpHeaders.newEntity("Server");
        public static final CharSequence SET_COOKIE = HttpHeaders.newEntity("Set-Cookie");
        public static final CharSequence SET_COOKIE2 = HttpHeaders.newEntity("Set-Cookie2");
        public static final CharSequence TE = HttpHeaders.newEntity("TE");
        public static final CharSequence TRAILER = HttpHeaders.newEntity("Trailer");
        public static final CharSequence TRANSFER_ENCODING = HttpHeaders.newEntity("Transfer-Encoding");
        public static final CharSequence UPGRADE = HttpHeaders.newEntity("Upgrade");
        public static final CharSequence USER_AGENT = HttpHeaders.newEntity("User-Agent");
        public static final CharSequence VARY = HttpHeaders.newEntity("Vary");
        public static final CharSequence VIA = HttpHeaders.newEntity("Via");
        public static final CharSequence WARNING = HttpHeaders.newEntity("Warning");
        public static final CharSequence WEBSOCKET_LOCATION = HttpHeaders.newEntity("WebSocket-Location");
        public static final CharSequence WEBSOCKET_ORIGIN = HttpHeaders.newEntity("WebSocket-Origin");
        public static final CharSequence WEBSOCKET_PROTOCOL = HttpHeaders.newEntity("WebSocket-Protocol");
        public static final CharSequence WWW_AUTHENTICATE = HttpHeaders.newEntity("WWW-Authenticate");

        private Names() {
        }
    }
}

