/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd;

import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.internal.DefaultMeter;
import io.micrometer.core.instrument.util.DoubleFormat;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.core.lang.Nullable;
import io.micrometer.shaded.org.reactorstreams.Processor;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.org.reactorstreams.Subscriber;
import io.micrometer.shaded.org.reactorstreams.Subscription;
import io.micrometer.shaded.reactor.core.Disposable;
import io.micrometer.shaded.reactor.core.Disposables;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.UnicastProcessor;
import io.micrometer.shaded.reactor.ipc.netty.NettyPipeline;
import io.micrometer.shaded.reactor.ipc.netty.udp.UdpClient;
import io.micrometer.shaded.reactor.ipc.netty.udp.UdpInbound;
import io.micrometer.shaded.reactor.ipc.netty.udp.UdpOutbound;
import io.micrometer.shaded.reactor.util.concurrent.Queues;
import io.micrometer.statsd.StatsdConfig;
import io.micrometer.statsd.StatsdCounter;
import io.micrometer.statsd.StatsdDistributionSummary;
import io.micrometer.statsd.StatsdFlavor;
import io.micrometer.statsd.StatsdFunctionCounter;
import io.micrometer.statsd.StatsdFunctionTimer;
import io.micrometer.statsd.StatsdGauge;
import io.micrometer.statsd.StatsdLineBuilder;
import io.micrometer.statsd.StatsdLongTaskTimer;
import io.micrometer.statsd.StatsdPollable;
import io.micrometer.statsd.StatsdTimer;
import io.micrometer.statsd.internal.FlavorStatsdLineBuilder;
import io.micrometer.statsd.internal.LogbackMetricsSuppressingUnicastProcessor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

public class StatsdMeterRegistry
extends MeterRegistry {
    private final StatsdConfig statsdConfig;
    private final HierarchicalNameMapper nameMapper;
    private final Collection<StatsdPollable> pollableMeters = new CopyOnWriteArrayList<StatsdPollable>();
    Processor<String, String> publisher;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private Disposable.Swap udpClient = Disposables.swap();
    private Disposable.Swap meterPoller = Disposables.swap();
    @Nullable
    private Function<Meter.Id, StatsdLineBuilder> lineBuilderFunction;
    @Nullable
    private Consumer<String> lineSink;

    public StatsdMeterRegistry(StatsdConfig config, Clock clock) {
        this(config, HierarchicalNameMapper.DEFAULT, clock);
    }

    public StatsdMeterRegistry(StatsdConfig config, HierarchicalNameMapper nameMapper, Clock clock) {
        this(config, nameMapper, StatsdMeterRegistry.namingConventionFromFlavor(config.flavor()), clock, null, null);
    }

    public static Builder builder(StatsdConfig config) {
        return new Builder(config);
    }

    private StatsdMeterRegistry(StatsdConfig config, HierarchicalNameMapper nameMapper, NamingConvention namingConvention, Clock clock, @Nullable Function<Meter.Id, StatsdLineBuilder> lineBuilderFunction, final @Nullable Consumer<String> lineSink) {
        super(clock);
        this.statsdConfig = config;
        this.nameMapper = nameMapper;
        this.lineBuilderFunction = lineBuilderFunction;
        this.lineSink = lineSink;
        this.config().namingConvention(namingConvention);
        UnicastProcessor<String> processor = UnicastProcessor.create(Queues.unboundedMultiproducer().get());
        try {
            Class.forName("ch.qos.logback.classic.turbo.TurboFilter", false, ((Object)((Object)this)).getClass().getClassLoader());
            this.publisher = new LogbackMetricsSuppressingUnicastProcessor(processor);
        }
        catch (ClassNotFoundException e) {
            this.publisher = processor;
        }
        if (lineSink != null) {
            this.publisher.subscribe(new Subscriber<String>(){

                @Override
                public void onSubscribe(Subscription s) {
                    s.request(Long.MAX_VALUE);
                }

                @Override
                public void onNext(String line) {
                    if (StatsdMeterRegistry.this.started.get()) {
                        lineSink.accept(line);
                    }
                }

                @Override
                public void onError(Throwable t) {
                }

                @Override
                public void onComplete() {
                    StatsdMeterRegistry.this.meterPoller.dispose();
                }
            });
            this.meterPoller.replace(Flux.interval(this.statsdConfig.pollingFrequency()).doOnEach(n -> this.pollableMeters.forEach(StatsdPollable::poll)).subscribe());
        }
        if (config.enabled()) {
            this.start();
        }
    }

    public void start() {
        if (this.started.compareAndSet(false, true) && this.lineSink == null) {
            UdpClient.create(this.statsdConfig.host(), this.statsdConfig.port()).newHandler((BiFunction<? super UdpInbound, ? super UdpOutbound, ? extends Publisher<Void>>)((BiFunction<UdpInbound, UdpOutbound, Publisher>)(in, out) -> out.options(NettyPipeline.SendOptions::flushOnEach).sendString(this.publisher).neverComplete())).subscribe(client -> {
                this.udpClient.replace((Disposable)client);
                this.meterPoller.replace(Flux.interval(this.statsdConfig.pollingFrequency()).doOnEach(n -> this.pollableMeters.forEach(StatsdPollable::poll)).subscribe());
            });
        }
    }

    public void stop() {
        if (this.started.compareAndSet(true, false)) {
            this.udpClient.dispose();
            this.meterPoller.dispose();
        }
    }

    public void close() {
        this.stop();
        super.close();
    }

    protected <T> Gauge newGauge(Meter.Id id, @Nullable T obj, ToDoubleFunction<T> valueFunction) {
        StatsdGauge<T> gauge = new StatsdGauge<T>(id, this.lineBuilder(id), this.publisher, obj, valueFunction, this.statsdConfig.publishUnchangedMeters());
        this.pollableMeters.add(gauge);
        return gauge;
    }

    private StatsdLineBuilder lineBuilder(Meter.Id id) {
        if (this.lineBuilderFunction == null) {
            this.lineBuilderFunction = id2 -> new FlavorStatsdLineBuilder((Meter.Id)id2, this.statsdConfig.flavor(), this.nameMapper, this.config());
        }
        return this.lineBuilderFunction.apply(id);
    }

    protected Counter newCounter(Meter.Id id) {
        return new StatsdCounter(id, this.lineBuilder(id), this.publisher);
    }

    protected LongTaskTimer newLongTaskTimer(Meter.Id id) {
        StatsdLongTaskTimer ltt = new StatsdLongTaskTimer(id, this.lineBuilder(id), this.publisher, this.clock, this.statsdConfig.publishUnchangedMeters());
        this.pollableMeters.add(ltt);
        return ltt;
    }

    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        StatsdTimer timer = new StatsdTimer(id, this.lineBuilder(id), this.publisher, this.clock, distributionStatisticConfig, pauseDetector, this.getBaseTimeUnit(), this.statsdConfig.step().toMillis());
        if (distributionStatisticConfig.getPercentiles() != null) {
            for (double percentile : distributionStatisticConfig.getPercentiles()) {
                this.gauge(id.getName() + ".percentile", (Iterable)Tags.concat((Iterable)this.getConventionTags(id), (String[])new String[]{"phi", DoubleFormat.decimalOrNan((double)percentile)}), (Object)timer, t -> t.percentile(percentile, this.getBaseTimeUnit()));
            }
        }
        Object object = distributionStatisticConfig.getHistogramBuckets(false).iterator();
        while (object.hasNext()) {
            Long bucket = (Long)object.next();
            Tags bucketTags = Tags.concat((Iterable)this.getConventionTags(id), (String[])new String[]{"le", DoubleFormat.decimalOrWhole((double)TimeUtils.nanosToUnit((double)bucket.longValue(), (TimeUnit)this.getBaseTimeUnit()))});
            this.gauge(id.getName() + ".histogram", (Iterable)bucketTags, (Object)timer, t -> t.histogramCountAtValue(bucket.longValue()));
        }
        return timer;
    }

    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        StatsdDistributionSummary summary = new StatsdDistributionSummary(id, this.lineBuilder(id), this.publisher, this.clock, distributionStatisticConfig, scale);
        if (distributionStatisticConfig.getPercentiles() != null) {
            for (double percentile : distributionStatisticConfig.getPercentiles()) {
                this.gauge(id.getName() + ".percentile", (Iterable)Tags.concat((Iterable)this.getConventionTags(id), (String[])new String[]{"phi", DoubleFormat.decimalOrNan((double)percentile)}), (Object)summary, s -> s.percentile(percentile));
            }
        }
        Object object = distributionStatisticConfig.getHistogramBuckets(false).iterator();
        while (object.hasNext()) {
            Long bucket = (Long)object.next();
            Tags bucketTags = Tags.concat((Iterable)this.getConventionTags(id), (String[])new String[]{"le", DoubleFormat.decimalOrWhole((double)bucket.longValue())});
            this.gauge(id.getName() + ".histogram", (Iterable)bucketTags, (Object)summary, s -> s.histogramCountAtValue(bucket.longValue()));
        }
        return summary;
    }

    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
        StatsdFunctionCounter<T> fc = new StatsdFunctionCounter<T>(id, obj, countFunction, this.lineBuilder(id), this.publisher);
        this.pollableMeters.add(fc);
        return fc;
    }

    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnits) {
        StatsdFunctionTimer<T> ft = new StatsdFunctionTimer<T>(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnits, this.getBaseTimeUnit(), this.lineBuilder(id), this.publisher);
        this.pollableMeters.add(ft);
        return ft;
    }

    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        measurements.forEach(ms -> {
            StatsdLineBuilder line = this.lineBuilder(id);
            switch (ms.getStatistic()) {
                case COUNT: 
                case TOTAL: 
                case TOTAL_TIME: {
                    this.pollableMeters.add(() -> this.publisher.onNext(line.count((long)ms.getValue(), ms.getStatistic())));
                    break;
                }
                case VALUE: 
                case ACTIVE_TASKS: 
                case DURATION: 
                case UNKNOWN: {
                    this.pollableMeters.add(() -> this.publisher.onNext(line.gauge(ms.getValue(), ms.getStatistic())));
                }
            }
        });
        return new DefaultMeter(id, type, measurements);
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(this.statsdConfig.step()).build().merge(DistributionStatisticConfig.DEFAULT);
    }

    public int queueSize() {
        try {
            return (Integer)this.publisher.getClass().getMethod("size", new Class[0]).invoke(this.publisher, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return 0;
        }
    }

    public int queueCapacity() {
        try {
            return (Integer)this.publisher.getClass().getMethod("getBufferSize", new Class[0]).invoke(this.publisher, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return 0;
        }
    }

    private static NamingConvention namingConventionFromFlavor(StatsdFlavor flavor) {
        switch (flavor) {
            case DATADOG: {
                return NamingConvention.dot;
            }
            case TELEGRAF: {
                return NamingConvention.snakeCase;
            }
        }
        return NamingConvention.camelCase;
    }

    @Incubating(since="1.0.1")
    public static class Builder {
        private final StatsdConfig config;
        private Clock clock = Clock.SYSTEM;
        private NamingConvention namingConvention;
        private HierarchicalNameMapper nameMapper = HierarchicalNameMapper.DEFAULT;
        @Nullable
        private Function<Meter.Id, StatsdLineBuilder> lineBuilderFunction = null;
        @Nullable
        private Consumer<String> lineSink;

        public Builder(StatsdConfig config) {
            this.config = config;
            this.namingConvention = StatsdMeterRegistry.namingConventionFromFlavor(config.flavor());
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder lineBuilder(Function<Meter.Id, StatsdLineBuilder> lineBuilderFunction) {
            this.lineBuilderFunction = lineBuilderFunction;
            return this;
        }

        public Builder nameMapper(HierarchicalNameMapper nameMapper) {
            this.nameMapper = nameMapper;
            return this;
        }

        public Builder lineSink(Consumer<String> lineSink) {
            this.lineSink = lineSink;
            return this;
        }

        public StatsdMeterRegistry build() {
            return new StatsdMeterRegistry(this.config, this.nameMapper, this.namingConvention, this.clock, this.lineBuilderFunction, this.lineSink);
        }
    }
}

