/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd;

import io.micrometer.core.instrument.AbstractDistributionSummary;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.util.MeterEquivalence;
import io.micrometer.core.instrument.util.TimeDecayingMax;
import io.micrometer.core.lang.Nullable;
import io.micrometer.shaded.org.reactorstreams.Subscriber;
import io.micrometer.statsd.StatsdLineBuilder;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;

public class StatsdDistributionSummary
extends AbstractDistributionSummary {
    private final LongAdder count = new LongAdder();
    private final DoubleAdder amount = new DoubleAdder();
    private final TimeDecayingMax max;
    private final StatsdLineBuilder lineBuilder;
    private final Subscriber<String> publisher;

    StatsdDistributionSummary(Meter.Id id, StatsdLineBuilder lineBuilder, Subscriber<String> publisher, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        super(id, clock, distributionStatisticConfig, scale);
        this.max = new TimeDecayingMax(clock, distributionStatisticConfig);
        this.lineBuilder = lineBuilder;
        this.publisher = publisher;
    }

    protected void recordNonNegative(double amount) {
        if (amount >= 0.0) {
            this.count.increment();
            this.amount.add(amount);
            this.max.record(amount);
            this.publisher.onNext(this.lineBuilder.histogram(amount));
        }
    }

    public long count() {
        return this.count.longValue();
    }

    public double totalAmount() {
        return this.amount.doubleValue();
    }

    public double max() {
        return this.max.poll();
    }

    public boolean equals(@Nullable Object o) {
        return MeterEquivalence.equals((Meter)this, (Object)o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode((Meter)this);
    }
}

